/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#define M_PUBLIC    0
#define M_OP        1
#define M_TOPIC     2

//char *get_word(GtkText * text, int deselect);
GtkWidget *create_online_popup(channel_user_t* cu);
void refresh_channels();

void
chat_print_network   (chat_page_t* page, int type,
		      net_t* net, int max_length, int num);
void
chat_print_channel   (chat_page_t* page, int message_type,
		      char* channel, net_t* net);
void
chat_print_url       (chat_page_t* page, int message_type,
		      char* url);
char* 
chat_print_nick      (chat_page_t* page, int message_type,
		      char* user, net_t* net);
GtkWidget*
chat_print_text      (chat_page_t * page, int message_type,
		      char *color, const char *text);
GtkWidget*
chat_print_text_w    (chat_page_t * page, int message_type,
		      char *color, char *text, int width);
void
chat_print_colored   (chat_page_t * page, int message_type,
		      char *base_color, const char *text);
void
chat_print_file      (chat_page_t* page, 
		      char* filename, char* text);
chat_page_t*
chat_print_current   (char* style, char* text);
void
chat_print_current_ln(char* style, char* text);
void
chat_print_time_stamp(chat_page_t* page, int message_type);

/////////

void join_channel(net_t* net, char *name);

void snap_to_bottom(GtkWidget * text);

void chat_page_down(chat_page_t * page);
void chat_page_up(chat_page_t * page);
chat_page_t* chat_page_get_printable();
void chat_page_set_active(chat_page_t * page, int active);
void chat_page_clear(chat_page_t * page, int where);

chat_page_t* create_private_page(net_t* net, char *name);

void send_global       (net_t* net, char *text);
void send_wallop       (net_t* net, char *text);
void send_chwallop     (chat_page_t* page, char *text);
void send_public_emote (net_t* net, char* channel, char *text);
void send_private_emote(net_t* net, char* channel, char *text);
void send_private      (net_t* net, char* nick, char *text, int show);
void send_notice       (net_t* net, char* nick, char *text, int show);
void send_public       (chat_page_t* page, char *text);
void send_afk          (net_t* net, char *user, afk_t * afk);

int check_server_join_quit(net_t* net, char *data);

void mark_user(chat_page_t* page, char *user,
	       GdkPixmap * pix, GdkBitmap * bit);
void update_user(net_t*, char *user);
void delete_user_list(GList ** glist);
channel_user_t* search_user_in_list(GtkCList * clist, 
				    char *user, int* row);
GList *user_search(char *user);
int user_search_full(chat_page_t* page, char *user);
void on_hide_show_clicked(GtkButton * button, gpointer user_data);

char *search_highlight_string(const char *string, int *len);
gint user_compare(GtkCList * clist,
		  gconstpointer ptr1, gconstpointer ptr2);
void highlight(chat_page_t * page, int high);

//
void set_afk(char *message);


chat_page_t *chat_page_get_current_main();
chat_page_t *chat_page_new(char* name, char *vname, int type, net_t* net);
void chat_page_destroy(chat_page_t * page);
void channel_join_ack(chat_page_t* page);
void chat_page_attach_to_main(chat_page_t * page);
void chat_page_attach_to_new(chat_page_t * page);
void chat_page_leave(chat_page_t * page, char* reason);
chat_page_t *chat_page_search2(char *name, int type);
chat_page_t *chat_page_search(net_t* net, char *name, int type, int flags);
void chat_page_set_op(chat_page_t* page, int status);

user_timestamp_t *timestamp_new(char *user);
user_timestamp_t *timestamp_search(GList * stamps, char *user);
void timestamp_touch(user_timestamp_t * stamp);
int timestamp_difference(user_timestamp_t * stamp);
GList* timestamp_touch_user(GList* user_list, char* user);

chat_page_t *create_other_page(net_t* net, char *name, char *title);
chat_page_t *create_network_page(net_t* net);

void channel_set_mode(chat_page_t* page, char* who,
		      int set, int clear, int send);
void channel_set_limit(chat_page_t* page, char* who, 
		       int limit, int send);
void channel_set_level(chat_page_t* page, char* who,
		       int level, int send);
void channel_set_topic(chat_page_t* page, char* who,
		       char* topic, int action);

int channel_refresh(gpointer data);

void text_insert_token(GtkWidget* widget, char* name, void* data, 
		       int type, guint pos);
word_info_t* text_get_info(GtkWidget* widget, gint pos);
void chat_page_update_network(chat_page_t* page, net_t* net);
void activate_auto_afk();
void deactivate_auto_afk();
void update_channel_user(chat_page_t* page, channel_user_t* cu);
GList* find_channels(net_t* net, char* user);
void chat_print_prefix(chat_page_t* page, int which);

void public_message  (net_t* net, char* channel, char* user, char* message);
void public_emote    (net_t* net, char* channel, char* user, char* message);
void public_notice   (net_t* net, char* channel, char* user, char* message);
void public_wallop   (net_t* net, char* channel, char* user, char* message);
void private_message (net_t* net, char* user, char* message);
void private_emote   (net_t* net, char* user, char* message);
void private_notice  (net_t* net, char* user, char* message);
void operator_message(net_t* net, char* user, char* message);
void global_message  (net_t* net, char* user, char* message);
void motd_message    (net_t* net, char* message);

void user_parted(net_t* net, chat_page_t* page, char* user, 
		 char* reason, int share, int link, int quit, char* who);
void user_online(chat_page_t* page, char* user,
		 int share, int link, int flags);
void user_joined(chat_page_t* page, char* user, 
		 int share, int link);
void destroy_channel(chat_page_t* page);
void user_flagged(chat_page_t* page, char* who,
		  char* user, int set, int flag, char* reason);

void channel_entry_new(net_t* net, char* name, char* online,
		       char* topic, char* limit, char* level);
void channel_list_end(chat_page_t* page);
void channel_list_get_real(chat_page_t* page);
void channel_list_get(net_t* net);

GtkWidget* create_channel_popup(channel_entry_t* channel, int ctab);
GtkWidget* create_url_popup(char* url);
GtkWidget* create_file_popup(word_info_t* winfo);

GdkColor* get_nick_color(const char *nick, int mode);
