// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "EnvelopeUI.h"
//Copyright (c) 2002-2005 Nasca Octavian Paul
//License: GNU GPL version 2 or later

EnvelopeFreeEdit::EnvelopeFreeEdit(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
  env=NULL;
pair=NULL;
}

void EnvelopeFreeEdit::init(EnvelopeParams *env_) {
  env=env_;
oldx=-1;
currentpoint=-1;
cpx=0;
lastpoint=-1;
}

void EnvelopeFreeEdit::setpair(Fl_Box *pair_) {
  pair=pair_;
}

int EnvelopeFreeEdit::getpointx(int n) {
  int lx=w()-10;
int npoints=env->Penvpoints;

float  sum=0;
for (int i=1;i<npoints;i++) sum+=env->getdt(i)+1;

float sumbefore=0;//the sum of all points before the computed point
for (int i=1;i<=n;i++) sumbefore+=env->getdt(i)+1;

return((int) (sumbefore/(REALTYPE) sum*lx));
}

int EnvelopeFreeEdit::getpointy(int n) {
  int ly=h()-10;

return((int) ((1.0-env->Penvval[n]/127.0)*ly));
}

int EnvelopeFreeEdit::getnearest(int x,int y) {
  x-=5;y-=5;

int nearestpoint=0;
int nearestval=1000000;//a big value
for (int i=0;i<env->Penvpoints;i++){
   int distance=abs(x-getpointx(i))+abs(y-getpointy(i));
   if (distance<nearestval) {
     nearestpoint=i;
     nearestval=distance;  
   };
};
return(nearestpoint);
}

void EnvelopeFreeEdit::draw() {
  int ox=x(),oy=y(),lx=w(),ly=h();
if (env->Pfreemode==0) env->converttofree();
int npoints=env->Penvpoints;

if (active_r()) fl_color(FL_BLACK);
    else fl_color(90,90,90);
if (!active_r()) currentpoint=-1;

fl_rectf(ox,oy,lx,ly);

ox+=5;oy+=5;lx-=10;ly-=10;

//draw the lines
fl_color(FL_GRAY);

fl_line_style(FL_SOLID);
fl_line(ox+2,oy+ly/2,ox+lx-2,oy+ly/2);

//draws the evelope points and lines
Fl_Color alb=FL_WHITE;
if (!active_r()) alb=fl_rgb_color(180,180,180);
fl_color(alb);
int oldxx=0,xx=0,oldyy=0,yy=getpointy(0);
fl_rectf(ox-3,oy+yy-3,6,6);
for (int i=1;i<npoints;i++){
    oldxx=xx;oldyy=yy;
    xx=getpointx(i);yy=getpointy(i);
    if (i==currentpoint) fl_color(FL_RED);
        else fl_color(alb);
    fl_line(ox+oldxx,oy+oldyy,ox+xx,oy+yy);
    fl_rectf(ox+xx-3,oy+yy-3,6,6);
};

//draw the last moved point point (if exists)
if (lastpoint>=0){
    fl_color(FL_CYAN);
    fl_rectf(ox+getpointx(lastpoint)-5,oy+getpointy(lastpoint)-5,10,10);
};

//draw the sustain position
if (env->Penvsustain>0){
    fl_color(FL_YELLOW);
    xx=getpointx(env->Penvsustain);
    fl_line(ox+xx,oy+0,ox+xx,oy+ly);
};

//Show the envelope duration and the current line duration
fl_font(FL_HELVETICA|FL_BOLD,10);
float time=0.0;
if (currentpoint<=0){
   fl_color(alb);
   for (int i=1;i<npoints;i++) time+=env->getdt(i);
} else {
   fl_color(255,0,0);
   time=env->getdt(currentpoint);
};
char tmpstr[20];
if (time<1000.0) snprintf((char *)&tmpstr,20,"%.1fms",time);
     else snprintf((char *)&tmpstr,20,"%.2fs",time/1000.0);
fl_draw(tmpstr,ox+lx-20,oy+ly-10,20,10,FL_ALIGN_RIGHT,NULL,0);
}

int EnvelopeFreeEdit::handle(int event) {
  int x_=Fl::event_x()-x();
int y_=Fl::event_y()-y();

if (event==FL_PUSH) {
  currentpoint=getnearest(x_,y_);
  cpx=x_;
  cpdt=env->Penvdt[currentpoint];
  lastpoint=currentpoint;
  redraw();
  if (pair!=NULL) pair->redraw();
};

if (event==FL_RELEASE){
  currentpoint=-1;
  redraw();
  if (pair!=NULL) pair->redraw();
};

if ((event==FL_DRAG)&&(currentpoint>=0)){
  int ny=127-(int) (y_*127.0/h());
  if (ny<0) ny=0;if (ny>127) ny=127;
  env->Penvval[currentpoint]=ny;

  int dx=(int)((x_-cpx)*0.1);
  int newdt=cpdt+dx;
  if (newdt<0) newdt=0;if (newdt>127) newdt=127;
  if (currentpoint!=0) env->Penvdt[currentpoint]=newdt;
     else env->Penvdt[currentpoint]=0;

  redraw();
  if (pair!=NULL) pair->redraw();
};


return(1);
}

void EnvelopeUI::cb_addpoint_i(Fl_Button*, void*) {
  int curpoint=freeedit->lastpoint;
if (curpoint<0) return;
//if (curpoint>=env->Penvpoints-1) return;
if (env->Penvpoints>=MAX_ENVELOPE_POINTS) return;

for (int i=env->Penvpoints;i>=curpoint+1;i--){
   env->Penvdt[i]=env->Penvdt[i-1];
   env->Penvval[i]=env->Penvval[i-1];
};

if (curpoint==0) {
  env->Penvdt[1]=64;
};

env->Penvpoints++;
if (curpoint<=env->Penvsustain) env->Penvsustain++;

freeedit->lastpoint+=1;
freeedit->redraw();
envfree->redraw();

sustaincounter->value(env->Penvsustain);
sustaincounter->maximum(env->Penvpoints-2);
}
void EnvelopeUI::cb_addpoint(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_addpoint_i(o,v);
}

void EnvelopeUI::cb_deletepoint_i(Fl_Button*, void*) {
  int curpoint=freeedit->lastpoint;
if (curpoint<1) return;
if (curpoint>=env->Penvpoints-1) return;
if (env->Penvpoints<=3) return;

for (int i=curpoint+1;i<env->Penvpoints;i++){
   env->Penvdt[i-1]=env->Penvdt[i];
   env->Penvval[i-1]=env->Penvval[i];
};

env->Penvpoints--;

if (curpoint<=env->Penvsustain) env->Penvsustain--;


freeedit->lastpoint-=1;
freeedit->redraw();
envfree->redraw();

sustaincounter->value(env->Penvsustain);
sustaincounter->maximum(env->Penvpoints-2);
}
void EnvelopeUI::cb_deletepoint(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_deletepoint_i(o,v);
}

void EnvelopeUI::cb_freemodebutton_i(Fl_Light_Button*, void*) {
  reinit();

freeedit->lastpoint=-1;
freeedit->redraw();
}
void EnvelopeUI::cb_freemodebutton(Fl_Light_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_freemodebutton_i(o,v);
}

void EnvelopeUI::cb_forcedreleasecheck_i(Fl_Check_Button* o, void*) {
  env->Pforcedrelease=(int)o->value();
}
void EnvelopeUI::cb_forcedreleasecheck(Fl_Check_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_forcedreleasecheck_i(o,v);
}

void EnvelopeUI::cb_envstretchdial_i(WidgetPDial* o, void*) {
  env->Penvstretch=(int)o->value();
}
void EnvelopeUI::cb_envstretchdial(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_envstretchdial_i(o,v);
}

void EnvelopeUI::cb_Close_i(Fl_Button*, void*) {
  freemodeeditwindow->hide();
}
void EnvelopeUI::cb_Close(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_Close_i(o,v);
}

void EnvelopeUI::cb_linearenvelopecheck_i(Fl_Check_Button* o, void*) {
  env->Plinearenvelope=(int)o->value();
}
void EnvelopeUI::cb_linearenvelopecheck(Fl_Check_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_linearenvelopecheck_i(o,v);
}

void EnvelopeUI::cb_sustaincounter_i(Fl_Counter* o, void*) {
  env->Penvsustain=(int) o->value();
freeedit->redraw();
envfree->redraw();
}
void EnvelopeUI::cb_sustaincounter(Fl_Counter* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_sustaincounter_i(o,v);
}

void EnvelopeUI::cb_C_i(Fl_Button*, void*) {
  presetsui->copy(env);
}
void EnvelopeUI::cb_C(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_C_i(o,v);
}

void EnvelopeUI::cb_P_i(Fl_Button*, void*) {
  presetsui->paste(env,this);
}
void EnvelopeUI::cb_P(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_P_i(o,v);
}

void EnvelopeUI::cb_e1adt_i(WidgetPDial* o, void*) {
  env->PA_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e1adt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e1adt_i(o,v);
}

void EnvelopeUI::cb_e1ddt_i(WidgetPDial* o, void*) {
  env->PD_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e1ddt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e1ddt_i(o,v);
}

void EnvelopeUI::cb_e1rdt_i(WidgetPDial* o, void*) {
  env->PR_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e1rdt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e1rdt_i(o,v);
}

void EnvelopeUI::cb_e1sval_i(WidgetPDial* o, void*) {
  env->PS_val=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e1sval(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e1sval_i(o,v);
}

void EnvelopeUI::cb_e1forcedrelease_i(Fl_Check_Button* o, void*) {
  env->Pforcedrelease=(int)o->value();
}
void EnvelopeUI::cb_e1forcedrelease(Fl_Check_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e1forcedrelease_i(o,v);
}

void EnvelopeUI::cb_e1envstretch_i(WidgetPDial* o, void*) {
  env->Penvstretch=(int)o->value();
}
void EnvelopeUI::cb_e1envstretch(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e1envstretch_i(o,v);
}

void EnvelopeUI::cb_E_i(Fl_Button*, void*) {
  freemodeeditwindow->show();
}
void EnvelopeUI::cb_E(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_E_i(o,v);
}

void EnvelopeUI::cb_e1linearenvelope_i(Fl_Check_Button* o, void*) {
  env->Plinearenvelope=(int)o->value();
}
void EnvelopeUI::cb_e1linearenvelope(Fl_Check_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e1linearenvelope_i(o,v);
}

void EnvelopeUI::cb_C1_i(Fl_Button*, void*) {
  presetsui->copy(env);
}
void EnvelopeUI::cb_C1(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_C1_i(o,v);
}

void EnvelopeUI::cb_P1_i(Fl_Button*, void*) {
  presetsui->paste(env,this);
}
void EnvelopeUI::cb_P1(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_P1_i(o,v);
}

void EnvelopeUI::cb_e2aval_i(WidgetPDial* o, void*) {
  env->PA_val=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e2aval(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e2aval_i(o,v);
}

void EnvelopeUI::cb_e2adt_i(WidgetPDial* o, void*) {
  env->PA_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e2adt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e2adt_i(o,v);
}

void EnvelopeUI::cb_e2rval_i(WidgetPDial* o, void*) {
  env->PR_val=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e2rval(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e2rval_i(o,v);
}

void EnvelopeUI::cb_e2rdt_i(WidgetPDial* o, void*) {
  env->PR_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e2rdt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e2rdt_i(o,v);
}

void EnvelopeUI::cb_e2envstretch_i(WidgetPDial* o, void*) {
  env->Penvstretch=(int)o->value();
}
void EnvelopeUI::cb_e2envstretch(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e2envstretch_i(o,v);
}

void EnvelopeUI::cb_e2forcedrelease_i(Fl_Check_Button* o, void*) {
  env->Pforcedrelease=(int)o->value();
}
void EnvelopeUI::cb_e2forcedrelease(Fl_Check_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e2forcedrelease_i(o,v);
}

void EnvelopeUI::cb_C2_i(Fl_Button*, void*) {
  presetsui->copy(env);
}
void EnvelopeUI::cb_C2(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_C2_i(o,v);
}

void EnvelopeUI::cb_P2_i(Fl_Button*, void*) {
  presetsui->paste(env,this);
}
void EnvelopeUI::cb_P2(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_P2_i(o,v);
}

void EnvelopeUI::cb_E1_i(Fl_Button*, void*) {
  freemodeeditwindow->show();
}
void EnvelopeUI::cb_E1(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_E1_i(o,v);
}

void EnvelopeUI::cb_e3aval_i(WidgetPDial* o, void*) {
  env->PA_val=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e3aval(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e3aval_i(o,v);
}

void EnvelopeUI::cb_e3adt_i(WidgetPDial* o, void*) {
  env->PA_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e3adt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e3adt_i(o,v);
}

void EnvelopeUI::cb_e3dval_i(WidgetPDial* o, void*) {
  env->PD_val=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e3dval(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e3dval_i(o,v);
}

void EnvelopeUI::cb_e3ddt_i(WidgetPDial* o, void*) {
  env->PD_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e3ddt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e3ddt_i(o,v);
}

void EnvelopeUI::cb_e3rdt_i(WidgetPDial* o, void*) {
  env->PR_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e3rdt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e3rdt_i(o,v);
}

void EnvelopeUI::cb_e3rval_i(WidgetPDial* o, void*) {
  env->PR_val=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e3rval(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e3rval_i(o,v);
}

void EnvelopeUI::cb_e3envstretch_i(WidgetPDial* o, void*) {
  env->Penvstretch=(int)o->value();
}
void EnvelopeUI::cb_e3envstretch(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e3envstretch_i(o,v);
}

void EnvelopeUI::cb_e3forcedrelease_i(Fl_Check_Button* o, void*) {
  env->Pforcedrelease=(int)o->value();
}
void EnvelopeUI::cb_e3forcedrelease(Fl_Check_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e3forcedrelease_i(o,v);
}

void EnvelopeUI::cb_E2_i(Fl_Button*, void*) {
  freemodeeditwindow->show();
}
void EnvelopeUI::cb_E2(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_E2_i(o,v);
}

void EnvelopeUI::cb_C3_i(Fl_Button*, void*) {
  presetsui->copy(env);
}
void EnvelopeUI::cb_C3(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_C3_i(o,v);
}

void EnvelopeUI::cb_P3_i(Fl_Button*, void*) {
  presetsui->paste(env,this);
}
void EnvelopeUI::cb_P3(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_P3_i(o,v);
}

void EnvelopeUI::cb_e4aval_i(WidgetPDial* o, void*) {
  env->PA_val=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e4aval(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e4aval_i(o,v);
}

void EnvelopeUI::cb_e4adt_i(WidgetPDial* o, void*) {
  env->PA_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e4adt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e4adt_i(o,v);
}

void EnvelopeUI::cb_e4rval_i(WidgetPDial* o, void*) {
  env->PR_val=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e4rval(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e4rval_i(o,v);
}

void EnvelopeUI::cb_e4rdt_i(WidgetPDial* o, void*) {
  env->PR_dt=(int)o->value();
freeedit->redraw();
}
void EnvelopeUI::cb_e4rdt(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e4rdt_i(o,v);
}

void EnvelopeUI::cb_e4envstretch_i(WidgetPDial* o, void*) {
  env->Penvstretch=(int)o->value();
}
void EnvelopeUI::cb_e4envstretch(WidgetPDial* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e4envstretch_i(o,v);
}

void EnvelopeUI::cb_e4forcedrelease_i(Fl_Check_Button* o, void*) {
  env->Pforcedrelease=(int)o->value();
}
void EnvelopeUI::cb_e4forcedrelease(Fl_Check_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_e4forcedrelease_i(o,v);
}

void EnvelopeUI::cb_C4_i(Fl_Button*, void*) {
  presetsui->copy(env);
}
void EnvelopeUI::cb_C4(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_C4_i(o,v);
}

void EnvelopeUI::cb_P4_i(Fl_Button*, void*) {
  presetsui->paste(env,this);
}
void EnvelopeUI::cb_P4(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_P4_i(o,v);
}

void EnvelopeUI::cb_E3_i(Fl_Button*, void*) {
  freemodeeditwindow->show();
}
void EnvelopeUI::cb_E3(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->user_data()))->cb_E3_i(o,v);
}

void EnvelopeUI::cb_freeeditsmall_i(EnvelopeFreeEdit*, void*) {
  envfree->redraw();
}
void EnvelopeUI::cb_freeeditsmall(EnvelopeFreeEdit* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_freeeditsmall_i(o,v);
}

void EnvelopeUI::cb_E4_i(Fl_Button*, void*) {
  freemodeeditwindow->show();
}
void EnvelopeUI::cb_E4(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_E4_i(o,v);
}

void EnvelopeUI::cb_C5_i(Fl_Button*, void*) {
  presetsui->copy(env);
}
void EnvelopeUI::cb_C5(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_C5_i(o,v);
}

void EnvelopeUI::cb_P5_i(Fl_Button*, void*) {
  presetsui->paste(env,this);
}
void EnvelopeUI::cb_P5(Fl_Button* o, void* v) {
  ((EnvelopeUI*)(o->parent()->parent()->user_data()))->cb_P5_i(o,v);
}

EnvelopeUI::EnvelopeUI(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  env=NULL;
freemodeeditwindow=NULL;
envADSR=NULL;
envASR=NULL;
envADSRfilter=NULL;
envASRbw=NULL;
envfree=NULL;
}

EnvelopeUI::~EnvelopeUI() {
  envwindow->hide();
hide();
freemodeeditwindow->hide();
delete (freemodeeditwindow);
}

Fl_Double_Window* EnvelopeUI::make_freemode_edit_window() {
  { freemodeeditwindow = new Fl_Double_Window(575, 180, "Envelope");
    freemodeeditwindow->user_data((void*)(this));
    { EnvelopeFreeEdit* o = freeedit = new EnvelopeFreeEdit(5, 5, 565, 145, "Envelope");
      freeedit->box(FL_FLAT_BOX);
      freeedit->color(FL_FOREGROUND_COLOR);
      freeedit->selection_color(FL_BACKGROUND_COLOR);
      freeedit->labeltype(FL_NORMAL_LABEL);
      freeedit->labelfont(0);
      freeedit->labelsize(14);
      freeedit->labelcolor(FL_FOREGROUND_COLOR);
      freeedit->align(Fl_Align(FL_ALIGN_CENTER));
      freeedit->when(FL_WHEN_RELEASE);
      o->init(env);
    } // EnvelopeFreeEdit* freeedit
    { Fl_Button* o = addpoint = new Fl_Button(115, 155, 80, 20, "Add point");
      addpoint->box(FL_THIN_UP_BOX);
      addpoint->callback((Fl_Callback*)cb_addpoint);
      if (env->Pfreemode==0) o->hide();
    } // Fl_Button* addpoint
    { Fl_Button* o = deletepoint = new Fl_Button(200, 155, 80, 20, "Delete point");
      deletepoint->box(FL_THIN_UP_BOX);
      deletepoint->callback((Fl_Callback*)cb_deletepoint);
      if (env->Pfreemode==0) o->hide();
    } // Fl_Button* deletepoint
    { freemodebutton = new Fl_Light_Button(10, 155, 95, 25, "FreeMode");
      freemodebutton->tooltip("Enable or disable the freemode");
      freemodebutton->box(FL_PLASTIC_UP_BOX);
      freemodebutton->callback((Fl_Callback*)cb_freemodebutton);
    } // Fl_Light_Button* freemodebutton
    { Fl_Check_Button* o = forcedreleasecheck = new Fl_Check_Button(410, 165, 40, 15, "frcR");
      forcedreleasecheck->tooltip("Forced Relase");
      forcedreleasecheck->down_box(FL_DOWN_BOX);
      forcedreleasecheck->labelsize(10);
      forcedreleasecheck->callback((Fl_Callback*)cb_forcedreleasecheck);
      o->value(env->Pforcedrelease);
      if (env->Pfreemode==0) o->hide();
    } // Fl_Check_Button* forcedreleasecheck
    { WidgetPDial* o = envstretchdial = new WidgetPDial(380, 155, 25, 25, "Str.");
      envstretchdial->tooltip("Envelope stretch (on lower notes make the envelope longer)");
      envstretchdial->box(FL_ROUND_UP_BOX);
      envstretchdial->color(FL_BACKGROUND_COLOR);
      envstretchdial->selection_color(FL_INACTIVE_COLOR);
      envstretchdial->labeltype(FL_NORMAL_LABEL);
      envstretchdial->labelfont(0);
      envstretchdial->labelsize(10);
      envstretchdial->labelcolor(FL_FOREGROUND_COLOR);
      envstretchdial->maximum(127);
      envstretchdial->step(1);
      envstretchdial->callback((Fl_Callback*)cb_envstretchdial);
      envstretchdial->align(Fl_Align(FL_ALIGN_LEFT));
      envstretchdial->when(FL_WHEN_CHANGED);
      o->value(env->Penvstretch);
      if (env->Pfreemode==0) o->hide();
    } // WidgetPDial* envstretchdial
    { Fl_Button* o = new Fl_Button(510, 155, 60, 25, "Close");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Close);
    } // Fl_Button* o
    { Fl_Check_Button* o = linearenvelopecheck = new Fl_Check_Button(410, 151, 30, 15, "L");
      linearenvelopecheck->tooltip("Linear Envelope");
      linearenvelopecheck->down_box(FL_DOWN_BOX);
      linearenvelopecheck->labelsize(10);
      linearenvelopecheck->callback((Fl_Callback*)cb_linearenvelopecheck);
      o->value(env->Plinearenvelope);
      if ((env->Pfreemode==0)||(env->Envmode>2)) o->hide();
    } // Fl_Check_Button* linearenvelopecheck
    { Fl_Counter* o = sustaincounter = new Fl_Counter(315, 155, 40, 15, "Sust");
      sustaincounter->tooltip("Sustain (0 is disabled)");
      sustaincounter->type(1);
      sustaincounter->labelsize(11);
      sustaincounter->minimum(0);
      sustaincounter->maximum(127);
      sustaincounter->step(1);
      sustaincounter->callback((Fl_Callback*)cb_sustaincounter);
      sustaincounter->align(Fl_Align(FL_ALIGN_LEFT));
      o->value(env->Penvsustain);
      if (env->Pfreemode==0) o->hide();
      o->maximum(env->Penvpoints-2);
    } // Fl_Counter* sustaincounter
    { Fl_Button* o = new Fl_Button(465, 160, 15, 15, "C");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(10);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_C);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(482, 160, 15, 15, "P");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(10);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_P);
    } // Fl_Button* o
    freemodeeditwindow->end();
  } // Fl_Double_Window* freemodeeditwindow
  return freemodeeditwindow;
}

Fl_Group* EnvelopeUI::make_ADSR_window() {
  { envADSR = new Fl_Group(0, 0, 205, 70);
    envADSR->box(FL_FLAT_BOX);
    envADSR->color(FL_LIGHT1);
    envADSR->selection_color(FL_BACKGROUND_COLOR);
    envADSR->labeltype(FL_NO_LABEL);
    envADSR->labelfont(1);
    envADSR->labelsize(14);
    envADSR->labelcolor(FL_FOREGROUND_COLOR);
    envADSR->user_data((void*)(this));
    envADSR->align(Fl_Align(FL_ALIGN_TOP));
    envADSR->when(FL_WHEN_RELEASE);
    { Fl_Group* o = new Fl_Group(0, 0, 205, 70, "Amplitude Envelope");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_CYAN);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(10);
      o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { WidgetPDial* o = e1adt = new WidgetPDial(5, 20, 30, 30, "A.dt");
        e1adt->tooltip("Attack time");
        e1adt->box(FL_ROUND_UP_BOX);
        e1adt->color(FL_BACKGROUND_COLOR);
        e1adt->selection_color(FL_INACTIVE_COLOR);
        e1adt->labeltype(FL_NORMAL_LABEL);
        e1adt->labelfont(0);
        e1adt->labelsize(10);
        e1adt->labelcolor(FL_FOREGROUND_COLOR);
        e1adt->maximum(127);
        e1adt->step(1);
        e1adt->callback((Fl_Callback*)cb_e1adt);
        e1adt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e1adt->when(FL_WHEN_CHANGED);
        o->value(env->PA_dt);
      } // WidgetPDial* e1adt
      { WidgetPDial* o = e1ddt = new WidgetPDial(40, 20, 30, 30, "D.dt");
        e1ddt->tooltip("Decay time");
        e1ddt->box(FL_ROUND_UP_BOX);
        e1ddt->color(FL_BACKGROUND_COLOR);
        e1ddt->selection_color(FL_INACTIVE_COLOR);
        e1ddt->labeltype(FL_NORMAL_LABEL);
        e1ddt->labelfont(0);
        e1ddt->labelsize(10);
        e1ddt->labelcolor(FL_FOREGROUND_COLOR);
        e1ddt->maximum(127);
        e1ddt->step(1);
        e1ddt->callback((Fl_Callback*)cb_e1ddt);
        e1ddt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e1ddt->when(FL_WHEN_CHANGED);
        o->value(env->PD_dt);
      } // WidgetPDial* e1ddt
      { WidgetPDial* o = e1rdt = new WidgetPDial(110, 20, 30, 30, "R.dt");
        e1rdt->tooltip("Release time");
        e1rdt->box(FL_ROUND_UP_BOX);
        e1rdt->color(FL_BACKGROUND_COLOR);
        e1rdt->selection_color(FL_INACTIVE_COLOR);
        e1rdt->labeltype(FL_NORMAL_LABEL);
        e1rdt->labelfont(0);
        e1rdt->labelsize(10);
        e1rdt->labelcolor(FL_FOREGROUND_COLOR);
        e1rdt->maximum(127);
        e1rdt->step(1);
        e1rdt->callback((Fl_Callback*)cb_e1rdt);
        e1rdt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e1rdt->when(FL_WHEN_CHANGED);
        o->value(env->PR_dt);
      } // WidgetPDial* e1rdt
      { WidgetPDial* o = e1sval = new WidgetPDial(75, 20, 30, 30, "S.val");
        e1sval->tooltip("Sustain value");
        e1sval->box(FL_ROUND_UP_BOX);
        e1sval->color(FL_BACKGROUND_COLOR);
        e1sval->selection_color(FL_INACTIVE_COLOR);
        e1sval->labeltype(FL_NORMAL_LABEL);
        e1sval->labelfont(0);
        e1sval->labelsize(10);
        e1sval->labelcolor(FL_FOREGROUND_COLOR);
        e1sval->maximum(127);
        e1sval->step(1);
        e1sval->callback((Fl_Callback*)cb_e1sval);
        e1sval->align(Fl_Align(FL_ALIGN_BOTTOM));
        e1sval->when(FL_WHEN_CHANGED);
        o->value(env->PS_val);
      } // WidgetPDial* e1sval
      { Fl_Check_Button* o = e1forcedrelease = new Fl_Check_Button(180, 35, 20, 15, "frcR");
        e1forcedrelease->tooltip("Forced Relase");
        e1forcedrelease->down_box(FL_DOWN_BOX);
        e1forcedrelease->labelsize(10);
        e1forcedrelease->callback((Fl_Callback*)cb_e1forcedrelease);
        e1forcedrelease->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
        o->value(env->Pforcedrelease);
      } // Fl_Check_Button* e1forcedrelease
      { WidgetPDial* o = e1envstretch = new WidgetPDial(145, 25, 25, 25, "Stretch");
        e1envstretch->tooltip("Envelope stretch (on lower notes makes the envelope longer)");
        e1envstretch->box(FL_ROUND_UP_BOX);
        e1envstretch->color(FL_BACKGROUND_COLOR);
        e1envstretch->selection_color(FL_INACTIVE_COLOR);
        e1envstretch->labeltype(FL_NORMAL_LABEL);
        e1envstretch->labelfont(0);
        e1envstretch->labelsize(10);
        e1envstretch->labelcolor(FL_FOREGROUND_COLOR);
        e1envstretch->maximum(127);
        e1envstretch->step(1);
        e1envstretch->callback((Fl_Callback*)cb_e1envstretch);
        e1envstretch->align(Fl_Align(FL_ALIGN_BOTTOM));
        e1envstretch->when(FL_WHEN_CHANGED);
        o->value(env->Penvstretch);
      } // WidgetPDial* e1envstretch
      { Fl_Button* o = new Fl_Button(185, 5, 15, 15, "E");
        o->tooltip("Envelope window");
        o->box(FL_PLASTIC_UP_BOX);
        o->labelfont(1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_E);
      } // Fl_Button* o
      { Fl_Check_Button* o = e1linearenvelope = new Fl_Check_Button(180, 20, 15, 15, "L");
        e1linearenvelope->tooltip("The evelope is linear");
        e1linearenvelope->down_box(FL_DOWN_BOX);
        e1linearenvelope->labelsize(10);
        e1linearenvelope->callback((Fl_Callback*)cb_e1linearenvelope);
        e1linearenvelope->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(env->Plinearenvelope);
      } // Fl_Check_Button* e1linearenvelope
      { Fl_Button* o = new Fl_Button(150, 5, 15, 15, "C");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_C1);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(167, 5, 15, 15, "P");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_P1);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    envADSR->end();
  } // Fl_Group* envADSR
  return envADSR;
}

Fl_Group* EnvelopeUI::make_ASR_window() {
  { envASR = new Fl_Group(0, 0, 210, 70);
    envASR->box(FL_FLAT_BOX);
    envASR->color(FL_BACKGROUND_COLOR);
    envASR->selection_color(FL_BACKGROUND_COLOR);
    envASR->labeltype(FL_NO_LABEL);
    envASR->labelfont(0);
    envASR->labelsize(14);
    envASR->labelcolor(FL_FOREGROUND_COLOR);
    envASR->user_data((void*)(this));
    envASR->align(Fl_Align(FL_ALIGN_TOP));
    envASR->when(FL_WHEN_RELEASE);
    { Fl_Group* o = new Fl_Group(0, 0, 210, 70, "Frequency Envelope");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_CYAN);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(10);
      o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { WidgetPDial* o = e2aval = new WidgetPDial(5, 20, 30, 30, "A.val");
        e2aval->tooltip("Starting value");
        e2aval->box(FL_ROUND_UP_BOX);
        e2aval->color(FL_BACKGROUND_COLOR);
        e2aval->selection_color(FL_INACTIVE_COLOR);
        e2aval->labeltype(FL_NORMAL_LABEL);
        e2aval->labelfont(0);
        e2aval->labelsize(10);
        e2aval->labelcolor(FL_FOREGROUND_COLOR);
        e2aval->maximum(127);
        e2aval->step(1);
        e2aval->callback((Fl_Callback*)cb_e2aval);
        e2aval->align(Fl_Align(FL_ALIGN_BOTTOM));
        e2aval->when(FL_WHEN_CHANGED);
        o->value(env->PA_val);
      } // WidgetPDial* e2aval
      { WidgetPDial* o = e2adt = new WidgetPDial(40, 20, 30, 30, "A.dt");
        e2adt->tooltip("Attack time");
        e2adt->box(FL_ROUND_UP_BOX);
        e2adt->color(FL_BACKGROUND_COLOR);
        e2adt->selection_color(FL_INACTIVE_COLOR);
        e2adt->labeltype(FL_NORMAL_LABEL);
        e2adt->labelfont(0);
        e2adt->labelsize(10);
        e2adt->labelcolor(FL_FOREGROUND_COLOR);
        e2adt->maximum(127);
        e2adt->step(1);
        e2adt->callback((Fl_Callback*)cb_e2adt);
        e2adt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e2adt->when(FL_WHEN_CHANGED);
        o->value(env->PA_dt);
      } // WidgetPDial* e2adt
      { WidgetPDial* o = e2rval = new WidgetPDial(110, 20, 30, 30, "R.val");
        e2rval->tooltip("Release value");
        e2rval->box(FL_ROUND_UP_BOX);
        e2rval->color(FL_BACKGROUND_COLOR);
        e2rval->selection_color(FL_INACTIVE_COLOR);
        e2rval->labeltype(FL_NORMAL_LABEL);
        e2rval->labelfont(0);
        e2rval->labelsize(10);
        e2rval->labelcolor(FL_FOREGROUND_COLOR);
        e2rval->maximum(127);
        e2rval->step(1);
        e2rval->callback((Fl_Callback*)cb_e2rval);
        e2rval->align(Fl_Align(FL_ALIGN_BOTTOM));
        e2rval->when(FL_WHEN_CHANGED);
        o->value(env->PR_val);
      } // WidgetPDial* e2rval
      { WidgetPDial* o = e2rdt = new WidgetPDial(75, 20, 30, 30, "R.dt");
        e2rdt->tooltip("Release time");
        e2rdt->box(FL_ROUND_UP_BOX);
        e2rdt->color(FL_BACKGROUND_COLOR);
        e2rdt->selection_color(FL_INACTIVE_COLOR);
        e2rdt->labeltype(FL_NORMAL_LABEL);
        e2rdt->labelfont(0);
        e2rdt->labelsize(10);
        e2rdt->labelcolor(FL_FOREGROUND_COLOR);
        e2rdt->maximum(127);
        e2rdt->step(1);
        e2rdt->callback((Fl_Callback*)cb_e2rdt);
        e2rdt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e2rdt->when(FL_WHEN_CHANGED);
        o->value(env->PR_dt);
      } // WidgetPDial* e2rdt
      { WidgetPDial* o = e2envstretch = new WidgetPDial(145, 25, 25, 25, "Stretch");
        e2envstretch->tooltip("Envelope stretch (on lower notes makes the envelope longer)");
        e2envstretch->box(FL_ROUND_UP_BOX);
        e2envstretch->color(FL_BACKGROUND_COLOR);
        e2envstretch->selection_color(FL_INACTIVE_COLOR);
        e2envstretch->labeltype(FL_NORMAL_LABEL);
        e2envstretch->labelfont(0);
        e2envstretch->labelsize(10);
        e2envstretch->labelcolor(FL_FOREGROUND_COLOR);
        e2envstretch->maximum(127);
        e2envstretch->step(1);
        e2envstretch->callback((Fl_Callback*)cb_e2envstretch);
        e2envstretch->align(Fl_Align(FL_ALIGN_BOTTOM));
        e2envstretch->when(FL_WHEN_CHANGED);
        o->value(env->Penvstretch);
      } // WidgetPDial* e2envstretch
      { Fl_Check_Button* o = e2forcedrelease = new Fl_Check_Button(180, 25, 15, 25, "frcR");
        e2forcedrelease->tooltip("Forced release");
        e2forcedrelease->down_box(FL_DOWN_BOX);
        e2forcedrelease->labelsize(10);
        e2forcedrelease->callback((Fl_Callback*)cb_e2forcedrelease);
        e2forcedrelease->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
        o->value(env->Pforcedrelease);
      } // Fl_Check_Button* e2forcedrelease
      { Fl_Button* o = new Fl_Button(155, 5, 15, 15, "C");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_C2);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(172, 5, 15, 15, "P");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_P2);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Button* o = new Fl_Button(190, 5, 15, 15, "E");
      o->tooltip("Envelope window");
      o->box(FL_PLASTIC_UP_BOX);
      o->labelfont(1);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_E1);
    } // Fl_Button* o
    envASR->end();
  } // Fl_Group* envASR
  return envASR;
}

Fl_Group* EnvelopeUI::make_ADSRfilter_window() {
  { envADSRfilter = new Fl_Group(0, 0, 275, 70);
    envADSRfilter->box(FL_FLAT_BOX);
    envADSRfilter->color(FL_LIGHT1);
    envADSRfilter->selection_color(FL_BACKGROUND_COLOR);
    envADSRfilter->labeltype(FL_NO_LABEL);
    envADSRfilter->labelfont(1);
    envADSRfilter->labelsize(14);
    envADSRfilter->labelcolor(FL_FOREGROUND_COLOR);
    envADSRfilter->user_data((void*)(this));
    envADSRfilter->align(Fl_Align(FL_ALIGN_TOP));
    envADSRfilter->when(FL_WHEN_RELEASE);
    { Fl_Group* o = new Fl_Group(0, 0, 275, 70, "Filter Envelope");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_CYAN);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(10);
      o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { WidgetPDial* o = e3aval = new WidgetPDial(5, 20, 30, 30, "A.val");
        e3aval->tooltip("Starting value");
        e3aval->box(FL_ROUND_UP_BOX);
        e3aval->color(FL_BACKGROUND_COLOR);
        e3aval->selection_color(FL_INACTIVE_COLOR);
        e3aval->labeltype(FL_NORMAL_LABEL);
        e3aval->labelfont(0);
        e3aval->labelsize(10);
        e3aval->labelcolor(FL_FOREGROUND_COLOR);
        e3aval->maximum(127);
        e3aval->step(1);
        e3aval->callback((Fl_Callback*)cb_e3aval);
        e3aval->align(Fl_Align(FL_ALIGN_BOTTOM));
        e3aval->when(FL_WHEN_CHANGED);
        o->value(env->PA_val);
      } // WidgetPDial* e3aval
      { WidgetPDial* o = e3adt = new WidgetPDial(40, 20, 30, 30, "A.dt");
        e3adt->tooltip("Attack time");
        e3adt->box(FL_ROUND_UP_BOX);
        e3adt->color(FL_BACKGROUND_COLOR);
        e3adt->selection_color(FL_INACTIVE_COLOR);
        e3adt->labeltype(FL_NORMAL_LABEL);
        e3adt->labelfont(0);
        e3adt->labelsize(10);
        e3adt->labelcolor(FL_FOREGROUND_COLOR);
        e3adt->maximum(127);
        e3adt->step(1);
        e3adt->callback((Fl_Callback*)cb_e3adt);
        e3adt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e3adt->when(FL_WHEN_CHANGED);
        o->value(env->PA_dt);
      } // WidgetPDial* e3adt
      { WidgetPDial* o = e3dval = new WidgetPDial(75, 20, 30, 30, "D.val");
        e3dval->tooltip("decay value");
        e3dval->box(FL_ROUND_UP_BOX);
        e3dval->color(FL_BACKGROUND_COLOR);
        e3dval->selection_color(FL_INACTIVE_COLOR);
        e3dval->labeltype(FL_NORMAL_LABEL);
        e3dval->labelfont(0);
        e3dval->labelsize(10);
        e3dval->labelcolor(FL_FOREGROUND_COLOR);
        e3dval->maximum(127);
        e3dval->step(1);
        e3dval->callback((Fl_Callback*)cb_e3dval);
        e3dval->align(Fl_Align(FL_ALIGN_BOTTOM));
        e3dval->when(FL_WHEN_CHANGED);
        o->value(env->PD_val);
      } // WidgetPDial* e3dval
      { WidgetPDial* o = e3ddt = new WidgetPDial(110, 20, 30, 30, "D.dt");
        e3ddt->tooltip("decay time");
        e3ddt->box(FL_ROUND_UP_BOX);
        e3ddt->color(FL_BACKGROUND_COLOR);
        e3ddt->selection_color(FL_INACTIVE_COLOR);
        e3ddt->labeltype(FL_NORMAL_LABEL);
        e3ddt->labelfont(0);
        e3ddt->labelsize(10);
        e3ddt->labelcolor(FL_FOREGROUND_COLOR);
        e3ddt->maximum(127);
        e3ddt->step(1);
        e3ddt->callback((Fl_Callback*)cb_e3ddt);
        e3ddt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e3ddt->when(FL_WHEN_CHANGED);
        o->value(env->PD_dt);
      } // WidgetPDial* e3ddt
      { WidgetPDial* o = e3rdt = new WidgetPDial(145, 20, 30, 30, "R.dt");
        e3rdt->tooltip("Release time");
        e3rdt->box(FL_ROUND_UP_BOX);
        e3rdt->color(FL_BACKGROUND_COLOR);
        e3rdt->selection_color(FL_INACTIVE_COLOR);
        e3rdt->labeltype(FL_NORMAL_LABEL);
        e3rdt->labelfont(0);
        e3rdt->labelsize(10);
        e3rdt->labelcolor(FL_FOREGROUND_COLOR);
        e3rdt->maximum(127);
        e3rdt->step(1);
        e3rdt->callback((Fl_Callback*)cb_e3rdt);
        e3rdt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e3rdt->when(FL_WHEN_CHANGED);
        o->value(env->PR_dt);
      } // WidgetPDial* e3rdt
      { WidgetPDial* o = e3rval = new WidgetPDial(180, 20, 30, 30, "R.val");
        e3rval->tooltip("Release value");
        e3rval->box(FL_ROUND_UP_BOX);
        e3rval->color(FL_BACKGROUND_COLOR);
        e3rval->selection_color(FL_INACTIVE_COLOR);
        e3rval->labeltype(FL_NORMAL_LABEL);
        e3rval->labelfont(0);
        e3rval->labelsize(10);
        e3rval->labelcolor(FL_FOREGROUND_COLOR);
        e3rval->maximum(127);
        e3rval->step(1);
        e3rval->callback((Fl_Callback*)cb_e3rval);
        e3rval->align(Fl_Align(FL_ALIGN_BOTTOM));
        e3rval->when(FL_WHEN_CHANGED);
        o->value(env->PR_val);
      } // WidgetPDial* e3rval
      { WidgetPDial* o = e3envstretch = new WidgetPDial(215, 25, 25, 25, "Stretch");
        e3envstretch->tooltip("Envelope stretch (on lower notes makes the envelope longer)");
        e3envstretch->box(FL_ROUND_UP_BOX);
        e3envstretch->color(FL_BACKGROUND_COLOR);
        e3envstretch->selection_color(FL_INACTIVE_COLOR);
        e3envstretch->labeltype(FL_NORMAL_LABEL);
        e3envstretch->labelfont(0);
        e3envstretch->labelsize(10);
        e3envstretch->labelcolor(FL_FOREGROUND_COLOR);
        e3envstretch->maximum(127);
        e3envstretch->step(1);
        e3envstretch->callback((Fl_Callback*)cb_e3envstretch);
        e3envstretch->align(Fl_Align(FL_ALIGN_BOTTOM));
        e3envstretch->when(FL_WHEN_CHANGED);
        o->value(env->Penvstretch);
      } // WidgetPDial* e3envstretch
      { Fl_Check_Button* o = e3forcedrelease = new Fl_Check_Button(250, 30, 15, 20, "frcR");
        e3forcedrelease->tooltip("Forced Relase");
        e3forcedrelease->down_box(FL_DOWN_BOX);
        e3forcedrelease->labelsize(10);
        e3forcedrelease->callback((Fl_Callback*)cb_e3forcedrelease);
        e3forcedrelease->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
        o->value(env->Pforcedrelease);
      } // Fl_Check_Button* e3forcedrelease
      { Fl_Button* o = new Fl_Button(255, 5, 15, 15, "E");
        o->box(FL_PLASTIC_UP_BOX);
        o->labelfont(1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_E2);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(220, 5, 15, 15, "C");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_C3);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(237, 5, 15, 15, "P");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_P3);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    envADSRfilter->end();
  } // Fl_Group* envADSRfilter
  return envADSRfilter;
}

Fl_Group* EnvelopeUI::make_ASRbw_window() {
  { envASRbw = new Fl_Group(0, 0, 210, 70);
    envASRbw->box(FL_FLAT_BOX);
    envASRbw->color(FL_BACKGROUND_COLOR);
    envASRbw->selection_color(FL_BACKGROUND_COLOR);
    envASRbw->labeltype(FL_NO_LABEL);
    envASRbw->labelfont(0);
    envASRbw->labelsize(14);
    envASRbw->labelcolor(FL_FOREGROUND_COLOR);
    envASRbw->user_data((void*)(this));
    envASRbw->align(Fl_Align(FL_ALIGN_TOP));
    envASRbw->when(FL_WHEN_RELEASE);
    { Fl_Group* o = new Fl_Group(0, 0, 210, 70, "BandWidth Envelope");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_CYAN);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(10);
      o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { WidgetPDial* o = e4aval = new WidgetPDial(5, 20, 30, 30, "A.val");
        e4aval->tooltip("Starting value");
        e4aval->box(FL_ROUND_UP_BOX);
        e4aval->color(FL_BACKGROUND_COLOR);
        e4aval->selection_color(FL_INACTIVE_COLOR);
        e4aval->labeltype(FL_NORMAL_LABEL);
        e4aval->labelfont(0);
        e4aval->labelsize(10);
        e4aval->labelcolor(FL_FOREGROUND_COLOR);
        e4aval->maximum(127);
        e4aval->step(1);
        e4aval->callback((Fl_Callback*)cb_e4aval);
        e4aval->align(Fl_Align(FL_ALIGN_BOTTOM));
        e4aval->when(FL_WHEN_CHANGED);
        o->value(env->PA_val);
      } // WidgetPDial* e4aval
      { WidgetPDial* o = e4adt = new WidgetPDial(40, 20, 30, 30, "A.dt");
        e4adt->tooltip("Attack time");
        e4adt->box(FL_ROUND_UP_BOX);
        e4adt->color(FL_BACKGROUND_COLOR);
        e4adt->selection_color(FL_INACTIVE_COLOR);
        e4adt->labeltype(FL_NORMAL_LABEL);
        e4adt->labelfont(0);
        e4adt->labelsize(10);
        e4adt->labelcolor(FL_FOREGROUND_COLOR);
        e4adt->maximum(127);
        e4adt->step(1);
        e4adt->callback((Fl_Callback*)cb_e4adt);
        e4adt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e4adt->when(FL_WHEN_CHANGED);
        o->value(env->PA_dt);
      } // WidgetPDial* e4adt
      { WidgetPDial* o = e4rval = new WidgetPDial(110, 20, 30, 30, "R.val");
        e4rval->tooltip("Release value");
        e4rval->box(FL_ROUND_UP_BOX);
        e4rval->color(FL_BACKGROUND_COLOR);
        e4rval->selection_color(FL_INACTIVE_COLOR);
        e4rval->labeltype(FL_NORMAL_LABEL);
        e4rval->labelfont(0);
        e4rval->labelsize(10);
        e4rval->labelcolor(FL_FOREGROUND_COLOR);
        e4rval->maximum(127);
        e4rval->step(1);
        e4rval->callback((Fl_Callback*)cb_e4rval);
        e4rval->align(Fl_Align(FL_ALIGN_BOTTOM));
        e4rval->when(FL_WHEN_CHANGED);
        o->value(env->PR_val);
      } // WidgetPDial* e4rval
      { WidgetPDial* o = e4rdt = new WidgetPDial(75, 20, 30, 30, "R.dt");
        e4rdt->tooltip("Release time");
        e4rdt->box(FL_ROUND_UP_BOX);
        e4rdt->color(FL_BACKGROUND_COLOR);
        e4rdt->selection_color(FL_INACTIVE_COLOR);
        e4rdt->labeltype(FL_NORMAL_LABEL);
        e4rdt->labelfont(0);
        e4rdt->labelsize(10);
        e4rdt->labelcolor(FL_FOREGROUND_COLOR);
        e4rdt->maximum(127);
        e4rdt->step(1);
        e4rdt->callback((Fl_Callback*)cb_e4rdt);
        e4rdt->align(Fl_Align(FL_ALIGN_BOTTOM));
        e4rdt->when(FL_WHEN_CHANGED);
        o->value(env->PR_dt);
      } // WidgetPDial* e4rdt
      { WidgetPDial* o = e4envstretch = new WidgetPDial(145, 25, 25, 25, "Stretch");
        e4envstretch->tooltip("Envelope stretch (on lower notes makes the envelope longer)");
        e4envstretch->box(FL_ROUND_UP_BOX);
        e4envstretch->color(FL_BACKGROUND_COLOR);
        e4envstretch->selection_color(FL_INACTIVE_COLOR);
        e4envstretch->labeltype(FL_NORMAL_LABEL);
        e4envstretch->labelfont(0);
        e4envstretch->labelsize(10);
        e4envstretch->labelcolor(FL_FOREGROUND_COLOR);
        e4envstretch->maximum(127);
        e4envstretch->step(1);
        e4envstretch->callback((Fl_Callback*)cb_e4envstretch);
        e4envstretch->align(Fl_Align(FL_ALIGN_BOTTOM));
        e4envstretch->when(FL_WHEN_CHANGED);
        o->value(env->Penvstretch);
      } // WidgetPDial* e4envstretch
      { Fl_Check_Button* o = e4forcedrelease = new Fl_Check_Button(180, 25, 15, 25, "frcR");
        e4forcedrelease->tooltip("Forced release");
        e4forcedrelease->down_box(FL_DOWN_BOX);
        e4forcedrelease->labelsize(10);
        e4forcedrelease->callback((Fl_Callback*)cb_e4forcedrelease);
        e4forcedrelease->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
        o->value(env->Pforcedrelease);
      } // Fl_Check_Button* e4forcedrelease
      { Fl_Button* o = new Fl_Button(155, 5, 15, 15, "C");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_C4);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(172, 5, 15, 15, "P");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_P4);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Button* o = new Fl_Button(190, 5, 15, 15, "E");
      o->box(FL_PLASTIC_UP_BOX);
      o->labelfont(1);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_E3);
    } // Fl_Button* o
    envASRbw->end();
  } // Fl_Group* envASRbw
  return envASRbw;
}

Fl_Group* EnvelopeUI::make_free_window() {
  { envfree = new Fl_Group(0, 0, 205, 70);
    envfree->box(FL_FLAT_BOX);
    envfree->color(FL_LIGHT1);
    envfree->selection_color(FL_BACKGROUND_COLOR);
    envfree->labeltype(FL_NO_LABEL);
    envfree->labelfont(1);
    envfree->labelsize(14);
    envfree->labelcolor(FL_FOREGROUND_COLOR);
    envfree->user_data((void*)(this));
    envfree->align(Fl_Align(FL_ALIGN_TOP));
    envfree->when(FL_WHEN_RELEASE);
    { envfreegroup = new Fl_Group(0, 0, 205, 70, "Amplitude Envelope");
      envfreegroup->box(FL_PLASTIC_UP_BOX);
      envfreegroup->color(FL_CYAN);
      envfreegroup->labeltype(FL_ENGRAVED_LABEL);
      envfreegroup->labelsize(10);
      envfreegroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeFreeEdit* o = freeeditsmall = new EnvelopeFreeEdit(5, 20, 195, 45, "Envelope");
        freeeditsmall->box(FL_FLAT_BOX);
        freeeditsmall->color(FL_FOREGROUND_COLOR);
        freeeditsmall->selection_color(FL_BACKGROUND_COLOR);
        freeeditsmall->labeltype(FL_NORMAL_LABEL);
        freeeditsmall->labelfont(0);
        freeeditsmall->labelsize(14);
        freeeditsmall->labelcolor(FL_FOREGROUND_COLOR);
        freeeditsmall->callback((Fl_Callback*)cb_freeeditsmall);
        freeeditsmall->align(Fl_Align(FL_ALIGN_CENTER));
        freeeditsmall->when(FL_WHEN_RELEASE);
        Fl_Group::current()->resizable(freeeditsmall);
        o->init(env);
      } // EnvelopeFreeEdit* freeeditsmall
      { Fl_Button* o = new Fl_Button(185, 5, 15, 15, "E");
        o->box(FL_PLASTIC_UP_BOX);
        o->labelfont(1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_E4);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(150, 5, 15, 15, "C");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_C5);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(167, 5, 15, 15, "P");
        o->box(FL_THIN_UP_BOX);
        o->color((Fl_Color)179);
        o->labelfont(1);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->callback((Fl_Callback*)cb_P5);
      } // Fl_Button* o
      envfreegroup->end();
      Fl_Group::current()->resizable(envfreegroup);
    } // Fl_Group* envfreegroup
    envfree->end();
  } // Fl_Group* envfree
  return envfree;
}

void EnvelopeUI::init(EnvelopeParams *env_) {
  env=env_;
make_ADSR_window();
make_ASR_window();
make_ADSRfilter_window();
make_ASRbw_window();
make_free_window();

make_freemode_edit_window();

envwindow=NULL;
if (env->Envmode==3) envfreegroup->label("Frequency Envelope");
if (env->Envmode==4) envfreegroup->label("Filter Envelope");
if (env->Envmode==5) envfreegroup->label("Bandwidth Envelope");

freemodeeditwindow->label(this->label());


freeeditsmall->setpair(freeedit);
freeedit->setpair(freeeditsmall);


refresh();
}

void EnvelopeUI::reinit() {
  if (env->Pfreemode!=0){
  int answer=fl_choice("Disable the free mode of the Envelope?","No","Yes",NULL);
  if (env->Pfreemode!=0) freemodebutton->value(1);
          else freemodebutton->value(0);
  if (answer==0) return;
};

if (env->Pfreemode==0) env->Pfreemode=1;
     else env->Pfreemode=0;

hide();
int winx=freemodeeditwindow->x();
int winy=freemodeeditwindow->y();

freemodeeditwindow->hide();

envwindow->hide();
Fl_Group *par=envwindow->parent();
par->hide();


refresh();
envwindow->show();
par->redraw();

par->show();
show();
freemodeeditwindow->position(winx,winy);
freemodeeditwindow->show();

if (env->Pfreemode!=0) {
	freemodebutton->value(1);
	addpoint->show();
	deletepoint->show();
	forcedreleasecheck->show();
}else{
	freemodebutton->value(0);
	addpoint->hide();
	deletepoint->hide();
	forcedreleasecheck->hide();
};
}

void EnvelopeUI::refresh() {
  freemodebutton->value(env->Pfreemode);

sustaincounter->value(env->Penvsustain);
if (env->Pfreemode==0) sustaincounter->hide();
	else sustaincounter->show();
sustaincounter->maximum(env->Penvpoints-2);

envstretchdial->value(env->Penvstretch);
if (env->Pfreemode==0) envstretchdial->hide();
	else envstretchdial->show();

linearenvelopecheck->value(env->Plinearenvelope);
if ((env->Pfreemode==0)||(env->Envmode>2)) linearenvelopecheck->hide();
	else linearenvelopecheck->show();

forcedreleasecheck->value(env->Pforcedrelease);
if (env->Pfreemode==0) forcedreleasecheck->hide();

freeedit->redraw();


if (env->Pfreemode==0){
   switch(env->Envmode){
         case(1):
         case(2):
		e1adt->value(env->PA_dt);
		e1ddt->value(env->PD_dt);
		e1sval->value(env->PS_val);
		e1rdt->value(env->PR_dt);
		e1envstretch->value(env->Penvstretch);
		e1linearenvelope->value(env->Plinearenvelope);
		e1forcedrelease->value(env->Pforcedrelease);
         break;
         case(3):
		e2aval->value(env->PA_val);
		e2adt->value(env->PA_dt);
		e2rdt->value(env->PR_dt);
		e2rval->value(env->PR_val);
		e2envstretch->value(env->Penvstretch);
		e2forcedrelease->value(env->Pforcedrelease);
         break; 
         case(4):
		e3aval->value(env->PA_val);
		e3adt->value(env->PA_dt);
		e3dval->value(env->PD_val);
		e3ddt->value(env->PD_dt);
		e3rdt->value(env->PR_dt);
		e3rval->value(env->PR_val);
		e3envstretch->value(env->Penvstretch);
		e3forcedrelease->value(env->Pforcedrelease);
         break; 
         case(5):
		e4aval->value(env->PA_val);
		e4adt->value(env->PA_dt);
		e4rdt->value(env->PR_dt);
		e4rval->value(env->PR_val);
		e4envstretch->value(env->Penvstretch);
		e4forcedrelease->value(env->Pforcedrelease);
         break;
         default:
         break; 
   };
}else{
       envfree->redraw();
};


envADSR->hide();
envASR->hide();
envADSRfilter->hide();
envASRbw->hide();
envfree->hide();

if (env->Pfreemode==0){
   switch(env->Envmode){
         case(1):
         case(2):
           envwindow=envADSR;
         break;
         case(3):
           envwindow=envASR;
         break; 
         case(4):
           envwindow=envADSRfilter;
         break; 
         case(5):
          envwindow=envASRbw;
         break;
         default:
         break; 
   };
}else{
   envwindow=envfree;
};

envwindow->resize(this->x(),this->y(),this->w(),this->h());

envwindow->show();
}
