// interface.c
// LiVES
// (c) G. Finch 2003 - 2013 <salsaman@gmail.com>
// Released under the GNU GPL 3 or later
// see file ../COPYING for licensing details

// TODO - use lives_widget_showall where poss.
// and don't forget lives_box_pack_end (doh)
// and just use label instead of labelnn, etc.


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include "main.h"
#include "callbacks.h"
#include "interface.h"
#include "merge.h"
#include "support.h"

// functions called in multitrack.c
extern void multitrack_preview_clicked  (GtkButton *, gpointer user_data);
extern void mt_change_disp_tracks_ok (GtkButton *, gpointer user_data);


void add_suffix_check(GtkBox *box, const gchar *ext) {
  gchar *ltext;

  GtkWidget *checkbutton;

  if (ext==NULL) ltext=g_strdup (_ ("Let LiVES set the _file extension"));
  else ltext=g_strdup_printf(_ ("Let LiVES set the _file extension (.%s)"),ext);
  checkbutton=lives_standard_check_button_new(ltext,TRUE,box,NULL);
  g_free(ltext);
  lives_toggle_button_set_active (LIVES_TOGGLE_BUTTON (checkbutton), mainw->fx1_bool);
  g_signal_connect_after (GTK_OBJECT (checkbutton), "toggled",
			  G_CALLBACK (on_boolean_toggled),
			  &mainw->fx1_bool);
  
}



static GtkWidget *add_deinterlace_checkbox(GtkBox *for_deint) {
  GtkWidget *hbox=lives_hbox_new (FALSE, 0);
  GtkWidget *checkbutton = lives_standard_check_button_new (_ ("Apply _Deinterlace"),TRUE,LIVES_BOX(hbox),NULL);

  if (LIVES_IS_HBOX(for_deint)) {
    GtkWidget *filler;
    lives_box_pack_start (for_deint, hbox, FALSE, FALSE, widget_opts.packing_width);
    lives_box_reorder_child(for_deint, hbox, 0);
    filler=add_fill_to_box(LIVES_BOX(for_deint));
    if (filler!=NULL) lives_box_reorder_child(for_deint, filler, 1);
  }
  else lives_box_pack_start (for_deint, hbox, FALSE, FALSE, widget_opts.packing_height);

  lives_widget_set_can_focus_and_default (checkbutton);
  lives_toggle_button_set_active (LIVES_TOGGLE_BUTTON (checkbutton), mainw->open_deint);
  g_signal_connect_after (GTK_OBJECT (checkbutton), "toggled",
			  G_CALLBACK (on_boolean_toggled),
			  &mainw->open_deint);
  lives_widget_set_tooltip_text( checkbutton,_("If this is set, frames will be deinterlaced as they are imported."));

  lives_widget_show_all(LIVES_WIDGET(for_deint));

  return hbox;
}


static void pv_sel_changed(GtkFileChooser *chooser, gpointer user_data) {
  GSList *slist=lives_file_chooser_get_filenames (chooser);
  GtkWidget *pbutton=(GtkWidget *)user_data;

  if (slist==NULL||slist->data==NULL||g_slist_length(slist)>1||!(g_file_test((gchar *)slist->data,G_FILE_TEST_IS_REGULAR))) {
    lives_widget_set_sensitive(pbutton,FALSE);
  }
  else lives_widget_set_sensitive(pbutton,TRUE);
  
  if (slist!=NULL) {
    g_list_free_strings((GList *)slist);
    g_slist_free(slist);
  }
}





void widget_add_preview(GtkWidget *widget, LiVESBox *for_preview, LiVESBox *for_button, LiVESBox *for_deint, int preview_type) {
  // preview type 1 - video and audio, fileselector
  // preview type 2 - audio only, fileselector
  // preview type 3 - range preview

  GtkWidget *preview_button=NULL;
  GtkWidget *fs_label;

  mainw->fs_playframe = gtk_frame_new (NULL);
  mainw->fs_playalign = gtk_alignment_new (0.,0.,1.,1.);
  mainw->fs_playarea = lives_event_box_new ();

  if (preview_type==1||preview_type==3) {

    lives_widget_show (mainw->fs_playframe);
    lives_widget_show (mainw->fs_playalign);

    lives_container_set_border_width (LIVES_CONTAINER(mainw->fs_playframe), widget_opts.border_width);

    widget_opts.justify=LIVES_JUSTIFY_RIGHT;
    fs_label = lives_standard_label_new (_ ("Preview"));
    widget_opts.justify=LIVES_JUSTIFY_DEFAULT;
    lives_widget_show (fs_label);
    gtk_frame_set_label_widget (GTK_FRAME (mainw->fs_playframe), fs_label);

    lives_box_pack_start (for_preview, mainw->fs_playframe, FALSE, FALSE, 0);
    lives_widget_set_size_request (mainw->fs_playarea, DEFAULT_FRAME_HSIZE, DEFAULT_FRAME_VSIZE);

    lives_container_add (LIVES_CONTAINER (mainw->fs_playframe), mainw->fs_playalign);
    lives_container_add (LIVES_CONTAINER (mainw->fs_playalign), mainw->fs_playarea);

    lives_widget_set_bg_color (mainw->fs_playarea, LIVES_WIDGET_STATE_NORMAL, &palette->black);
    lives_widget_set_bg_color (mainw->fs_playframe, LIVES_WIDGET_STATE_NORMAL, &palette->black);
    lives_widget_set_bg_color (mainw->fs_playalign, LIVES_WIDGET_STATE_NORMAL, &palette->black);

    lives_widget_show(mainw->fs_playarea);
   }

  if (preview_type==1) {
    preview_button = lives_button_new_with_mnemonic (_ ("Click here to _Preview any selected video, image or audio file"));
  }
  else if (preview_type==2) {
    preview_button = lives_button_new_with_mnemonic (_ ("Click here to _Preview any selected audio file"));
  }
  else if (preview_type==3) {
    preview_button = lives_button_new_with_mnemonic (_ ("Click here to _Preview the video"));
  }

  lives_widget_show (preview_button);


  lives_box_pack_start (for_button, preview_button, FALSE, FALSE, widget_opts.packing_width);

  if (preview_type==1||preview_type==3) {
    add_deinterlace_checkbox(for_deint);
  }


  g_signal_connect (GTK_OBJECT (preview_button), "clicked",
		    G_CALLBACK (on_fs_preview_clicked),
		    GINT_TO_POINTER (preview_type));

  if (GTK_IS_FILE_CHOOSER(widget)) {
    lives_widget_set_sensitive(preview_button,FALSE);
    
    g_signal_connect (GTK_OBJECT (widget), "selection_changed",
		      G_CALLBACK (pv_sel_changed),
		      (gpointer)preview_button);
  }

}


xprocess * create_processing (const gchar *text) {

  GtkWidget *dialog_vbox;
  GtkWidget *vbox2;
  GtkWidget *vbox3;
  GtkWidget *dialog_action_area;
  GtkWidget *details_arrow;

  GtkAccelGroup *accel_group=GTK_ACCEL_GROUP(lives_accel_group_new ());

  xprocess *procw=(xprocess*)(g_malloc(sizeof(xprocess)));

  gchar tmp_label[256];

  widget_opts.non_modal=TRUE;
  procw->processing = lives_standard_dialog_new (_("LiVES: - Processing..."),FALSE);
  widget_opts.non_modal=FALSE;

  lives_window_add_accel_group (LIVES_WINDOW (procw->processing), accel_group);

  if (prefs->show_gui) {
    if (mainw->multitrack==NULL) lives_window_set_transient_for(LIVES_WINDOW(procw->processing),GTK_WINDOW(mainw->LiVES));
    else lives_window_set_transient_for(LIVES_WINDOW(procw->processing),GTK_WINDOW(mainw->multitrack->window));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(procw->processing));
  lives_widget_show (dialog_vbox);

  vbox2 = lives_vbox_new (FALSE, 0);
  lives_widget_show (vbox2);
  lives_box_pack_start (LIVES_BOX (dialog_vbox), vbox2, TRUE, TRUE, 0);

  vbox3 = lives_vbox_new (FALSE, 0);
  lives_widget_show (vbox3);
  lives_box_pack_start (LIVES_BOX (vbox2), vbox3, TRUE, TRUE, 0);

  g_snprintf(tmp_label,256,"%s...\n",text);
  procw->label = lives_standard_label_new (tmp_label);
  lives_widget_show (procw->label);

  lives_box_pack_start (LIVES_BOX (vbox3), procw->label, TRUE, TRUE, 0);

  procw->progressbar = gtk_progress_bar_new ();
  lives_widget_show (procw->progressbar);
  lives_box_pack_start (LIVES_BOX (vbox3), procw->progressbar, FALSE, FALSE, 0);
  if (palette->style&STYLE_1) {
    lives_widget_set_fg_color(procw->progressbar, LIVES_WIDGET_STATE_NORMAL, &palette->normal_fore);
  }

  widget_opts.justify=LIVES_JUSTIFY_CENTER;
  if (mainw->internal_messaging&&mainw->rte!=0) {
    procw->label2 = lives_standard_label_new (_("\n\nPlease Wait\n\nRemember to switch off effects (ctrl-0) afterwards !"));
  }
#ifdef RT_AUDIO
  else if (mainw->jackd_read!=NULL||mainw->pulsed_read!=NULL) procw->label2 = lives_label_new ("");
#endif
  else procw->label2=lives_standard_label_new (_("\nPlease Wait"));
  widget_opts.justify=LIVES_JUSTIFY_DEFAULT;

  lives_widget_show (procw->label2);

  lives_box_pack_start (LIVES_BOX (vbox3), procw->label2, FALSE, FALSE, 0);

  widget_opts.justify=LIVES_JUSTIFY_CENTER;
  procw->label3 = lives_standard_label_new (PROCW_STRETCHER);
  lives_widget_show (procw->label3);
  lives_box_pack_start (LIVES_BOX (vbox3), procw->label3, FALSE, FALSE, 0);
  widget_opts.justify=LIVES_JUSTIFY_DEFAULT;

  if (mainw->iochan!=NULL) {
    // add "show details" arrow
    boolean woat=widget_opts.apply_theme;
    widget_opts.apply_theme=FALSE;
    procw->scrolledwindow = lives_standard_scrolled_window_new (ENC_DETAILS_WIN_H, ENC_DETAILS_WIN_V, LIVES_WIDGET(mainw->optextview));
    widget_opts.apply_theme=woat;

    details_arrow=lives_standard_expander_new(_("Show Details"),FALSE,LIVES_BOX(vbox3),procw->scrolledwindow);

    lives_widget_show_all(details_arrow);

  }


  lives_widget_show_all(vbox3);

  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (procw->processing));
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  procw->stop_button = lives_button_new_with_mnemonic (_ ("_Enough"));
  procw->preview_button = lives_button_new_with_mnemonic (_ ("_Preview"));

  if (cfile->nokeep) procw->pause_button = lives_button_new_with_mnemonic (_ ("Paus_e"));
  else procw->pause_button = lives_button_new_with_mnemonic (_ ("Pause/_Enough"));

  lives_dialog_add_action_widget (LIVES_DIALOG (procw->processing), procw->preview_button, 1);
  lives_widget_hide(procw->preview_button);
  lives_widget_set_can_focus_and_default (procw->preview_button);
    
  lives_dialog_add_action_widget (LIVES_DIALOG (procw->processing), procw->pause_button, 0);
  lives_widget_hide(procw->pause_button);
  lives_widget_set_can_focus_and_default (procw->pause_button);


  if (mainw->current_file>-1) {
    if (cfile->opening_loc
#ifdef ENABLE_JACK
	||mainw->jackd_read!=NULL
#endif
#ifdef HAVE_PULSE_AUDIO
	||mainw->pulsed_read!=NULL
#endif
	) {
      // the "enough" button for opening
      lives_dialog_add_action_widget (LIVES_DIALOG (procw->processing), procw->stop_button, 0);
      lives_widget_show(procw->stop_button);
      lives_widget_set_can_focus_and_default (procw->stop_button);
    }
  }
  
  procw->cancel_button = lives_button_new_with_mnemonic (_ ("_Cancel"));
  lives_dialog_add_action_widget (LIVES_DIALOG (procw->processing), procw->cancel_button, GTK_RESPONSE_CANCEL);
  lives_widget_set_can_focus_and_default (procw->cancel_button);

  lives_widget_add_accelerator (procw->cancel_button, "activate", accel_group,
                              LIVES_KEY_Escape, (GdkModifierType)0, (GtkAccelFlags)0);

  g_signal_connect (GTK_OBJECT (procw->stop_button), "clicked",
		    G_CALLBACK (on_stop_clicked),
		    NULL);

  g_signal_connect (GTK_OBJECT (procw->pause_button), "clicked",
                      G_CALLBACK (on_effects_paused),
                      NULL);

  if (mainw->multitrack!=NULL&&mainw->multitrack->is_rendering) {
    g_signal_connect (GTK_OBJECT (procw->preview_button), "clicked",
                      G_CALLBACK (multitrack_preview_clicked),
                      mainw->multitrack);
  }
  else {
    g_signal_connect (GTK_OBJECT (procw->preview_button), "clicked",
                      G_CALLBACK (on_preview_clicked),
                      NULL);
  }

  g_signal_connect (GTK_OBJECT (procw->cancel_button), "clicked",
                      G_CALLBACK (on_cancel_keep_button_clicked),
                      NULL);


  return procw;
}


#define TB_WIDTH 200
#define TB_HEIGHT_VID 80
#define TB_HEIGHT_AUD 50

static GtkWidget *vid_text_view_new(void) {
  GtkWidget *textview=gtk_text_view_new();

  if (palette->style&STYLE_1) {
    lives_widget_set_base_color(textview, LIVES_WIDGET_STATE_NORMAL, &palette->info_base);
    lives_widget_set_text_color(textview, LIVES_WIDGET_STATE_NORMAL, &palette->info_text);
  }

  lives_widget_set_size_request (textview, TB_WIDTH, TB_HEIGHT_VID);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (textview), FALSE);
  gtk_text_view_set_justification (GTK_TEXT_VIEW (textview), GTK_JUSTIFY_CENTER);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textview), FALSE);

  return textview;
}

static GtkWidget *aud_text_view_new(void) {
  GtkWidget *textview=gtk_text_view_new();

  if (palette->style&STYLE_1) {
    lives_widget_set_base_color(textview, LIVES_WIDGET_STATE_NORMAL, &palette->info_base);
    lives_widget_set_text_color(textview, LIVES_WIDGET_STATE_NORMAL, &palette->info_text);
  }

  lives_widget_set_size_request (textview, TB_WIDTH, TB_HEIGHT_AUD);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (textview), FALSE);
  gtk_text_view_set_justification (GTK_TEXT_VIEW (textview), GTK_JUSTIFY_CENTER);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textview), FALSE);

  return textview;
}


lives_clipinfo_t *create_clip_info_window (int audio_channels, boolean is_mt) {
  // TODO : rewrite this horrible code

  GtkWidget *dialog_vbox;
  GtkWidget *dialog_action_area;
  GtkWidget *frame4;
  GtkWidget *fixed3;
  GtkWidget *fixed5;
  GtkWidget *fixed6;
  GtkWidget *label45;
  GtkWidget *label46;
  GtkWidget *label47;
  GtkWidget *label48;
  GtkWidget *label44;
  GtkWidget *label43;
  GtkWidget *label40;
  GtkWidget *label50;
  GtkWidget *label51;
  GtkWidget *label52;
  GtkWidget *label53;
  GtkWidget *frame5;
  GtkWidget *left;
  GtkWidget *frame6;
  GtkWidget *right;
  GtkWidget *okbutton;

  GtkAccelGroup *accel_group;

  lives_clipinfo_t *filew=(lives_clipinfo_t *)(g_malloc(sizeof(lives_clipinfo_t)));

  gchar *title;

  if (mainw->multitrack==NULL)
    title=g_strdup_printf(_("LiVES: - %s"),cfile->name);
  else 
    title=g_strdup(_("LiVES: - Multitrack details"));

  filew->dialog = lives_standard_dialog_new(title,FALSE);
  g_free(title);

  accel_group = GTK_ACCEL_GROUP(lives_accel_group_new ());
  lives_window_add_accel_group (LIVES_WINDOW (filew->dialog), accel_group);

  if (prefs->show_gui) {
    if (mainw->multitrack==NULL) lives_window_set_transient_for(LIVES_WINDOW(filew->dialog),GTK_WINDOW(mainw->LiVES));
    else lives_window_set_transient_for(LIVES_WINDOW(filew->dialog),GTK_WINDOW(mainw->multitrack->window));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(filew->dialog));

  if (cfile->frames>0||is_mt) {
    frame4 = gtk_frame_new (NULL);

    lives_box_pack_start (LIVES_BOX (dialog_vbox), frame4, TRUE, TRUE, 0);
    if (palette->style&STYLE_1) {
      lives_widget_set_bg_color(frame4, LIVES_WIDGET_STATE_NORMAL, &palette->normal_back);
    }

    fixed3 = gtk_fixed_new ();
    lives_container_add (LIVES_CONTAINER (frame4), fixed3);
    lives_container_set_border_width (LIVES_CONTAINER (fixed3), widget_opts.border_width);
    
    filew->textview24 = vid_text_view_new ();
    gtk_fixed_put (GTK_FIXED (fixed3), filew->textview24, TB_WIDTH, 48);
    
    filew->textview25 = vid_text_view_new ();
    gtk_fixed_put (GTK_FIXED (fixed3), filew->textview25, TB_WIDTH+400, 48);
  
    filew->textview26 = vid_text_view_new ();
    gtk_fixed_put (GTK_FIXED (fixed3), filew->textview26, TB_WIDTH, 136);
    
    filew->textview27 = vid_text_view_new ();
    gtk_fixed_put (GTK_FIXED (fixed3), filew->textview27, TB_WIDTH+400, 136);
    
    filew->textview28 = vid_text_view_new ();
    gtk_fixed_put (GTK_FIXED (fixed3), filew->textview28, TB_WIDTH+400, 224);
    
    filew->textview29 = vid_text_view_new ();
    gtk_fixed_put (GTK_FIXED (fixed3), filew->textview29, TB_WIDTH, 224);
    
    label45 = lives_standard_label_new (_("Format"));

    gtk_fixed_put (GTK_FIXED (fixed3), label45, 44, 64);
    lives_widget_set_size_request (label45, 125, 20);

    label46 = lives_standard_label_new (_("Frame size"));

    gtk_fixed_put (GTK_FIXED (fixed3), label46, 18, 152);
    lives_widget_set_size_request (label46, 145, 20);

    if (!is_mt) label47 = lives_standard_label_new (_("File size"));
    else label47 = lives_standard_label_new (_("Byte size"));

    gtk_fixed_put (GTK_FIXED (fixed3), label47, 18, 240);
    lives_widget_set_size_request (label47, 145, 20);

    label48 = lives_standard_label_new (_("Total time"));

    gtk_fixed_put (GTK_FIXED (fixed3), label48, 450, 240);
    lives_widget_set_size_request (label48, 145, 20);

    label44 = lives_standard_label_new (_("FPS"));

    gtk_fixed_put (GTK_FIXED (fixed3), label44, 476, 64);
    lives_widget_set_size_request (label44, 120, 20);

    if (!is_mt) label43 = lives_standard_label_new (_("Frames"));
    else label43 = lives_standard_label_new (_("Events"));

    gtk_fixed_put (GTK_FIXED (fixed3), label43, 476, 152);
    lives_widget_set_size_request (label43, 125, 20);

    label40 = lives_standard_label_new (_("Video"));

    gtk_frame_set_label_widget (GTK_FRAME (frame4), label40);
  }

  if (audio_channels>0) {
    frame5 = gtk_frame_new (NULL);

    lives_box_pack_start (LIVES_BOX (dialog_vbox), frame5, TRUE, TRUE, 0);
    if (palette->style&STYLE_1) {
      lives_widget_set_bg_color(frame5, LIVES_WIDGET_STATE_NORMAL, &palette->normal_back);
    }

    if (audio_channels>1) {
      left = lives_standard_label_new (_("Left Audio"));
    }
    else {
      left = lives_standard_label_new (_("Audio"));
    }

    gtk_frame_set_label_widget (GTK_FRAME (frame5), left);

    fixed5 = gtk_fixed_new ();
    lives_container_add (LIVES_CONTAINER (frame5), fixed5);
    lives_container_set_border_width (LIVES_CONTAINER (fixed5), widget_opts.border_width);

    if (!is_mt) {
      filew->textview_ltime = aud_text_view_new ();
      gtk_fixed_put (GTK_FIXED (fixed5), filew->textview_ltime, TB_WIDTH+400, 16);
      
      label50 = lives_standard_label_new (_("Total time"));

      gtk_fixed_put (GTK_FIXED (fixed5), label50, 450, 32);
      lives_widget_set_size_request (label50, 145, 16);
    }

    filew->textview_lrate = aud_text_view_new ();
    gtk_fixed_put (GTK_FIXED (fixed5), filew->textview_lrate, TB_WIDTH, 16);
    
    label52 = lives_standard_label_new (_("Rate/size"));
    gtk_fixed_put (GTK_FIXED (fixed5), label52, 30, 32);
    lives_widget_set_size_request (label52, 130, 16);

    if (audio_channels>1) {
      frame6 = gtk_frame_new (NULL);

      lives_box_pack_start (LIVES_BOX (dialog_vbox), frame6, TRUE, TRUE, 0);
      if (palette->style&STYLE_1) {
	lives_widget_set_bg_color(frame6, LIVES_WIDGET_STATE_NORMAL, &palette->normal_back);
      }

      fixed6 = gtk_fixed_new ();
      lives_container_add (LIVES_CONTAINER (frame6), fixed6);
      lives_container_set_border_width (LIVES_CONTAINER (fixed6), widget_opts.border_width);
      
      if (!is_mt) {
	filew->textview_rtime = aud_text_view_new ();
	gtk_fixed_put (GTK_FIXED (fixed6), filew->textview_rtime, TB_WIDTH+400, 16);
	
	label51 = lives_standard_label_new (_("Total time"));
	gtk_fixed_put (GTK_FIXED (fixed6), label51, 450, 32);
	lives_widget_set_size_request (label51, 145, 16);
      }

      filew->textview_rrate = aud_text_view_new ();
      gtk_fixed_put (GTK_FIXED (fixed6), filew->textview_rrate, TB_WIDTH, 16);
      
      label53 = lives_standard_label_new (_("Rate/size"));
      gtk_fixed_put (GTK_FIXED (fixed6), label53, 30, 32);
      lives_widget_set_size_request (label53, 130, 16);
      
      right = lives_standard_label_new (_("Right audio"));

      gtk_frame_set_label_widget (GTK_FRAME (frame6), right);
    }
  }

  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (filew->dialog));
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);

  okbutton = lives_button_new_from_stock ("gtk-ok");
  lives_dialog_add_action_widget (LIVES_DIALOG (filew->dialog), okbutton, GTK_RESPONSE_OK);
  lives_widget_set_can_focus_and_default (okbutton);
  lives_widget_grab_default (okbutton);

  lives_widget_set_size_request(okbutton,DEF_BUTTON_WIDTH*4,-1);

  g_signal_connect (GTK_OBJECT (okbutton), "clicked",
                      G_CALLBACK (lives_general_button_clicked),
                      filew);

  accel_group = GTK_ACCEL_GROUP(lives_accel_group_new ());
  lives_window_add_accel_group (LIVES_WINDOW (filew->dialog), accel_group);

  lives_widget_add_accelerator (okbutton, "activate", accel_group,
                              LIVES_KEY_Escape, (GdkModifierType)0, (GtkAccelFlags)0);


  lives_widget_show_all(filew->dialog);

  return filew;
}


static void on_resizecb_toggled (GtkToggleButton *t, gpointer user_data) {
  GtkWidget *cb=(GtkWidget *)user_data;

  if (!lives_toggle_button_get_active(t)) {
    lives_widget_set_sensitive(cb,FALSE);
    lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(cb),FALSE);
  }
  else {
    lives_widget_set_sensitive(cb,TRUE);
    lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(cb),prefs->enc_letterbox);
  }
}




GtkWidget* create_encoder_prep_dialog (const gchar *text1, const gchar *text2, boolean opt_resize) {
  GtkWidget *dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *dialog_action_area;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;
  GtkWidget *checkbutton=NULL;
  GtkWidget *checkbutton2;
  GtkWidget *label;
  GtkWidget *hbox;

  gchar *labeltext,*tmp,*tmp2;

  dialog = lives_standard_dialog_new (_("LiVES: - Encoding options"),FALSE);

  if (prefs->show_gui) {
    lives_window_set_transient_for(LIVES_WINDOW(dialog),GTK_WINDOW(mainw->LiVES));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(dialog));

  widget_opts.justify=LIVES_JUSTIFY_CENTER;
  label = lives_standard_label_new (text1);
  widget_opts.justify=LIVES_JUSTIFY_DEFAULT;
  lives_box_pack_start (LIVES_BOX (dialog_vbox), label, TRUE, TRUE, 0);

  if (opt_resize) {      
    if (text2!=NULL) labeltext=g_strdup (_("<------------- (Check the box to re_size as suggested)"));
    else labeltext=g_strdup (_("<------------- (Check the box to use the _size recommendation)"));

    hbox = lives_hbox_new (FALSE, 0);
    lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, FALSE, FALSE, widget_opts.packing_width);

    checkbutton = lives_standard_check_button_new (labeltext,TRUE,LIVES_BOX(hbox),NULL);

    g_free(labeltext);
    
    g_signal_connect_after (GTK_OBJECT (checkbutton), "toggled",
			    G_CALLBACK (on_boolean_toggled),
			    &mainw->fx1_bool);

  }
  else if (text2==NULL) mainw->fx1_bool=TRUE;

  if (text2!=NULL&&(mainw->fx1_bool||opt_resize)) {

    hbox = lives_hbox_new (FALSE, 0);
    if (capable->has_composite&&capable->has_convert) {
      // only offer this if we have "composite" and "convert" - for now... TODO ****
      lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, FALSE, FALSE, widget_opts.packing_height);
    }

    checkbutton2 = lives_standard_check_button_new 
      ((tmp=g_strdup(_("Use _letterboxing to maintain aspect ratio (optional)"))),TRUE,LIVES_BOX(hbox),
       (tmp2=g_strdup(_("Draw black rectangles either above or to the sides of the image, to prevent it from stretching."))));

    g_free(tmp); g_free(tmp2);

    if (opt_resize) {
      lives_widget_set_sensitive(checkbutton2,FALSE);
      lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(checkbutton2),FALSE);
    }
    else lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(checkbutton2),prefs->enc_letterbox);
    
    g_signal_connect_after (GTK_OBJECT (checkbutton2), "toggled",
			    G_CALLBACK (on_boolean_toggled),
			    &prefs->enc_letterbox);

    if (opt_resize) 
      g_signal_connect_after (GTK_OBJECT (checkbutton), "toggled",
			      G_CALLBACK (on_resizecb_toggled),
			      checkbutton2);

  }

  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (dialog));
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  if (text2!=NULL) {
    label = lives_standard_label_new (text2);
    lives_box_pack_start (LIVES_BOX (dialog_vbox), label, TRUE, TRUE, 0);
    cancelbutton = lives_button_new_from_stock ("gtk-cancel");
    okbutton = lives_button_new_from_stock ("gtk-ok");
  }
  else {
    cancelbutton = lives_button_new_with_mnemonic (_("Keep _my settings"));
    okbutton = lives_button_new_with_mnemonic (_("Use _recommended settings"));
  }

  lives_dialog_add_action_widget (LIVES_DIALOG (dialog), cancelbutton, GTK_RESPONSE_CANCEL);
  lives_widget_set_can_focus_and_default (cancelbutton);

  lives_dialog_add_action_widget (LIVES_DIALOG (dialog), okbutton, GTK_RESPONSE_OK);

  lives_widget_set_can_focus_and_default (okbutton);
  lives_widget_grab_default (okbutton);

  lives_widget_show_all (dialog);
  return dialog;
}


// Information/error dialog
GtkWidget* create_info_error_dialog (const gchar *text, boolean is_blocking, int mask, lives_info_t info_type) {
  GtkWidget *dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *info_text;
  GtkWidget *dialog_action_area;
  GtkWidget *info_ok_button;
  GtkWidget *details_button;
  GtkWidget *checkbutton;
  GtkWidget *hbox;
  gchar *form_text;
  gchar *textx;

  GtkAccelGroup *accel_group=GTK_ACCEL_GROUP(lives_accel_group_new ());

  if (info_type==LIVES_INFO_TYPE_WARNING)
    dialog = gtk_message_dialog_new (NULL,(GtkDialogFlags)0,
				     GTK_MESSAGE_WARNING,GTK_BUTTONS_NONE,"%s","");
  else if (info_type==LIVES_INFO_TYPE_ERROR)
    dialog = gtk_message_dialog_new (NULL,(GtkDialogFlags)0,
				     GTK_MESSAGE_ERROR,GTK_BUTTONS_NONE,"%s","");
  else // INFO
    dialog = gtk_message_dialog_new (NULL,(GtkDialogFlags)0,
				     GTK_MESSAGE_INFO,GTK_BUTTONS_NONE,"%s","");

  lives_window_set_title (LIVES_WINDOW (dialog), _("LiVES"));
  
  lives_window_set_deletable(LIVES_WINDOW(dialog), FALSE);
  lives_window_set_resizable (LIVES_WINDOW (dialog), FALSE);

  lives_container_set_border_width (LIVES_CONTAINER (dialog), widget_opts.border_width*2);

  lives_window_add_accel_group (LIVES_WINDOW (dialog), accel_group);

  if (mainw!=NULL&&widget_opts.apply_theme&&palette->style&STYLE_1) {
    lives_dialog_set_has_separator(LIVES_DIALOG(dialog),FALSE);
    lives_widget_set_bg_color(dialog, LIVES_WIDGET_STATE_NORMAL, &palette->normal_back);
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(dialog));

  textx=insert_newlines(text,MAX_MSG_WIDTH_CHARS);

  form_text=g_strdup_printf("\n\n%s",textx);

  widget_opts.justify=LIVES_JUSTIFY_CENTER;
  info_text = lives_standard_label_new (form_text);
  widget_opts.justify=LIVES_JUSTIFY_DEFAULT;
  g_free(form_text);
  g_free(textx);

  gtk_label_set_selectable (LIVES_LABEL (info_text), TRUE);

  hbox = lives_hbox_new (FALSE, 0);
  lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, FALSE, FALSE, widget_opts.packing_height);

  lives_box_pack_start (LIVES_BOX (hbox), info_text, FALSE, FALSE, widget_opts.packing_width*2);
  
  if (mask>0) {
    hbox = lives_hbox_new (FALSE, 0);
    lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, FALSE, FALSE, widget_opts.packing_height);
    checkbutton = lives_standard_check_button_new (
						   _("Do _not show this warning any more\n(can be turned back on from Preferences/Warnings)"),
						   TRUE,LIVES_BOX(hbox),NULL);
    lives_widget_set_can_focus_and_default (checkbutton);
    g_signal_connect (GTK_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_warn_mask_toggled),
                      GINT_TO_POINTER(mask));
  }

  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (dialog));
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  if (mainw->iochan!=NULL) {
    details_button = lives_button_new_with_mnemonic(_("Show _Details"));
    lives_dialog_add_action_widget (LIVES_DIALOG (dialog), details_button, GTK_RESPONSE_YES);
    g_signal_connect (GTK_OBJECT (details_button), "clicked",
		      G_CALLBACK (on_details_button_clicked),
		      NULL);
  }
  
  info_ok_button = lives_button_new_from_stock ("gtk-ok");
  lives_dialog_add_action_widget (LIVES_DIALOG (dialog), info_ok_button, GTK_RESPONSE_OK);


  if (mainw->iochan==NULL) {
    lives_widget_set_can_focus_and_default (info_ok_button);
    lives_widget_grab_focus (info_ok_button);
    lives_widget_grab_default (info_ok_button);
  }

  g_signal_connect (GTK_OBJECT (info_ok_button), "clicked",
		    G_CALLBACK (lives_general_button_clicked),
		    NULL);

  lives_widget_add_accelerator (info_ok_button, "activate", accel_group,
			      LIVES_KEY_Return, (GdkModifierType)0, (GtkAccelFlags)0);



  lives_widget_show_all(dialog);
  if (is_blocking) lives_window_set_modal (LIVES_WINDOW (dialog), TRUE);

  if (prefs->present) {
    lives_window_present (LIVES_WINDOW (dialog));
    gdk_window_raise (lives_widget_get_xwindow(dialog));
  }

  return dialog;
}



text_window *create_text_window (const gchar *title, const gchar *text, GtkTextBuffer *textbuffer) {
  // general text window
  GtkWidget *dialog_vbox;
  GtkWidget *scrolledwindow;
  GtkWidget *dialog_action_area;
  GtkWidget *okbutton;

  gchar *mytitle=g_strdup(title);
  gchar *mytext=NULL;
  gchar *tmp;

  boolean woat;

  if (text!=NULL) mytext=g_strdup(text);

  textwindow=(text_window *)g_malloc(sizeof(text_window));

  textwindow->dialog = lives_standard_dialog_new ((tmp=g_strconcat ("LiVES: - ",mytitle,NULL)),FALSE);
  g_free(tmp);

  if (prefs->show_gui) {
    lives_window_set_transient_for(LIVES_WINDOW(textwindow->dialog),mainw->multitrack==NULL?
				 LIVES_WINDOW(mainw->LiVES):GTK_WINDOW(mainw->multitrack->window));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(textwindow->dialog));


  if (mainw->iochan!=NULL) {
    textwindow->textview=LIVES_WIDGET(mainw->optextview);
  }
  else {
    if (textbuffer!=NULL) textwindow->textview = gtk_text_view_new_with_buffer(textbuffer);
    else textwindow->textview = gtk_text_view_new ();
    gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (textwindow->textview), GTK_WRAP_WORD);
  }

  woat=widget_opts.apply_theme;
  widget_opts.apply_theme=FALSE;
  scrolledwindow = lives_standard_scrolled_window_new (RFX_WINSIZE_H, RFX_WINSIZE_V, textwindow->textview);
  widget_opts.apply_theme=woat;

  lives_box_pack_start (LIVES_BOX (dialog_vbox), scrolledwindow, TRUE, TRUE, 0);

  gtk_text_view_set_editable (GTK_TEXT_VIEW (textwindow->textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textwindow->textview), FALSE);

  if (palette->style&STYLE_1) {
    lives_widget_set_base_color(textwindow->textview, LIVES_WIDGET_STATE_NORMAL, &palette->info_base);
    lives_widget_set_text_color(textwindow->textview, LIVES_WIDGET_STATE_NORMAL, &palette->info_text);
    lives_widget_set_bg_color(lives_bin_get_child(LIVES_BIN(scrolledwindow)), LIVES_WIDGET_STATE_NORMAL, &palette->info_base);
  }

  if (mytext!=NULL) {
    text_view_set_text (LIVES_TEXT_VIEW (textwindow->textview), mytext, -1);
  }

  if (mytext!=NULL||mainw->iochan!=NULL) {
    dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (textwindow->dialog));
    gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

    okbutton = lives_button_new_with_mnemonic (_("_Close Window"));

    GtkWidget *savebutton = lives_button_new_with_mnemonic (_("_Save to file"));
    lives_dialog_add_action_widget (LIVES_DIALOG (textwindow->dialog), savebutton, GTK_RESPONSE_YES);
    lives_dialog_add_action_widget (LIVES_DIALOG (textwindow->dialog), okbutton, GTK_RESPONSE_OK);
    
    g_signal_connect (GTK_OBJECT (savebutton), "clicked",
		      G_CALLBACK (on_save_textview_clicked),
		      textwindow->textview);
    
    g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      G_CALLBACK (lives_general_button_clicked),
		      textwindow);
    
  }

  if (mytitle!=NULL) g_free(mytitle);
  if (mytext!=NULL) g_free(mytext);

  if (prefs->show_gui)
    lives_widget_show_all(textwindow->dialog);

  return textwindow;
}



_insertw* create_insert_dialog (void) {
  GtkWidget *dialog_vbox;
  GtkWidget *hbox1;
  GtkWidget *hbox;
  GtkWidget *table;
  GtkWidget *radiobutton;
  GtkWidget *vseparator;
  GtkWidget *dialog_action_area;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;

  GSList *radiobutton1_group = NULL;
  GSList *radiobutton2_group = NULL;

  GtkAccelGroup *accel_group=GTK_ACCEL_GROUP(lives_accel_group_new ());

  gchar *tmp,*tmp2;

  _insertw *insertw=(_insertw*)(g_malloc(sizeof(_insertw)));

  insertw->insert_dialog = lives_standard_dialog_new (_("LiVES: - Insert"),FALSE);

  lives_window_add_accel_group (LIVES_WINDOW (insertw->insert_dialog), accel_group);

  if (prefs->show_gui) {
    lives_window_set_transient_for(LIVES_WINDOW(insertw->insert_dialog),GTK_WINDOW(mainw->LiVES));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(insertw->insert_dialog));

  hbox1 = lives_hbox_new (FALSE, 0);

  lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox1, TRUE, TRUE, widget_opts.packing_height);

  hbox = lives_hbox_new (FALSE, 0);
  lives_box_pack_start (LIVES_BOX (hbox1), hbox, FALSE, FALSE, widget_opts.packing_width);

  insertw->spinbutton_times = lives_standard_spin_button_new(_("_Number of times to insert"),
							     TRUE,1.,1.,10000.,1.,10.,0.,LIVES_BOX(hbox),NULL);

  add_fill_to_box(LIVES_BOX(hbox1));

  hbox = lives_hbox_new (FALSE, 0);

  lives_box_pack_start (LIVES_BOX (hbox1), hbox, FALSE, FALSE, widget_opts.packing_width);

  insertw->fit_checkbutton = lives_standard_check_button_new (_("_Insert to fit audio"),TRUE,LIVES_BOX(hbox),NULL);

  lives_widget_set_sensitive(LIVES_WIDGET(insertw->fit_checkbutton),cfile->achans>0&&clipboard->achans==0);

  add_hsep_to_box (LIVES_BOX (dialog_vbox));

  table = lives_table_new (2, 3, FALSE);
  lives_box_pack_start (LIVES_BOX (dialog_vbox), table, TRUE, TRUE, widget_opts.packing_height);
  lives_table_set_col_spacings (LIVES_TABLE (table), widget_opts.packing_width*4);
  lives_table_set_row_spacings (LIVES_TABLE (table), widget_opts.packing_height);


  hbox = lives_hbox_new (FALSE, 0);

  radiobutton=lives_standard_radio_button_new((tmp=g_strdup(_ ("Insert _before selection"))),
					      TRUE,radiobutton1_group,LIVES_BOX(hbox),
					      (tmp2=g_strdup(_("Insert clipboard before selected frames"))));

  g_free(tmp); g_free(tmp2);

  radiobutton1_group = lives_radio_button_get_group (LIVES_RADIO_BUTTON (radiobutton));

  lives_table_attach (LIVES_TABLE (table), hbox, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  if (cfile->frames==0) {
    lives_widget_set_sensitive (radiobutton, FALSE);
  }

  hbox = lives_hbox_new (FALSE, 0);

  radiobutton=lives_standard_radio_button_new((tmp=g_strdup(_("Insert _after selection"))),
					      TRUE,radiobutton1_group,LIVES_BOX(hbox),
					      (tmp2=g_strdup(_("Insert clipboard after selected frames"))));

  lives_table_attach (LIVES_TABLE (table), hbox, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(radiobutton),mainw->insert_after);


  hbox = lives_hbox_new (FALSE, 0);

  insertw->with_sound=lives_standard_radio_button_new(_("Insert _with sound"),
						      TRUE,radiobutton2_group,LIVES_BOX(hbox),NULL);
  radiobutton2_group = lives_radio_button_get_group (LIVES_RADIO_BUTTON (insertw->with_sound));


  lives_table_attach (LIVES_TABLE (table), hbox, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  if (cfile->achans==0&&clipboard->achans==0) lives_widget_set_sensitive(insertw->with_sound,FALSE);

  hbox = lives_hbox_new (FALSE, 0);

  insertw->without_sound=lives_standard_radio_button_new(_("Insert with_out sound"),
							 TRUE,radiobutton2_group,LIVES_BOX(hbox),NULL);

  lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(insertw->without_sound),
				 !((cfile->achans>0||clipboard->achans>0)&&mainw->ccpd_with_sound));

  lives_table_attach (LIVES_TABLE (table), hbox, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  lives_widget_set_sensitive (insertw->with_sound, clipboard->achans>0||cfile->achans>0);
  lives_widget_set_sensitive (insertw->without_sound, clipboard->achans>0||cfile->achans>0);

  vseparator = lives_vseparator_new ();
  lives_table_attach (LIVES_TABLE (table), vseparator, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  vseparator = lives_vseparator_new ();
  lives_table_attach (LIVES_TABLE (table), vseparator, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (insertw->insert_dialog));

  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancelbutton = lives_button_new_from_stock ("gtk-cancel");
  lives_dialog_add_action_widget (LIVES_DIALOG (insertw->insert_dialog), cancelbutton, GTK_RESPONSE_CANCEL);

  okbutton = lives_button_new_from_stock ("gtk-ok");
  lives_dialog_add_action_widget (LIVES_DIALOG (insertw->insert_dialog), okbutton, GTK_RESPONSE_OK);
  lives_widget_set_can_focus_and_default (okbutton);
  lives_widget_grab_default(okbutton);
  lives_widget_grab_focus(okbutton);

  g_signal_connect (GTK_OBJECT (insertw->with_sound), "toggled",
		    G_CALLBACK (on_insertwsound_toggled),
		    NULL);
  g_signal_connect (GTK_OBJECT (radiobutton), "toggled",
		    G_CALLBACK (on_boolean_toggled),
		    &mainw->insert_after);
  g_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		    G_CALLBACK (lives_general_button_clicked),
		    insertw);
  g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		    G_CALLBACK (on_insert_activate),
		    NULL);
  g_signal_connect (GTK_OBJECT (insertw->fit_checkbutton), "toggled",
		    G_CALLBACK (on_insfitaudio_toggled),
		    NULL);
  g_signal_connect_after (GTK_OBJECT (insertw->spinbutton_times), "value_changed",
			  G_CALLBACK (on_spin_value_changed),
			  GINT_TO_POINTER (1));

  lives_widget_add_accelerator (cancelbutton, "activate", accel_group,
                              LIVES_KEY_Escape,  (GdkModifierType)0, (GtkAccelFlags)0);

  lives_widget_add_accelerator (okbutton, "activate", accel_group,
                              LIVES_KEY_Return,  (GdkModifierType)0, (GtkAccelFlags)0);

  lives_widget_show_all(insertw->insert_dialog);

  return insertw;
}





GtkWidget *create_opensel_dialog (void) {
  GtkWidget *opensel_dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *vbox;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *spinbutton;
  GtkWidget *dialog_action_area;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;

  opensel_dialog = lives_standard_dialog_new (_("LiVES: - Open Selection"),FALSE);

  if (prefs->show_gui) {
    if (mainw->multitrack==NULL) lives_window_set_transient_for(LIVES_WINDOW(opensel_dialog),GTK_WINDOW(mainw->LiVES));
    else lives_window_set_transient_for(LIVES_WINDOW(opensel_dialog),GTK_WINDOW(mainw->multitrack->window));
  }


  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(opensel_dialog));
 
  vbox = lives_vbox_new (FALSE, 0);
  lives_box_pack_start (LIVES_BOX (dialog_vbox), vbox, TRUE, TRUE, 0);

  table = lives_table_new (2, 2, FALSE);
  lives_box_pack_start (LIVES_BOX (vbox), table, TRUE, TRUE, widget_opts.packing_height);

  lives_table_set_row_spacings (LIVES_TABLE (table), widget_opts.packing_height*2);

  label = lives_standard_label_new (_("Selection start time (sec)"));
  lives_table_attach (LIVES_TABLE (table), label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = lives_standard_label_new (_("Number of frames to open"));
  lives_table_attach (LIVES_TABLE (table), label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  spinbutton = lives_standard_spin_button_new (NULL, FALSE, 0., 0., 1000000000., 1., 10., 2, NULL, NULL);

  g_signal_connect_after (GTK_OBJECT (spinbutton), "value_changed",
                            G_CALLBACK (on_spin_value_changed),
                            GINT_TO_POINTER (1));

  lives_table_attach (LIVES_TABLE (table), spinbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), widget_opts.packing_height*4+2, 0);


  spinbutton = lives_standard_spin_button_new (NULL,FALSE,1000.,1.,(double)G_MAXINT, 1., 10., 0, NULL, NULL);

  g_signal_connect_after (GTK_OBJECT (spinbutton), "value_changed",
			  G_CALLBACK (on_spin_value_changed),
			  GINT_TO_POINTER (2));

  lives_table_attach (LIVES_TABLE (table), spinbutton, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), widget_opts.packing_height*4+2, 0);

  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (opensel_dialog));
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancelbutton = lives_button_new_from_stock ("gtk-cancel");
  lives_dialog_add_action_widget (LIVES_DIALOG (opensel_dialog), cancelbutton, GTK_RESPONSE_CANCEL);

  okbutton = lives_button_new_from_stock ("gtk-ok");
  lives_dialog_add_action_widget (LIVES_DIALOG (opensel_dialog), okbutton, GTK_RESPONSE_OK);
  lives_widget_set_can_focus_and_default (okbutton);
  lives_widget_grab_default(okbutton);

  widget_add_preview (opensel_dialog, LIVES_BOX (dialog_vbox), GTK_BOX (dialog_vbox), GTK_BOX(dialog_vbox), 3);

  g_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		    G_CALLBACK (on_cancel_opensel_clicked),
		    NULL);
  g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		    G_CALLBACK (on_opensel_range_ok_clicked),
		    NULL);

  lives_widget_show_all(opensel_dialog);

  return opensel_dialog;
}





_entryw* create_location_dialog (int type) {
  // type 1 is open location
  // type 2 is open youtube: - 3 fields:= URL, directory, file name

  GtkWidget *dialog_vbox;
  GtkWidget *dialog_action_area;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;
  GtkWidget *label;
  GtkWidget *checkbutton;
  GtkWidget *hbox;
  GtkWidget *buttond;

  _entryw *locw=(_entryw*)(g_malloc(sizeof(_entryw)));

  GtkAccelGroup *accel_group=GTK_ACCEL_GROUP(lives_accel_group_new ());

  gchar *title,*tmp,*tmp2;

  if (type==1) 
    title=g_strdup(_("LiVES: - Open Location"));
  else 
    title=g_strdup(_("LiVES: - Open Youtube Clip"));

  locw->dialog = lives_standard_dialog_new (title,FALSE);

  g_free(title);

  lives_window_add_accel_group (LIVES_WINDOW (locw->dialog), accel_group);

  if (prefs->show_gui) {
    if (mainw->multitrack==NULL) lives_window_set_transient_for(LIVES_WINDOW(locw->dialog),GTK_WINDOW(mainw->LiVES));
    else lives_window_set_transient_for(LIVES_WINDOW(locw->dialog),GTK_WINDOW(mainw->multitrack->window));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(locw->dialog));

  widget_opts.justify=LIVES_JUSTIFY_CENTER;

  if (type==1) {
    label = lives_standard_label_new (_("\n\nTo open a stream, you must make sure that you have the correct libraries compiled in mplayer.\nAlso make sure you have set your bandwidth in Preferences|Streaming\n\n"));
  }
  else { 
    label = lives_standard_label_new (_("\n\nTo open a clip from Youtube, LiVES will first download it with youtube-dl.\nPlease make sure you have the latest version of that tool installed.\n\n"));

    lives_box_pack_start (LIVES_BOX (dialog_vbox), label, FALSE, FALSE, 0);
    
    label=lives_standard_label_new(_("Enter the URL of the clip below.\nE.g: http://www.youtube.com/watch?v=WCR6f6WzjP8\n\n"));

  }

  widget_opts.justify=LIVES_JUSTIFY_DEFAULT;

  lives_box_pack_start (LIVES_BOX (dialog_vbox), label, FALSE, FALSE, 0);

  hbox = lives_hbox_new (FALSE, 0);
  lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, TRUE, widget_opts.packing_height*2);

  locw->entry = lives_standard_entry_new (type==1?_ ("URL : "):_ ("Youtube URL : "),FALSE,"",79,32768,LIVES_BOX(hbox),NULL);

  if (type==1) {
    hbox=lives_hbox_new (FALSE, 0);
    checkbutton = lives_standard_check_button_new ((tmp=g_strdup(_("Do not send bandwidth information"))),
						   TRUE,LIVES_BOX(hbox),
						   (tmp2=g_strdup(_("Try this setting if you are having problems getting a stream"))));

    g_free(tmp); g_free(tmp2);

    lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(checkbutton),prefs->no_bandwidth);
    
    lives_box_pack_start (LIVES_BOX(dialog_vbox), hbox, FALSE, FALSE, widget_opts.packing_height*2);
    
    g_signal_connect (GTK_OBJECT (checkbutton), "toggled",
		      G_CALLBACK (on_boolean_toggled),
		      &prefs->no_bandwidth);
    
    add_deinterlace_checkbox(LIVES_BOX(dialog_vbox));

  }

  if (type==2) {
    hbox=lives_hbox_new (FALSE, 0);
    
    lives_box_pack_start(LIVES_BOX(dialog_vbox),hbox,TRUE,FALSE,widget_opts.packing_height);

    locw->dir_entry = lives_standard_entry_new (_("Download to _Directory : "),TRUE,mainw->vid_dl_dir,
						72.*widget_opts.scale,PATH_MAX,LIVES_BOX(hbox),NULL);

    lives_entry_set_editable(LIVES_ENTRY(locw->dir_entry),FALSE);
    gtk_entry_set_max_length(LIVES_ENTRY (locw->dir_entry),PATH_MAX);

    // add dir, with filechooser button
    buttond = lives_standard_file_button_new (TRUE,NULL);
    gtk_label_set_mnemonic_widget (LIVES_LABEL(widget_opts.last_label),buttond);
    lives_box_pack_start(LIVES_BOX(hbox),buttond,FALSE,FALSE,widget_opts.packing_width);


    add_fill_to_box (LIVES_BOX (hbox));

    hbox=lives_hbox_new (FALSE, 0);
    
    lives_box_pack_start(LIVES_BOX(dialog_vbox),hbox,TRUE,FALSE,widget_opts.packing_height);

    locw->name_entry = lives_standard_entry_new (_("Download _File Name : "),TRUE,"",
						 74.*widget_opts.scale,PATH_MAX,LIVES_BOX(hbox),NULL);

    g_signal_connect(buttond, "clicked", G_CALLBACK (on_filesel_button_clicked), (gpointer)locw->dir_entry);

    label=lives_standard_label_new (_(".webm"));

    lives_box_pack_start(LIVES_BOX(hbox),label,FALSE,FALSE,widget_opts.packing_width);
   }



  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (locw->dialog));
  lives_widget_show (dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancelbutton = lives_button_new_from_stock ("gtk-cancel");
  lives_widget_show (cancelbutton);
  lives_dialog_add_action_widget (LIVES_DIALOG (locw->dialog), cancelbutton, GTK_RESPONSE_CANCEL);
  lives_widget_set_can_focus_and_default (cancelbutton);

  okbutton = lives_button_new_from_stock ("gtk-ok");
  lives_widget_show (okbutton);
  lives_dialog_add_action_widget (LIVES_DIALOG (locw->dialog), okbutton, GTK_RESPONSE_OK);
  lives_widget_set_can_focus_and_default (okbutton);
  lives_widget_grab_default (okbutton);


  g_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		    G_CALLBACK (lives_general_button_clicked),
		    locw);

  if (type==1) 
    g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      G_CALLBACK (on_location_select),
		      NULL);

  else if (type==2) 
    g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      G_CALLBACK (on_utube_select),
		      NULL);


  lives_widget_add_accelerator (cancelbutton, "activate", accel_group,
                              LIVES_KEY_Escape, (GdkModifierType)0, (GtkAccelFlags)0);

  lives_widget_show_all(locw->dialog);

  return locw;
}

#define RW_ENTRY_DISPWIDTH 40

_entryw* create_rename_dialog (int type) {
  // type 1 = rename clip in menu
  // type 2 = save clip set
  // type 3 = reload clip set
  // type 4 = save clip set from mt
  // type 5 = save clip set for project export

  // type 6 = initial tempdir

  // type 7 = rename track in mt

  GtkWidget *dialog_vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *dialog_action_area;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;
  GtkWidget *set_combo;
  GtkWidget *dirbutton1;
  GtkWidget *dirimage1;

  GtkAccelGroup *accel_group=GTK_ACCEL_GROUP(lives_accel_group_new ());

  gchar *title=NULL;

  _entryw *renamew=(_entryw*)(g_malloc(sizeof(_entryw)));

  renamew->setlist=NULL;

  if (type==1) {
    title=g_strdup(_("LiVES: - Rename Clip"));
  }
  else if (type==2||type==4||type==5) {
    title=g_strdup(_("LiVES: - Enter Set Name"));
  }
  else if (type==3) {
    title=g_strdup(_("LiVES: - Enter a Set Name to Reload"));
  }
  else if (type==6) {
    title=g_strdup(_("LiVES: - Choose a Working Directory"));
  }
  else if (type==7) {
    title=g_strdup(_("LiVES: - Rename Current Track"));
  }

  renamew->dialog = lives_standard_dialog_new (title,FALSE);

  lives_window_add_accel_group (LIVES_WINDOW (renamew->dialog), accel_group);

  if (prefs->show_gui) {
    if (mainw->multitrack==NULL) {
      if (mainw->is_ready) {
	lives_window_set_transient_for(LIVES_WINDOW(renamew->dialog),GTK_WINDOW(mainw->LiVES));
      }
    }
    else lives_window_set_transient_for(LIVES_WINDOW(renamew->dialog),GTK_WINDOW(mainw->multitrack->window));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(renamew->dialog));

  if (type==4) {
    label = lives_standard_label_new 
      (_("You need to enter a name for the current clip set.\nThis will allow you reload the layout with the same clips later.\nPlease enter the set name you wish to use.\nLiVES will remind you to save the clip set later when you try to exit.\n"));
    lives_box_pack_start (LIVES_BOX (dialog_vbox), label, FALSE, FALSE, 0);
  }

  if (type==5) {
    label = lives_standard_label_new 
      (_("In order to export this project, you must enter a name for this clip set.\nThis will also be used for the project name.\n"));
    lives_box_pack_start (LIVES_BOX (dialog_vbox), label, FALSE, FALSE, 0);
  }


  if (type==6) {
    label = lives_standard_label_new 
      (_("Welcome to LiVES !\nThis startup wizard will guide you through the\ninitial install so that you can get the most from this application.\n"));
    lives_box_pack_start (LIVES_BOX (dialog_vbox), label, FALSE, FALSE, 0);

    label = lives_standard_label_new 
      (_("\nFirst of all you need to choose a working directory for LiVES.\nThis should be a directory with plenty of disk space available.\n"));
    lives_box_pack_start (LIVES_BOX (dialog_vbox), label, FALSE, FALSE, 0);
  }


  hbox = lives_hbox_new (FALSE, 0);

  if (type==3) {
    lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, FALSE, widget_opts.packing_height*4);
  }
  else if (type!=6&&type!=7&&type!=1) {
    lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, TRUE, widget_opts.packing_height*2);
  }
  else {
    lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, TRUE, widget_opts.packing_height*4);
  }


  if (type==1||type==7) {
    label = lives_standard_label_new (_("New name "));
  }
  else if (type==2||type==3||type==4||type==5) {
    label = lives_standard_label_new (_("Set name "));
  }
  else {
    label = lives_standard_label_new ("");
  }

  lives_box_pack_start (LIVES_BOX (hbox), label, FALSE, FALSE, widget_opts.packing_width*4);


  if (type==3) {
    GtkListStore *store;
    GtkEntryCompletion *completion;
    GList *xlist;

    set_combo=lives_combo_new();

    renamew->setlist=get_set_list(prefs->tmpdir);

    lives_combo_populate(LIVES_COMBO(set_combo),renamew->setlist);

    renamew->entry=lives_combo_get_entry(LIVES_COMBO(set_combo));

    if (strlen(prefs->ar_clipset_name)) {
      // set default to our auto-reload clipset
      lives_entry_set_text(LIVES_ENTRY(renamew->entry),prefs->ar_clipset_name);
    }

    lives_box_pack_start (LIVES_BOX (hbox), set_combo, TRUE, TRUE, 0);

    xlist=renamew->setlist;
    store = gtk_list_store_new (1, G_TYPE_STRING);

    while (xlist != NULL) {
      GtkTreeIter iter;
      gtk_list_store_append (store, &iter);
      gtk_list_store_set (store, &iter, 0, (gchar *)xlist->data, -1);
      xlist=xlist->next;
    }
    
    completion = gtk_entry_completion_new ();
    gtk_entry_completion_set_model (completion, (GtkTreeModel *)store);
    gtk_entry_completion_set_text_column (completion, 0);
    gtk_entry_completion_set_inline_completion (completion, TRUE);
    gtk_entry_completion_set_popup_set_width (completion, TRUE);
    gtk_entry_completion_set_popup_completion (completion, TRUE);
    gtk_entry_completion_set_popup_single_match(completion,FALSE);
    gtk_entry_set_completion (LIVES_ENTRY (renamew->entry), completion);


  }
  else {
    renamew->entry = gtk_entry_new();
    gtk_entry_set_max_length (LIVES_ENTRY(renamew->entry),type==6?PATH_MAX:type==7?16:128);
    if (type==2&&strlen (mainw->set_name)) {
      lives_entry_set_text (LIVES_ENTRY (renamew->entry),mainw->set_name);
    }
    if (type==6) {
      gchar *tmpdir;
      if (prefs->startup_phase==-1) tmpdir=g_build_filename(capable->home_dir,LIVES_TMP_NAME,NULL);
      else tmpdir=g_strdup(prefs->tmpdir);
      lives_entry_set_text (LIVES_ENTRY (renamew->entry),tmpdir);
      g_free(tmpdir);
    }
    lives_box_pack_start (LIVES_BOX (hbox), renamew->entry, TRUE, TRUE, 0);
  }


  if (type==6) {
    dirbutton1 = gtk_button_new ();
    
    dirimage1 = lives_image_new_from_stock (LIVES_STOCK_OPEN, LIVES_ICON_SIZE_BUTTON);

    lives_container_add (LIVES_CONTAINER (dirbutton1), dirimage1);

    lives_box_pack_start (LIVES_BOX (hbox), dirbutton1, FALSE, TRUE, widget_opts.packing_width);
    g_signal_connect(dirbutton1, "clicked", G_CALLBACK (on_filesel_complex_clicked),renamew->entry);

  }


  gtk_entry_set_activates_default (LIVES_ENTRY (renamew->entry), TRUE);
  lives_entry_set_width_chars (LIVES_ENTRY (renamew->entry),RW_ENTRY_DISPWIDTH);

  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (renamew->dialog));

  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancelbutton = lives_button_new_from_stock ("gtk-cancel");

  lives_dialog_add_action_widget (LIVES_DIALOG (renamew->dialog), cancelbutton, GTK_RESPONSE_CANCEL);
  lives_widget_set_can_focus_and_default (cancelbutton);

  lives_widget_add_accelerator (cancelbutton, "activate", accel_group,
			      LIVES_KEY_Escape, (GdkModifierType)0, (GtkAccelFlags)0);

  if (type==6) {
    okbutton = lives_button_new_from_stock ("gtk-go-forward");
    lives_button_set_label(GTK_BUTTON(okbutton),_("_Next"));
  }
  else okbutton = lives_button_new_from_stock ("gtk-ok");

  lives_dialog_add_action_widget (LIVES_DIALOG (renamew->dialog), okbutton, GTK_RESPONSE_OK);
  lives_widget_set_can_focus_and_default (okbutton);
  lives_widget_grab_default (okbutton);

  if (type!=4&&type!=2&&type!=5) {
    g_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      G_CALLBACK (lives_general_button_clicked),
		      renamew);
  }

  if (type==1) {
    g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      G_CALLBACK (on_rename_set_name),
		      NULL);
  }
  else if (type==3) {
    g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      G_CALLBACK (on_load_set_ok),
		      GINT_TO_POINTER(FALSE));
  }


  lives_widget_add_accelerator (cancelbutton, "activate", accel_group,
                              LIVES_KEY_Escape, (GdkModifierType)0, (GtkAccelFlags)0);

  lives_widget_show_all(renamew->dialog);

  lives_widget_grab_focus (renamew->entry);

  return renamew;
}


void on_liveinp_advanced_clicked (GtkButton *button, gpointer user_data) {
  lives_tvcardw_t *tvcardw=(lives_tvcardw_t *)(user_data);

  tvcardw->use_advanced=!tvcardw->use_advanced;

  if (tvcardw->use_advanced) {
    lives_widget_show(tvcardw->adv_vbox);
    lives_button_set_label(GTK_BUTTON(tvcardw->advbutton),_("Use def_aults"));
  }
  else {
    lives_button_set_label(GTK_BUTTON(tvcardw->advbutton),_("_Advanced"));
    lives_window_resize(LIVES_WINDOW(lives_widget_get_toplevel(tvcardw->adv_vbox)),4,40);
    lives_widget_hide(tvcardw->adv_vbox);
  }

  lives_widget_queue_resize(lives_widget_get_parent(tvcardw->adv_vbox));

}


static void rb_tvcarddef_toggled(GtkToggleButton *tbut, gpointer user_data) {
  lives_tvcardw_t *tvcardw=(lives_tvcardw_t *)(user_data);

  if (!lives_toggle_button_get_active(tbut)) {
    lives_widget_set_sensitive(tvcardw->spinbuttonw,TRUE);
    lives_widget_set_sensitive(tvcardw->spinbuttonh,TRUE);
    lives_widget_set_sensitive(tvcardw->spinbuttonf,TRUE);
  }
  else {
    lives_widget_set_sensitive(tvcardw->spinbuttonw,FALSE);
    lives_widget_set_sensitive(tvcardw->spinbuttonh,FALSE);
    lives_widget_set_sensitive(tvcardw->spinbuttonf,FALSE);
  }


}


static void after_dialog_combo_changed (GtkWidget *combo, gpointer user_data) {
  GList *list=(GList *)user_data;
  gchar *etext=lives_combo_get_active_text(LIVES_COMBO(combo));
  mainw->fx1_val=lives_list_index(list,etext);
  g_free(etext);
}


GtkWidget *create_combo_dialog (int type, gpointer user_data) {
  // create a dialog with combo box selector

  // type 1 == 1 combo box

  GtkWidget *combo_dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *label;
  GtkWidget *combo;

  gchar *label_text=NULL,*title=NULL;

  GList *list=(GList *)user_data;

  if (type==1) {
    title=g_strdup(_("LiVES:- Select input device"));
  }

  combo_dialog = lives_standard_dialog_new (title,TRUE);
  if (title!=NULL) g_free(title);

  if (prefs->show_gui) {
    if (type==1) {
      lives_window_set_transient_for(LIVES_WINDOW(combo_dialog),GTK_WINDOW(mainw->LiVES));
    }
    else {
      lives_window_set_transient_for(LIVES_WINDOW(combo_dialog),GTK_WINDOW(mainw->multitrack->window));
    }
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(combo_dialog));

  if (type==1) {
    label_text=g_strdup(_("Select input device:"));
  }

  label = lives_standard_label_new (label_text);
  if (label_text!=NULL) g_free(label_text);

  lives_box_pack_start (LIVES_BOX (dialog_vbox), label, TRUE, TRUE, 0);

  combo = lives_combo_new();

  lives_entry_set_width_chars (LIVES_ENTRY (lives_combo_get_entry(LIVES_COMBO(combo))), 64);

  lives_combo_populate(LIVES_COMBO(combo),list);

  lives_combo_set_active_index(LIVES_COMBO(combo), 0);

  g_signal_connect_after (G_OBJECT (combo), "changed", G_CALLBACK (after_dialog_combo_changed), list);

  lives_box_pack_start (LIVES_BOX (dialog_vbox), combo, TRUE, TRUE, widget_opts.packing_height*2);

  if (type==1) {
    add_deinterlace_checkbox(LIVES_BOX(dialog_vbox));
  }

  if (prefs->show_gui)
    lives_widget_show_all(combo_dialog);

  return combo_dialog;
}


GtkWidget* create_cdtrack_dialog (int type, gpointer user_data) {
  // general purpose dialog with label and up to 2 spinbuttons

  // type 0 = cd track
  // type 1 = dvd title/chapter/aid
  // type 2 = vcd title -- do we need chapter as well ?
  // type 3 = number of tracks in mt


  // type 4 = TV card (device and channel)
  // type 5 = fw card

  // TODO - add pref for dvd/vcd device

  // TODO - for CD make this nicer - get track names
  lives_tvcardw_t *tvcardw=NULL;

  GtkWidget *cd_dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *hbox;
  GtkWidget *spinbutton;
  GtkWidget *dialog_action_area;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;

  GtkAccelGroup *accel_group=GTK_ACCEL_GROUP(lives_accel_group_new ());
  
  GSList *radiobutton_group=NULL;

  gchar *label_text=NULL,*title;
 

  if (type==0) {
    title=g_strdup(_("LiVES:- Load CD Track"));
  }
  else if (type==1) {
    title=g_strdup(_("LiVES:- Select DVD Title/Chapter"));
  }
  else if (type==2) {
    title=g_strdup(_("LiVES:- Select VCD Title"));
  }
  else if (type==3) {
    title=g_strdup(_("LiVES:- Change Maximum Visible Tracks"));
  }
  else {
    title=g_strdup(_("LiVES:- Device details"));
  }

  cd_dialog = lives_standard_dialog_new (title,FALSE);
  g_free(title);

  //lives_window_set_default_size (LIVES_WINDOW (cd_dialog), 300, 240);

  if (prefs->show_gui) {
    if (type==0||type==1||type==2||type==4||type==5) {
      lives_window_set_transient_for(LIVES_WINDOW(cd_dialog),GTK_WINDOW(mainw->LiVES));
    }
    else {
      lives_window_set_transient_for(LIVES_WINDOW(cd_dialog),GTK_WINDOW(mainw->multitrack->window));
    }
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(cd_dialog));

  hbox = lives_hbox_new (FALSE, widget_opts.packing_width*5);
  lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, TRUE, widget_opts.packing_height);

  if (type==0) {
    label_text=g_strdup_printf(_("Track to load (from %s)"),prefs->cdplay_device);
  }
  else if (type==1) {
    label_text=g_strdup(_("DVD Title"));
  }
  else if (type==2) {
    label_text=g_strdup(_("VCD Title"));
  }
  else if (type==3) {
    label_text=g_strdup(_("Maximum number of tracks to display"));
  }
  else if (type==4) {
    label_text=g_strdup(_("Device:        /dev/video"));
  }
  else if (type==5) {
    label_text=g_strdup(_("Device:        fw:"));
  }


  if (type==0||type==1||type==2) {
    spinbutton = lives_standard_spin_button_new (label_text,FALSE, mainw->fx1_val,
						 1., 256., 1., 10., 0,
						 LIVES_BOX(hbox),NULL);
  }
  else if (type==3) {
    spinbutton = lives_standard_spin_button_new (label_text,FALSE, mainw->fx1_val,
						 4., 8., 1., 1.,0,
						 LIVES_BOX(hbox),NULL);
  }
  else {
    spinbutton = lives_standard_spin_button_new (label_text,FALSE, 0.,
						 0., 31., 1., 1., 0, 
						 LIVES_BOX(hbox),NULL);
  }

  g_free(label_text);

  g_signal_connect_after (GTK_OBJECT (spinbutton), "value_changed",
			  G_CALLBACK (on_spin_value_changed),
			  GINT_TO_POINTER (1));


  add_fill_to_box(LIVES_BOX(hbox));

  if (type==1||type==4) {

    hbox = lives_hbox_new (FALSE, widget_opts.packing_width*5);
    lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, TRUE, widget_opts.packing_height);

    if (type==1) {
      spinbutton = lives_standard_spin_button_new (_("Chapter  "), FALSE, mainw->fx2_val,
						   1., 1024., 1., 10., 0, 
						   LIVES_BOX(hbox),NULL);
    }
    else {
      spinbutton = lives_standard_spin_button_new (_("Channel  "), FALSE, 1.,
						   1., 69., 1., 1., 0, 
						   LIVES_BOX(hbox),NULL);

    }

    g_signal_connect_after (GTK_OBJECT (spinbutton), "value_changed",
			    G_CALLBACK (on_spin_value_changed),
			    GINT_TO_POINTER (2));


    if (type==1) {
      hbox = lives_hbox_new (FALSE, widget_opts.packing_width*5);
      lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, TRUE, widget_opts.packing_height);
      
      spinbutton = lives_standard_spin_button_new (_("Audio ID  "), FALSE, mainw->fx3_val,
						   128., 159., 1., 1., 0, 
						   LIVES_BOX(hbox),NULL);

      g_signal_connect_after (GTK_OBJECT (spinbutton), "value_changed",
			      G_CALLBACK (on_spin_value_changed),
			      GINT_TO_POINTER (3));

    }
  }

  if (type==4||type==5) {
    hbox=add_deinterlace_checkbox(LIVES_BOX(dialog_vbox));
    add_fill_to_box(LIVES_BOX(hbox));
  }


  if (type==4) {
    GList *dlist=NULL;
    GList *olist=NULL;

    tvcardw=(lives_tvcardw_t *)g_malloc(sizeof(lives_tvcardw_t));
    tvcardw->use_advanced=FALSE;

    dlist=g_list_append(dlist,(gpointer)"autodetect");
    dlist=g_list_append(dlist,(gpointer)"v4l2");
    dlist=g_list_append(dlist,(gpointer)"v4l");
    dlist=g_list_append(dlist,(gpointer)"bsdbt848");
    dlist=g_list_append(dlist,(gpointer)"dummy");

    olist=g_list_append(olist,(gpointer)"autodetect");
    olist=g_list_append(olist,(gpointer)"yv12");
    olist=g_list_append(olist,(gpointer)"rgb32");
    olist=g_list_append(olist,(gpointer)"rgb24");
    olist=g_list_append(olist,(gpointer)"rgb16");
    olist=g_list_append(olist,(gpointer)"rgb15");
    olist=g_list_append(olist,(gpointer)"uyvy");
    olist=g_list_append(olist,(gpointer)"yuy2");
    olist=g_list_append(olist,(gpointer)"i420");


    lives_box_set_spacing(LIVES_BOX(dialog_vbox),widget_opts.packing_height*2);

    hbox = lives_hbox_new (FALSE, widget_opts.packing_width*5);

    lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, FALSE, FALSE, widget_opts.packing_height*2);
    
    add_fill_to_box(LIVES_BOX(hbox));

    tvcardw->advbutton = lives_button_new_with_mnemonic (_("_Advanced"));

    lives_box_pack_start (LIVES_BOX (hbox), tvcardw->advbutton, TRUE, TRUE, widget_opts.packing_width*4);
    
    add_fill_to_box(LIVES_BOX(hbox));


    tvcardw->adv_vbox = lives_vbox_new (FALSE, widget_opts.packing_width*5);
    lives_box_pack_start (LIVES_BOX (dialog_vbox), tvcardw->adv_vbox, TRUE, TRUE, widget_opts.packing_height*2);
    

    // add input, width, height, fps, driver and outfmt


    hbox = lives_hbox_new (FALSE, 0);
    lives_box_pack_start (LIVES_BOX (tvcardw->adv_vbox), hbox, TRUE, FALSE, 0);

    tvcardw->spinbuttoni = lives_standard_spin_button_new (_("Input number"),FALSE,
							   0.,0.,16.,1.,1.,0,
							   LIVES_BOX(hbox),NULL);
							   

    hbox = lives_hbox_new (FALSE, 0);
    lives_box_pack_start (LIVES_BOX (tvcardw->adv_vbox), hbox, TRUE, FALSE, 0);

    tvcardw->radiobuttond = lives_standard_radio_button_new (_("Use default width, height and FPS"),FALSE,
							     radiobutton_group,LIVES_BOX(hbox),NULL);
    radiobutton_group = lives_radio_button_get_group (LIVES_RADIO_BUTTON (tvcardw->radiobuttond));
    
    g_signal_connect_after (GTK_OBJECT (tvcardw->radiobuttond), "toggled",
			    G_CALLBACK (rb_tvcarddef_toggled),
			    (gpointer)tvcardw);

    hbox = lives_hbox_new (FALSE, 0);
    lives_box_pack_start (LIVES_BOX (tvcardw->adv_vbox), hbox, TRUE, FALSE, 0);

    lives_standard_radio_button_new (NULL,FALSE,
				     radiobutton_group,LIVES_BOX(hbox),NULL);
    
    tvcardw->spinbuttonw = lives_standard_spin_button_new (_("Width"),FALSE,
							   640.,4.,4096.,2.,2.,0,
							   LIVES_BOX(hbox),NULL);

    lives_widget_set_sensitive(tvcardw->spinbuttonw,FALSE);

    tvcardw->spinbuttonh = lives_standard_spin_button_new (_("Height"),FALSE,
							   480.,4.,4096.,2.,2.,0,
							   LIVES_BOX(hbox),NULL);

    lives_widget_set_sensitive(tvcardw->spinbuttonh,FALSE);
    
    tvcardw->spinbuttonf = lives_standard_spin_button_new (_("FPS"),FALSE,
							   25., 1., FPS_MAX, 1., 10., 3,
							   LIVES_BOX(hbox),NULL);

    lives_widget_set_sensitive(tvcardw->spinbuttonf,FALSE);

    hbox = lives_hbox_new (FALSE, 0);

    tvcardw->combod = lives_standard_combo_new (_("_Driver"),TRUE,dlist,LIVES_BOX(hbox),NULL);
    lives_combo_set_active_index(LIVES_COMBO(tvcardw->combod), 0);

    tvcardw->comboo = lives_standard_combo_new (_("_Output format"),TRUE,olist,LIVES_BOX(hbox),NULL);


    lives_widget_show_all (hbox);
    lives_box_pack_start (LIVES_BOX (tvcardw->adv_vbox), hbox, TRUE, FALSE, 0);

    g_signal_connect (GTK_OBJECT (tvcardw->advbutton), "clicked",
		      G_CALLBACK (on_liveinp_advanced_clicked),
		      tvcardw);

    lives_widget_hide(tvcardw->adv_vbox);

    g_object_set_data(G_OBJECT(cd_dialog),"tvcard_data",tvcardw);

  }

  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (cd_dialog));
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancelbutton = lives_button_new_from_stock ("gtk-cancel");
  lives_dialog_add_action_widget (LIVES_DIALOG (cd_dialog), cancelbutton, GTK_RESPONSE_CANCEL);

  okbutton = lives_button_new_from_stock ("gtk-ok");
  lives_dialog_add_action_widget (LIVES_DIALOG (cd_dialog), okbutton, GTK_RESPONSE_OK);
  lives_widget_set_can_focus_and_default (okbutton);

  lives_widget_grab_default (okbutton);

  lives_widget_add_accelerator (cancelbutton, "activate", accel_group,
                              LIVES_KEY_Escape, (GdkModifierType)0, (GtkAccelFlags)0);

  
  lives_widget_add_accelerator (okbutton, "activate", accel_group,
                              LIVES_KEY_Return, (GdkModifierType)0, (GtkAccelFlags)0);

  if (type!=4&&type!=5) {
    g_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      G_CALLBACK (lives_general_button_clicked),
		      NULL);
  }

  if (type==0) {
    g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      G_CALLBACK (on_load_cdtrack_ok_clicked),
		      NULL);
  }
  else if (type==1||type==2)  {
    g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      G_CALLBACK (on_load_vcd_ok_clicked),
		      GINT_TO_POINTER (type));
  }
  else if (type==3)  {
    g_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      G_CALLBACK (mt_change_disp_tracks_ok),
		      user_data);
  }

  lives_window_add_accel_group (LIVES_WINDOW (cd_dialog), accel_group);

  lives_widget_show_all(cd_dialog);

  if (type==4) lives_widget_hide(tvcardw->adv_vbox);

  return cd_dialog;
}



static void rb_aud_sel_pressed (GtkButton *button, gpointer user_data) {
  aud_dialog_t *audd=(aud_dialog_t *)user_data;
  audd->is_sel=!audd->is_sel;
  lives_widget_set_sensitive(audd->time_spin,!audd->is_sel);
}




aud_dialog_t *create_audfade_dialog (int type) {
  // type 0 = fade in
  // type 1 = fade out

  GtkWidget *dialog_vbox;
  GtkWidget *hbox;
  GtkWidget *rb_time;
  GtkWidget *rb_sel;
  GtkWidget *label;

  gchar *label_text=NULL,*label_text2=NULL,*title;

  double max;

  GSList *radiobutton_group = NULL;

  aud_dialog_t *audd=(aud_dialog_t *)g_malloc(sizeof(aud_dialog_t));

  if (type==0) {
    title=g_strdup(_("LiVES:- Fade Audio In"));
  }
  else {
    title=g_strdup(_("LiVES:- Fade Audio Out"));
  }

  audd->dialog = lives_standard_dialog_new (title,TRUE);
  g_free(title);

  if (prefs->show_gui) {
    lives_window_set_transient_for(LIVES_WINDOW(audd->dialog),GTK_WINDOW(mainw->LiVES));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(audd->dialog));

  hbox = lives_hbox_new (FALSE, TB_HEIGHT_AUD);
  lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, TRUE, widget_opts.packing_height);

  if (type==0) {
    label_text=g_strdup(_("Fade in over  "));
    label_text2=g_strdup(_("first"));
  }
  else if (type==1) {
    label_text=g_strdup(_("Fade out over  "));
    label_text2=g_strdup(_("last"));
  }


  label = lives_standard_label_new (label_text);
  if (label_text!=NULL) g_free(label_text);

  lives_box_pack_start (LIVES_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = lives_hbox_new (FALSE, widget_opts.packing_width*5);
  lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, TRUE, widget_opts.packing_height);

  rb_time=lives_standard_radio_button_new(label_text2,FALSE,radiobutton_group,
					  LIVES_BOX(hbox),NULL);

  radiobutton_group = lives_radio_button_get_group (LIVES_RADIO_BUTTON (rb_time));
  if (label_text2!=NULL) g_free(label_text2);


  max=cfile->laudio_time;

  widget_opts.swap_label=TRUE;
  audd->time_spin = lives_standard_spin_button_new (_("seconds."),FALSE,
						    max/2.>DEF_AUD_FADE_SECS?DEF_AUD_FADE_SECS:max/2., .1, max, 1., 10., 2,
						    LIVES_BOX(hbox),NULL);
  widget_opts.swap_label=FALSE;

  hbox = lives_hbox_new (FALSE, widget_opts.packing_width*5);
  lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, TRUE, TRUE, widget_opts.packing_height);

  rb_sel=lives_standard_radio_button_new(_("selection"),FALSE,radiobutton_group,LIVES_BOX(hbox),NULL);

  audd->is_sel=FALSE;

  if ((cfile->end-1.)/cfile->fps>cfile->laudio_time) {
    // if selection is longer than audio time, we cannot use sel len
    lives_widget_set_sensitive(rb_sel,FALSE);
  }
  else {
    lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(rb_sel),TRUE);
    rb_aud_sel_pressed(GTK_BUTTON(rb_sel),(gpointer)audd);
  }

  g_signal_connect_after (GTK_OBJECT (rb_sel), "toggled",
			  G_CALLBACK (rb_aud_sel_pressed),
			  (gpointer)audd);


  add_fill_to_box(LIVES_BOX(hbox));


  lives_widget_show_all(audd->dialog);
  
  return audd;
}





_commentsw* create_comments_dialog (lives_clip_t *sfile, gchar *filename) {
  GtkWidget *dialog_vbox;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *buttond;

  _commentsw *commentsw=(_commentsw*)(g_malloc(sizeof(_commentsw)));

  commentsw->comments_dialog = lives_standard_dialog_new (_("LiVES: - File Comments (optional)"),TRUE);

  if (prefs->show_gui) {
    lives_window_set_transient_for(LIVES_WINDOW(commentsw->comments_dialog),GTK_WINDOW(mainw->LiVES));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(commentsw->comments_dialog));

  table = lives_table_new (4, 2, FALSE);
  lives_container_set_border_width(LIVES_CONTAINER(table), widget_opts.border_width);

  lives_table_set_row_spacings(LIVES_TABLE(table), widget_opts.packing_height*2);

  lives_box_pack_start (LIVES_BOX (dialog_vbox), table, TRUE, TRUE, widget_opts.packing_height);

  label = lives_standard_label_new (_("Title/Name : "));

  lives_table_attach (LIVES_TABLE (table), label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = lives_standard_label_new (_("Author/Artist : "));

  lives_table_attach (LIVES_TABLE (table), label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = lives_standard_label_new (_("Comments : "));

  lives_table_attach (LIVES_TABLE (table), label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  commentsw->title_entry = lives_standard_entry_new (NULL,FALSE,cfile->title,80,-1,NULL,NULL);

  lives_table_attach (LIVES_TABLE (table), commentsw->title_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), 0, 0);

  commentsw->author_entry = lives_standard_entry_new (NULL,FALSE,cfile->author,80,-1,NULL,NULL);

  lives_table_attach (LIVES_TABLE (table), commentsw->author_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), 0, 0);

  commentsw->comment_entry = lives_standard_entry_new (NULL,FALSE,cfile->comment,80,250,NULL,NULL);

  lives_table_attach (LIVES_TABLE (table), commentsw->comment_entry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), 0, 0);

  if (sfile!=NULL) {
    // options
    vbox = lives_vbox_new (FALSE, 0);

    lives_standard_expander_new(_("_Options"),TRUE,LIVES_BOX(dialog_vbox),vbox);

    add_fill_to_box(LIVES_BOX(vbox));

    hbox = lives_hbox_new (FALSE, 0);
    lives_box_pack_start (LIVES_BOX (vbox), hbox, FALSE, FALSE, widget_opts.packing_height);

    commentsw->subt_checkbutton = lives_standard_check_button_new (_("Save _subtitles to file"),TRUE,LIVES_BOX(hbox),NULL);

    if (sfile->subt==NULL) {
      lives_widget_set_sensitive(commentsw->subt_checkbutton,FALSE);
      lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(commentsw->subt_checkbutton),FALSE);
    }
    else lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(commentsw->subt_checkbutton),TRUE);


    hbox = lives_hbox_new (FALSE, 0);
    lives_box_pack_start (LIVES_BOX (vbox), hbox, FALSE, FALSE, widget_opts.packing_height);

    commentsw->subt_entry=lives_standard_entry_new(_("Subtitle file"),FALSE,NULL,32,-1,LIVES_BOX(hbox),NULL);

    buttond = lives_button_new_with_mnemonic(_("Browse..."));

    g_signal_connect (buttond, "clicked",G_CALLBACK (on_save_subs_activate),
    		      (gpointer)commentsw->subt_entry);

    lives_box_pack_start (LIVES_BOX (hbox), buttond, FALSE, FALSE, widget_opts.packing_width);

    add_fill_to_box(LIVES_BOX(vbox));


    if (sfile->subt==NULL) {
      lives_widget_set_sensitive(commentsw->subt_entry,FALSE);
      lives_widget_set_sensitive(buttond,FALSE);
    }
    else {
      gchar xfilename[512];
      gchar *osubfname=NULL;

      g_snprintf(xfilename,512,"%s",filename);
      get_filename(xfilename,FALSE); // strip extension
      switch (sfile->subt->type) {
      case SUBTITLE_TYPE_SRT:
	osubfname=g_strdup_printf("%s.srt",xfilename);
	break;

      case SUBTITLE_TYPE_SUB:
	osubfname=g_strdup_printf("%s.sub",xfilename);
	break;

      default:
	break;
      }
      lives_entry_set_text(LIVES_ENTRY(commentsw->subt_entry),osubfname);
      mainw->subt_save_file=osubfname; // assign instead of free
    }
  }

  lives_widget_show_all(commentsw->comments_dialog);

  return commentsw;
}


gchar last_good_folder[PATH_MAX];

static void chooser_check_dir(GtkFileChooser *chooser, gpointer user_data) {
  gchar *cwd=g_get_current_dir();
  gchar *new_dir=gtk_file_chooser_get_current_folder(chooser);

  if (!strcmp(new_dir,last_good_folder)) return;

  if (lives_chdir(new_dir,TRUE)) {
    g_free(cwd);
    gtk_file_chooser_set_current_folder(chooser,last_good_folder);
    do_dir_perm_access_error(new_dir);
    return;
  }
  g_snprintf(last_good_folder,PATH_MAX,"%s",new_dir);
  lives_chdir(cwd,FALSE);
  g_free(cwd);

}




gchar *choose_file(gchar *dir, gchar *fname, gchar **filt, lives_file_chooser_action_t act, const char *title, GtkWidget *extra_widget) {
  // new style file chooser

  // in/out values are in utf8 encoding

  GtkWidget *chooser;
  GtkFileFilter *filter;

  gchar *filename=NULL;
  gchar *mytitle,*tmp,*tmp2;

  int response;

  register int i;

  if (title==NULL) {
    if (act==LIVES_FILE_CHOOSER_ACTION_SELECT_DEVICE) {
      mytitle=g_strdup(_("LiVES: - choose a device"));
      act=LIVES_FILE_CHOOSER_ACTION_OPEN;
    }
    else if (act==LIVES_FILE_CHOOSER_ACTION_SELECT_FOLDER) {
      mytitle=g_strdup(_("LiVES: - choose a directory"));
    }
    else {
      mytitle=g_strdup(_("LiVES: - choose a file"));
    }
  }
  else mytitle=g_strdup(title);

  if (act!=LIVES_FILE_CHOOSER_ACTION_SAVE) 
    chooser=gtk_file_chooser_dialog_new(mytitle,LIVES_WINDOW(mainw->LiVES),(GtkFileChooserAction)act, 
					(tmp=g_strdup(LIVES_STOCK_LABEL_CANCEL)), GTK_RESPONSE_CANCEL,
					(tmp2=g_strdup(LIVES_STOCK_LABEL_OPEN)), GTK_RESPONSE_ACCEPT,
					NULL);

  else {
    chooser=gtk_file_chooser_dialog_new(mytitle,LIVES_WINDOW(mainw->LiVES),(GtkFileChooserAction)act, 
					(tmp=g_strdup(LIVES_STOCK_LABEL_CANCEL)), GTK_RESPONSE_CANCEL,
					(tmp2=g_strdup(LIVES_STOCK_LABEL_SAVE)), GTK_RESPONSE_ACCEPT,
					NULL);
  }

  g_free(tmp); g_free(tmp2);

  g_free(mytitle);

  gtk_file_chooser_set_local_only(GTK_FILE_CHOOSER(chooser),TRUE);


  if (palette->style&STYLE_1) {
    lives_widget_set_bg_color(chooser, LIVES_WIDGET_STATE_NORMAL, &palette->normal_back);
    gtk_container_forall(LIVES_CONTAINER(chooser),set_child_colour,GINT_TO_POINTER(FALSE));
  }

  if (dir!=NULL) {
    gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(chooser),dir);
    gtk_file_chooser_add_shortcut_folder(GTK_FILE_CHOOSER(chooser),dir,NULL);
  }

  if (filt!=NULL) {
    filter=gtk_file_filter_new();
    gtk_file_filter_add_pattern(filter,filt[0]);
    for (i=1;filt[i]!=NULL;i++) gtk_file_filter_add_pattern(filter,filt[i]);
    gtk_file_chooser_set_filter(GTK_FILE_CHOOSER(chooser),filter);
    if (fname==NULL&&i==1&&act==LIVES_FILE_CHOOSER_ACTION_SAVE) 
      gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER(chooser),filt[0]); //utf-8
  }

  if (fname!=NULL) {
    gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER(chooser),fname); // utf-8
    if (fname!=NULL&&dir!=NULL) {
      gchar *ffname=g_build_filename(dir,fname,NULL);
      gtk_file_chooser_select_filename(GTK_FILE_CHOOSER(chooser),ffname); // must be dir and file
      g_free(ffname);
    }
  }

  lives_container_set_border_width (LIVES_CONTAINER (chooser), widget_opts.border_width);

  if (prefs->show_gui) {
    if (mainw->multitrack==NULL) lives_window_set_transient_for(LIVES_WINDOW(chooser),GTK_WINDOW(mainw->LiVES));
    else lives_window_set_transient_for(LIVES_WINDOW(chooser),GTK_WINDOW(mainw->multitrack->window));
  }

  g_signal_connect (chooser, "current-folder-changed", G_CALLBACK (chooser_check_dir), NULL);

  lives_widget_grab_focus (chooser);

  lives_widget_show(chooser);

  lives_window_center(LIVES_WINDOW(chooser));
  
  lives_window_set_modal (LIVES_WINDOW (chooser), TRUE);

  memset(last_good_folder,0,1);

  if (extra_widget==mainw->LiVES) {
    return (gchar *)chooser; // kludge to allow custom adding of extra widgets
  }

  if (extra_widget!=NULL) gtk_file_chooser_set_extra_widget(GTK_FILE_CHOOSER(chooser),extra_widget);

 rundlg:
  
  if ((response=lives_dialog_run(LIVES_DIALOG(chooser)))!=GTK_RESPONSE_CANCEL) {
    gchar *tmp;
    filename=g_filename_to_utf8((tmp=lives_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser))),-1,NULL,NULL,NULL);
    g_free(tmp);
  }

  if (filename!=NULL&&act==LIVES_FILE_CHOOSER_ACTION_SAVE) {
    if (!check_file(filename,TRUE)) {
      g_free(filename);
      filename=NULL;
      goto rundlg;
    }
  }

  lives_widget_destroy(chooser);

  return filename;

}


static void chooser_response(GtkDialog *dialog, int response, gpointer user_data) {
  int type=GPOINTER_TO_INT(user_data);

  if (response!=GTK_RESPONSE_CANCEL) {
    switch (type) {
    case 1:
      on_ok_filesel_open_clicked(GTK_FILE_CHOOSER(dialog),NULL);
      break;
    case 2:
      on_open_new_audio_clicked(GTK_FILE_CHOOSER(dialog),NULL);
      break;
    case 3:
      on_ok_file_open_clicked(GTK_FILE_CHOOSER(dialog),NULL);
      break;
    case 4:
      //on_xmms_ok_clicked(GTK_FILE_CHOOSER(dialog),NULL);
      break;
    case 5:
      on_ok_append_audio_clicked(GTK_FILE_CHOOSER(dialog),NULL);
      break;
    default:
      end_fs_preview();
      break;
    }
  }
  else on_cancel_button1_clicked(LIVES_WIDGET(dialog),NULL);
}




GtkWidget *choose_file_with_preview (gchar *dir, const gchar *title, int preview_type) {
  // preview_type 1 - video and audio open (single - opensel)
  // preview type 2 - import audio
  // preview_type 3 - video and audio open (multiple)
  // type 4 xmms (deprecated)
  // type 5 append audio
  
  // type 128 - locate missing clip


  GtkWidget *chooser;

  chooser=(GtkWidget *)choose_file(dir,NULL,NULL,LIVES_FILE_CHOOSER_ACTION_OPEN,title,mainw->LiVES);
  
  if (preview_type==3) gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(chooser),TRUE);

  widget_add_preview(chooser,LIVES_BOX(lives_dialog_get_content_area(LIVES_DIALOG(chooser))),
		     LIVES_BOX(lives_dialog_get_content_area(LIVES_DIALOG(chooser))),
		     LIVES_BOX(lives_dialog_get_action_area(LIVES_DIALOG(chooser))),
		     (preview_type==3||preview_type==128)?1:preview_type>3?2:preview_type);

  if (prefs->fileselmax) {
    lives_window_set_resizable (LIVES_WINDOW(chooser),TRUE);
    lives_window_maximize (LIVES_WINDOW(chooser));
    lives_widget_queue_draw(chooser);
    lives_widget_context_update();
  }

  g_signal_connect (chooser, "response", G_CALLBACK (chooser_response), GINT_TO_POINTER(preview_type));

  return chooser;
}






//cancel/discard/save dialog
_entryw* create_cds_dialog (int type) {
  GtkWidget *dialog_vbox;
  GtkWidget *dialog_action_area;
  GtkWidget *cancelbutton;
  GtkWidget *discardbutton;
  GtkWidget *savebutton;
  GtkWidget *label=NULL;
  GtkWidget *hbox;
  GtkAccelGroup *accel_group;

  _entryw *cdsw=(_entryw*)(g_malloc(sizeof(_entryw)));

  cdsw->warn_checkbutton=NULL;

  cdsw->dialog = lives_standard_dialog_new (_("LiVES: - Cancel/Discard/Save"),FALSE);

  accel_group = GTK_ACCEL_GROUP(lives_accel_group_new ());
  lives_window_add_accel_group (LIVES_WINDOW (cdsw->dialog), accel_group);

  if (prefs->show_gui) {
    if (mainw->multitrack==NULL) lives_window_set_transient_for(LIVES_WINDOW(cdsw->dialog),GTK_WINDOW(mainw->LiVES));
    else lives_window_set_transient_for(LIVES_WINDOW(cdsw->dialog),GTK_WINDOW(mainw->multitrack->window));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(cdsw->dialog));

  widget_opts.justify=LIVES_JUSTIFY_CENTER;
  if (type==0) {
    if (strlen(mainw->multitrack->layout_name)==0) {
      label = lives_standard_label_new (_("You are about to leave multitrack mode.\nThe current layout has not been saved.\nWhat would you like to do ?\n"));
    }
    else {
      label = lives_standard_label_new (_("You are about to leave multitrack mode.\nThe current layout has been changed since the last save.\nWhat would you like to do ?\n"));
    }
  }
  else if (type==1) {
    if (!mainw->only_close) label = lives_standard_label_new (_("You are about to exit LiVES.\nThe current clip set can be saved.\nWhat would you like to do ?\n"));
    else label = lives_standard_label_new (_("The current clip set has not been saved.\nWhat would you like to do ?\n"));
  }
  else if (type==2||type==3) {
    if ((mainw->multitrack!=NULL&&mainw->multitrack->changed)||(mainw->stored_event_list!=NULL&&mainw->stored_event_list_changed)) {
      label = lives_standard_label_new (_("The current layout has not been saved.\nWhat would you like to do ?\n"));
    }
    else {
      label = lives_standard_label_new (_("The current layout has *not* been changed since it was last saved.\nWhat would you like to do ?\n"));
    }
  }
  else if (type==4) {
    if (mainw->multitrack!=NULL&&mainw->multitrack->changed) {
      label = lives_standard_label_new (_("The current layout contains generated frames and cannot be retained.\nYou may wish to render it before exiting multitrack mode.\n"));
    }
    else {
      label = lives_standard_label_new (_("You are about to leave multitrack mode.\nThe current layout contains generated frames and cannot be retained.\nWhat do you wish to do ?"));
    }
  }
  widget_opts.justify=LIVES_JUSTIFY_DEFAULT;

  lives_box_pack_start (LIVES_BOX (dialog_vbox), label, TRUE, TRUE, 0);

  if (type==1) {
    GtkWidget *checkbutton;

    hbox = lives_hbox_new (FALSE, 0);
    lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, FALSE, FALSE, widget_opts.packing_height);
    
    cdsw->entry = lives_standard_entry_new (_("Clip set _name"),TRUE,strlen (mainw->set_name)?mainw->set_name:"",
					    32.*widget_opts.scale,128.*widget_opts.scale,LIVES_BOX(hbox),NULL);

    hbox = lives_hbox_new (FALSE, 0);
    lives_box_pack_start (LIVES_BOX (dialog_vbox), hbox, FALSE, FALSE, widget_opts.packing_height);

    checkbutton = lives_standard_check_button_new (_("_Auto reload next time"),TRUE,LIVES_BOX(hbox),NULL);

    if ((type==0&&prefs->ar_layout)||(type==1&&!mainw->only_close)) {
      lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(checkbutton),TRUE);
      if (type==1) prefs->ar_clipset=TRUE;
      else prefs->ar_layout=TRUE;
    }
    else {
      lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(checkbutton),FALSE);
      if (type==1) prefs->ar_clipset=FALSE;
      else prefs->ar_layout=FALSE;
    }
    
    g_object_set_data(G_OBJECT(checkbutton),"cdsw",(gpointer)cdsw);
    
    g_signal_connect (GTK_OBJECT (checkbutton), "toggled",
		      G_CALLBACK (on_autoreload_toggled),
		      GINT_TO_POINTER(type));
  }

  if (type==0&&!(prefs->warning_mask&WARN_MASK_EXIT_MT)) {
    add_warn_check(LIVES_BOX(dialog_vbox),WARN_MASK_EXIT_MT);
  }

  dialog_action_area = lives_dialog_get_action_area(LIVES_DIALOG (cdsw->dialog));
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancelbutton = lives_button_new_from_stock ("gtk-cancel");
  lives_dialog_add_action_widget (LIVES_DIALOG (cdsw->dialog), cancelbutton, 0);
  lives_widget_add_accelerator (cancelbutton, "activate", accel_group,
                              LIVES_KEY_Escape, (GdkModifierType)0, (GtkAccelFlags)0);

  discardbutton = lives_button_new_from_stock ("gtk-delete");
  lives_dialog_add_action_widget (LIVES_DIALOG (cdsw->dialog), discardbutton, 1+(type==2));
  lives_button_set_use_stock(GTK_BUTTON(discardbutton),FALSE);
  gtk_button_set_use_underline(GTK_BUTTON(discardbutton),TRUE);
  if ((type==0&&strlen(mainw->multitrack->layout_name)==0)||type==3||type==4) lives_button_set_label(GTK_BUTTON(discardbutton),_("_Wipe layout"));
  else if (type==0) lives_button_set_label(GTK_BUTTON(discardbutton),_("_Ignore changes"));
  else if (type==1) lives_button_set_label(GTK_BUTTON(discardbutton),_("_Delete clip set"));
  else if (type==2) lives_button_set_label(GTK_BUTTON(discardbutton),_("_Delete layout"));

  savebutton = lives_button_new_from_stock ("gtk-save");
  lives_button_set_use_stock(GTK_BUTTON(savebutton),FALSE);
  gtk_button_set_use_underline(GTK_BUTTON(savebutton),TRUE);
  if (type==0||type==3) lives_button_set_label(GTK_BUTTON(savebutton),_("_Save layout"));
  else if (type==1) lives_button_set_label(GTK_BUTTON(savebutton),_("_Save clip set"));
  else if (type==2) lives_button_set_label(GTK_BUTTON(savebutton),_("_Wipe layout"));
  if (type!=4) lives_dialog_add_action_widget (LIVES_DIALOG (cdsw->dialog), savebutton, 2-(type==2));
  lives_widget_set_can_focus_and_default (savebutton);
  if (type==1||type==2)lives_widget_grab_default(savebutton);

  lives_widget_show_all(cdsw->dialog);

  if (type==1) {
    lives_widget_grab_focus(cdsw->entry);
  }

  return cdsw;
}




void do_layout_recover_dialog(void) {
  if (!do_yesno_dialog(_("\nLiVES has detected a multitrack layout from a previous session.\nWould you like to try and recover it ?\n")))
    recover_layout_cancelled(TRUE);
  else recover_layout();
}


static void flip_cdisk_bit (GtkToggleButton *t, gpointer user_data) {
  guint32 bitmask=GPOINTER_TO_INT(user_data);
  prefs->clear_disk_opts^=bitmask;
}


GtkWidget *create_cleardisk_advanced_dialog(void) {
  GtkWidget *dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *scrollw;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *checkbutton;
  GtkWidget *okbutton;
  GtkWidget *resetbutton;

  gchar *tmp,*tmp2;

  dialog = lives_standard_dialog_new (_("LiVES: - Disk Recovery Options"),FALSE);

  if (prefs->show_gui) {
    if (mainw->multitrack==NULL) lives_window_set_transient_for(LIVES_WINDOW(dialog),GTK_WINDOW(mainw->LiVES));
    else lives_window_set_transient_for(LIVES_WINDOW(dialog),GTK_WINDOW(mainw->multitrack->window));
  }

  dialog_vbox = lives_dialog_get_content_area(LIVES_DIALOG(dialog));

  vbox = lives_vbox_new (FALSE, 0);
  lives_container_set_border_width (LIVES_CONTAINER (vbox), widget_opts.border_width*2);

  scrollw = lives_standard_scrolled_window_new (450.*widget_opts.scale,300.*widget_opts.scale,vbox);

  lives_container_add (LIVES_CONTAINER (dialog_vbox), scrollw);
   
  hbox = lives_hbox_new (FALSE, 0);
  lives_box_pack_start (LIVES_BOX (vbox), hbox, FALSE, TRUE, widget_opts.packing_height);

  checkbutton = lives_standard_check_button_new((tmp=g_strdup(_("Delete _Orphaned Clips"))),TRUE,LIVES_BOX(hbox),
						(tmp2=g_strdup(_("Delete any clips which are not currently loaded or part of a set"))));

  g_free(tmp); g_free(tmp2);

  lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(checkbutton), !(prefs->clear_disk_opts & LIVES_CDISK_LEAVE_ORPHAN_SETS));

  g_signal_connect_after (GTK_OBJECT (checkbutton), "toggled",
			  G_CALLBACK (flip_cdisk_bit),
			  GINT_TO_POINTER(LIVES_CDISK_LEAVE_ORPHAN_SETS));

  hbox = lives_hbox_new (FALSE, 0);
  lives_box_pack_start (LIVES_BOX (vbox), hbox, FALSE, TRUE, widget_opts.packing_height);

  checkbutton = lives_standard_check_button_new(_("Clear _Backup Files from Closed Clips"),TRUE,LIVES_BOX(hbox),NULL);

  lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(checkbutton), !(prefs->clear_disk_opts & LIVES_CDISK_LEAVE_BFILES));

  g_signal_connect_after (GTK_OBJECT (checkbutton), "toggled",
			  G_CALLBACK (flip_cdisk_bit),
			  GINT_TO_POINTER(LIVES_CDISK_LEAVE_BFILES));

  hbox = lives_hbox_new (FALSE, 0);
  lives_box_pack_start (LIVES_BOX (vbox), hbox, FALSE, TRUE, widget_opts.packing_height);

  checkbutton = lives_standard_check_button_new(_("Remove Sets which have _Layouts but no Clips"),TRUE,LIVES_BOX(hbox),NULL);

  lives_toggle_button_set_active(LIVES_TOGGLE_BUTTON(checkbutton), 
				 (prefs->clear_disk_opts & LIVES_CDISK_REMOVE_ORPHAN_LAYOUTS));
  
  g_signal_connect_after (GTK_OBJECT (checkbutton), "toggled",
			  G_CALLBACK (flip_cdisk_bit),
			  GINT_TO_POINTER(LIVES_CDISK_REMOVE_ORPHAN_LAYOUTS));

  resetbutton = lives_button_new_from_stock ("gtk-refresh");
  lives_dialog_add_action_widget (LIVES_DIALOG (dialog), resetbutton, LIVES_RETRY);
  lives_button_set_label(GTK_BUTTON(resetbutton),_("_Reset to Defaults"));

  okbutton = lives_button_new_from_stock ("gtk-ok");
  lives_dialog_add_action_widget (LIVES_DIALOG (dialog), okbutton, GTK_RESPONSE_OK);

  lives_widget_set_can_focus_and_default (okbutton);
  lives_widget_grab_default (okbutton);
  lives_button_set_label(GTK_BUTTON(okbutton),_("_Accept"));

  return dialog;

}


GtkTextView *create_output_textview(void) {
  GtkWidget *textview=gtk_text_view_new();
  gtk_text_view_set_editable (GTK_TEXT_VIEW (textview), FALSE);

  if (palette->style&STYLE_1) {
    lives_widget_set_base_color(textview, LIVES_WIDGET_STATE_NORMAL, &palette->info_base);
    lives_widget_set_text_color(textview, LIVES_WIDGET_STATE_NORMAL, &palette->info_text);
  }

  g_object_ref(textview);
  lives_widget_show(textview);
  return GTK_TEXT_VIEW(textview);
}

