/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/variable.h"

static GSList *emptyList (guint n)
{
	GSList *l=NULL;
	
	for (guint i=0; i < n; i++)
		l = g_slist_prepend (l, new LWVariable());
	
	return l;
}

/*! \brief Konstruktor

	Tworzy projekt
*/
LWVariable::LWVariable ()
{
}

/*! \brief Konstruktor wartości z ikoną

	Tworzy wartość zawierającą pojedynczą ikonę
*/
LWVariable::LWVariable (LWPixmap *a_pixmap)
{
	is_list = FALSE;
	pixmap = a_pixmap;
}

/*! \brief Konstruktor kopiujący

	Konstruktor kopiujący zmiennej

	\param value Zmienna, na podstawie której ma powstać duplikat
*/
LWVariable::LWVariable (const LWValue *value)
{
	is_list = TRUE;
	list = NULL;
	set ( (LWValue *) value);
}

/*! \brief Pobierz indeks

	Pobiera zmienną znajdującą sie pod indeksem
	\param n Indeks do pobrania (liczony od 1)
	\return Pobrany indeks
*/
LWValue *LWVariable::getIndex (guint n)
{
	g_return_val_if_fail (n > 0, new LWValue());
	g_return_val_if_fail (TRUE == canBeIndexed(), new LWValue());
	
	if (is_list == FALSE) {
		convertToList ();
	}
		
	LWValue *value = (LWValue *) g_slist_nth_data (list, n-1);
	
	if (value == NULL) {
		guint l = g_slist_length (list);
		
		g_return_val_if_fail (n > l, NULL);
		
		list = g_slist_concat (list, emptyList (n - l));
		value = (LWValue *) g_slist_last (list)->data;
	}
	
	return value;
}

/*! \brief Czy wartość stanowi zmienną

	Czy wartość stanowi zmienną
	\return Zwraca prawdę
*/
gboolean LWVariable::isVariable ()
{
	return TRUE;
}
