###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk
import pango
import stock
import config
import os
import utils
import amazon
import urllib
import gobject

from song import *


def get_scrolled_window(widget,use_view_port=False):
        scroll = gtk.ScrolledWindow()
        scroll.set_policy(gtk.POLICY_NEVER,gtk.POLICY_AUTOMATIC)
        if use_view_port:
            scroll.add_with_viewport(widget)
        else:
            scroll.add(widget)
        scroll.set_shadow_type(gtk.SHADOW_IN)
        return scroll

class WindowBase(gtk.Dialog):

    def __init__(self,title="",image=None,bouton = (
                        gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                        gtk.STOCK_OK, gtk.RESPONSE_ACCEPT) ):
        gtk.Dialog.__init__(self,title,None,
                 gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                     bouton
                 )

        self.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        self.set_resize_mode(False)
        self.set_border_width(6)
        self.set_modal(True)
        self.set_property("skip-taskbar-hint",True)
        self.set_has_separator(False)

        self.label_heading = gtk.Label("<span size=\"larger\"><b>"+title+"</b></span>")
        self.label_heading.set_alignment(0,0.5)
        self.label_heading.set_use_markup(True)

        self.box_contenu = gtk.VBox(False,6)
        self.box_contenu.pack_start(self.label_heading,False,False)
        #self.box_contenu.set_border_width(12)

        hbox = gtk.HBox(False,12)

        if image:
            if isinstance(image,str):
                wimage = gtk.Image()
                wimage.set_from_file(image)
                wimage.set_alignment(0,0)
            else:
                wimage = image
            a = gtk.Alignment(xalign=0.0)
            a.add(wimage)
            hbox.pack_start(a,False,False)

        hbox.pack_start(self.box_contenu,True,True)
        hbox.set_border_width(6)

        self.vbox.pack_start(hbox,False,False)
        self.vbox.set_spacing(6)
        self.set_resizable(False)

    def add_widget(self,widget,x=False,y=False):
        self.box_contenu.pack_start(widget,x,y)


class AlbumCoverWindow(gtk.FileChooserDialog):
    def __init__(self,current_song):
        song = Song()
        song.read_from_song(current_song)

        gtk.FileChooserDialog.__init__(self,_("Choose an album cover"), None,
             gtk.FILE_CHOOSER_ACTION_OPEN,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))

        btn = self.add_button(_("Internet search"),gtk.RESPONSE_HELP)
        btn.set_image(gtk.image_new_from_stock(gtk.STOCK_FIND, gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.set_current_folder(os.path.expanduser("~/"))

        file = ''
        ffilter = gtk.FileFilter()
        ffilter.set_name(_("Image files"))
        ffilter.add_mime_type("image/bmp")
        ffilter.add_mime_type("image/gif")
        ffilter.add_mime_type("image/jpeg")
        ffilter.add_mime_type("image/png")
        ffilter.add_mime_type("image/svg+xml")

        self.add_filter(ffilter)
        self.set_size_request(500,350)

        response = self.run()
        if response == gtk.RESPONSE_OK:
            file = self.get_filename()
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(file,75,75)
            new_file = song.get_album_cover_path()
            if os.path.exists(new_file):
                 os.unlink(new_file)
            if os.path.exists(new_file+".#disable#"):
                 os.unlink(new_file+".#disable#")
            pixbuf.save(new_file, "jpeg", {"quality":"85"})
            del pixbuf
            self.destroy()
        elif response == gtk.RESPONSE_HELP:
            self.destroy()
            AmazonWindow(song)
        else:
            self.destroy()

class AmazonWindow(WindowBase):
    def __init__(self,current_song):
        self.song = Song()
        self.song.read_from_song(current_song)
        image = gtk.Image()
        image.set_from_file(self.song.get_album_cover(False))
        f = gtk.Frame()
        f.set_shadow_type(gtk.SHADOW_IN)
        f.add(image)
        WindowBase.__init__(self,_("Search an album cover"),None,())

        default_search = utils.remove_accents(self.song.get_album_cover_search_str())

        self.entry = gtk.Entry()
        self.entry.set_text(default_search.replace("+"," "))
        self.entry.set_size_request(300,-1)
        self.entry.connect("activate",lambda btn: self.on_search(btn))

        btn_search = gtk.Button(stock=gtk.STOCK_FIND)
        btn_search.connect("clicked",self.on_search)
        hbox = gtk.HBox(False,12)
        hbox.pack_start(self.entry,True,True)
        hbox.pack_start(btn_search,False,False)

        self.box_resultat = gtk.Table(4,2)

        vbox = gtk.VBox(False,0)
        vbox.pack_start(hbox,False,False)
        vbox.pack_start(self.box_resultat,False,False)
        self.add_widget(vbox)
        self.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
        self.add_button(gtk.STOCK_DELETE, gtk.RESPONSE_APPLY)
        self.add_button(gtk.STOCK_OPEN, gtk.RESPONSE_YES)
        self.add_button(gtk.STOCK_GO_BACK, gtk.RESPONSE_NO)
        self.add_button(gtk.STOCK_GO_FORWARD, gtk.RESPONSE_REJECT)

        self.label_error = gtk.Label(_("No result for this request"))
        self.label_error.set_alignment(0.5,0.5)
        self.label_error.set_size_request(-1,200)

        self.label_start = gtk.Label(" ")
        self.label_start.set_alignment(0.5,0.5)
        self.label_start.set_size_request(-1,200)

        self.box_resultat.resize(1,1)
        self.box_resultat.attach(self.label_start, 0, 1, 0, 1)

        self.current_page = 1
        self.show_all()
        self.action_area.get_children()[0].set_sensitive(False)
        self.action_area.get_children()[1].set_sensitive(False)
        reponse = self.run()
        while reponse not in [gtk.RESPONSE_CANCEL,gtk.RESPONSE_DELETE_EVENT]:
            if reponse == gtk.RESPONSE_NO:
                self.on_search(None,self.current_page-1)
            if reponse == gtk.RESPONSE_REJECT:
                self.on_search(None,self.current_page+1)
            if reponse == gtk.RESPONSE_YES:
                self.destroy()
                AlbumCoverWindow(self.song)
                return
            if reponse == gtk.RESPONSE_APPLY:
                new_file = self.song.get_album_cover_path()
                if os.path.exists(new_file):
                     os.unlink(new_file)
                pixbuf = config.DEFAULT_ALBUM_COVER_PIXBUF_BIG
                pixbuf.save(new_file+".#disable#", "jpeg", {"quality":"85"})
                self.destroy()
                return
            reponse = self.run()
        self.destroy()


    def on_search(self,btn=None,page=1):
        art = self.entry.get_text()
        art = utils.filter_info_song(art).encode('utf-8')

        self.box_resultat.foreach(self.box_resultat.remove)
        amazon.setLicense("0RKH4ZH1JCFZHMND91G2")
        try:
            bags = amazon.searchByKeyword(art,page=page,type="lite", product_line="music")
        except:
            self.current_page = 1
            self.box_resultat.resize(1,1)
            self.box_resultat.attach(self.label_error, 0, 1, 0, 1)
            pass
        else:

            self.current_page = page

            tmp_dir = "/tmp/listen/cover"
            if not os.path.exists(tmp_dir):
                os.makedirs(tmp_dir)

            i = 0
            top_attach = 0
            left_attach = 0
            if self.current_page == 1:
                self.action_area.get_children()[1].set_sensitive(False)
            else:
                self.action_area.get_children()[1].set_sensitive(True)
            if len(bags)<10:
                self.action_area.get_children()[0].set_sensitive(False)
            else:
                self.action_area.get_children()[0].set_sensitive(True)

            height= int(round(len(bags)/2,1))
            if len(bags)%2!=0: height += 1
            #if height>8 : height=8
            self.box_resultat.resize(height,2)

            for bag in bags:
                image_path = tmp_dir+"/%d.jpg"%i
                if  os.path.exists(image_path):
                    os.unlink(image_path)
                res = urllib.urlretrieve(bag.ImageUrlSmall, image_path)

                pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(image_path,40,40)
                image = gtk.Image()
                image.set_from_pixbuf(pixbuf)
                image.set_size_request(40,40)
                label = gtk.Label()
                artists = bag.Artists.Artist
                if isinstance(artists,list):
                    artists = artists[0]
                label.set_markup("<b>"+utils.xmlescape(bag.ProductName)+"</b>\n"+utils.xmlescape(artists))
                label.set_property("ellipsize",pango.ELLIPSIZE_END)
                label.set_alignment(0,0.5)
                box= gtk.HBox(False,6)
                box.pack_start(image,False,False)
                box.pack_start(label,True,True)

                btn_album_cover = gtk.Button()#"test-%d"%i)
                btn_album_cover.set_alignment(0.5,0.5)
                btn_album_cover.connect("clicked",self.on_album_cover_clicked,image_path)
                btn_album_cover.set_relief(gtk.RELIEF_NONE)
                btn_album_cover.add(box)
                right_attach = left_attach+1
                bottom_attach = top_attach+1
                self.box_resultat.attach(btn_album_cover, left_attach, right_attach, top_attach, bottom_attach)
                i += 1
                if i%2==0:
                    top_attach += 1
                    left_attach = 0
                else:
                    left_attach += 1
        self.show_all()


    def on_album_cover_clicked(self,btn,image_path):
        pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(image_path,75,75)
        self.song.remove_album_cover()
        new_file = self.song.get_album_cover_path()
        if os.path.exists(new_file):
             os.unlink(new_file)
        if os.path.exists(new_file+".#disable#"):
             os.unlink(new_file+".#disable#")
        pixbuf.save(new_file, "jpeg", {"quality":"85"})
        del pixbuf
        self.emit("response",gtk.RESPONSE_DELETE_EVENT)


class WindowMessage(WindowBase):
    def __init__(self,title,msg=None,image=None):
        if image == None:
            image = gtk.image_new_from_stock(gtk.STOCK_DIALOG_INFO,gtk.ICON_SIZE_DIALOG)
        WindowBase.__init__(self,title,image,(gtk.STOCK_CLOSE, gtk.RESPONSE_CANCEL) )

        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',False)
        if msg==None:msg=""
        if isinstance(msg,str) or isinstance(msg,unicode):
            label = gtk.Label(msg)
            label.set_alignment(0,0)
            self.add_widget(label)
        else:
            self.add_widget(msg)
        self.show_all()
        self.run()
        self.destroy()


from podcast_manager import PodcastManager
class WindowAddPodcast(WindowBase):
    def __init__(self):
        WindowBase.__init__(self,
                         _("Add a Podcast to the media library"),
                         config.PIXMAP_DIR+"podcast_big.png"
                    )
        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',True)
        self.entry_uri = gtk.Entry()
        label_uri = gtk.Label(_("Uri")+" : ")

        table = gtk.Table(rows=6, columns=2, homogeneous=False)
        table.set_row_spacings(3)
        table.set_col_spacing(1,6)

        table.attach(label_uri,0,1,1,2,gtk.FILL,gtk.FILL)
        table.attach(self.entry_uri,1,2,1,2,gtk.EXPAND|gtk.FILL,gtk.SHRINK)

        self.add_widget(table)
        self.show_all()

    def run(self):
        response = WindowBase.run(self)
        if response == gtk.RESPONSE_ACCEPT and self.entry_uri.get_text() != "":
            if utils.get_protocol(self.entry_uri.get_text()) == "http://":
               PodcastManager.download_podcast_feed(self.entry_uri.get_text())

            self.destroy()
        else:
           self.destroy()

from db_manager import DBManager
class WindowAddRadio(WindowBase):
    def __init__(self,media_organizer):
        self.media_organizer = media_organizer
        WindowBase.__init__(self,
                         _("Add a radio to the media library"),
                         config.PIXMAP_DIR+"playlist_radio_big.png"
                    )
        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',True)
        self.entry_title = gtk.Entry()
        self.entry_uri = gtk.Entry()
        label_title = gtk.Label(_("Name")+" : ")
        label_uri = gtk.Label(_("Uri")+" : ")

        table = gtk.Table(rows=6, columns=2, homogeneous=False)
        table.set_row_spacings(3)
        table.set_col_spacing(1,6)

        table.attach(label_title,0,1,0,1,gtk.FILL,gtk.FILL)
        table.attach(self.entry_title,1,2,0,1,gtk.EXPAND|gtk.FILL,gtk.SHRINK)

        table.attach(label_uri,0,1,1,2,gtk.FILL,gtk.FILL)
        table.attach(self.entry_uri,1,2,1,2,gtk.EXPAND|gtk.FILL,gtk.SHRINK)


        self.add_widget(table)
        self.show_all()

    def run(self):
        response = WindowBase.run(self)

        def add_iradio_in_db(uri,name):
            #FIXME: Add verification stream exist
            if utils.get_ext(uri) in PLAYLIST_EXTENTION:
                i = 0
                #FIXME : autodetect playlist type no always use m3u
                new_name= name
                for new_uri in utils.import_playlist(uri,".m3u"):
                    song = DBManager.get_iradio_by_uri(new_uri)
                    if song!=None:
                       song.set_property("title",new_name)
                       DBManager.update_song(song)
                       new_name = name+" (%d)"%i
                       i += 1
            else:
                song = DBManager.get_iradio_by_uri(uri);
                if song!=None:
                   song.set_property("title",name)
                   DBManager.update_song(song)

        if response == gtk.RESPONSE_ACCEPT and self.entry_uri.get_text() != "":
            add_iradio_in_db(self.entry_uri.get_text(),self.entry_title.get_text())
            #refresh iradio wiew
            from media_source import IRadioSource
            for source in self.media_organizer.list_source:
                if isinstance(source,IRadioSource):
                    source.view.refresh_songs_cache()
                    source.view.populate()
            self.destroy()
        else:
           self.destroy()

from file_inspector import FileInspector
class WindowAddDirectory(gtk.FileChooserDialog):
    def __init__(self,media_organizer):
        gtk.FileChooserDialog.__init__(self,_("Choose the directory to add to the library"), None,
             gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))

        self.media_organizer = media_organizer
        self.set_current_folder(os.path.expanduser("~/"))
        file = ''

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        if response == gtk.RESPONSE_OK:
             folder = self.get_filename()
             self.hide_all()
             if os.path.exists(folder):
                print folder
                self.dialog_wait = WindowBase(
                                 _("Add the directory in the library"),
                                 config.PIXMAP_DIR+"listen.png",
                                 None
                                )
                self.dialog_wait.connect("delete-event",lambda *args:  True)
                self.dialog_wait.set_property("skip-taskbar-hint",True)
                self.dialog_wait.set_property('has-separator',False)
                self.progress_bar_wait = gtk.ProgressBar()
                box = gtk.HBox()
                box.pack_start(self.progress_bar_wait,True,True,12)
                self.label_wait = gtk.Label(_("Reading directory..."))
                self.label_wait.set_alignment(0,0.5)
                self.label_wait.set_ellipsize(pango.ELLIPSIZE_START)
                self.dialog_wait.add_widget(self.label_wait)
                self.dialog_wait.vbox.pack_start(box,True,True)
                self.dialog_wait.show_all()
                self.progress_bar_wait.set_size_request(344,-1)
                self.file_inspector = FileInspector()
                gobject.idle_add(self.file_inspector.parse_directory,folder)
                gobject.timeout_add(500,self.check_directory)

        else:
            self.destroy()

    def check_directory(self):
        self.progress_bar_wait.pulse()
        if self.file_inspector.is_ready() == False:
            return True
        info = self.file_inspector.get_info()
        if info == None:
            from media_source import MLBrowserSource
            for source in self.media_organizer.list_source:
                if isinstance(source,MLBrowserSource):
                    source.widget.refresh_song_cache()
                    source.widget.populate_view()
            del self.file_inspector
            self.dialog_wait.destroy()
            self.destroy()
            return False
        else:
            file = info["file"]
            fraction = round(round(info["num"]) / info["total"],2)

            self.progress_bar_wait.set_fraction(fraction)
            self.progress_bar_wait.set_text("%d/%d"%(info["num"],info["total"]))
            self.label_wait.set_text(file)
            return True


class trayicon:
    def __init__(self,window):

        self.player = window.player
        self.window = window
        self.player.connect("player-action",self.player_action_cb)

        self.eventbox = gtk.EventBox()

        try: import egg.trayicon
        except: self.tray=None
        else:
            self.tray = egg.trayicon.TrayIcon("Listen")
            self.tray.add(self.eventbox)


        self.eventbox.connect("button_press_event", self.on_button_press_event )
        self.eventbox.connect("enter-notify-event", self.on_mouse_over)
        self.eventbox.connect("leave-notify-event", self.on_mouse_out)

        self.eventbox.connect("scroll-event",self.on_scroll_event)
        self.icone = gtk.Image()
        self.icone.set_from_file(config.PIXMAP_DIR+"/listen_tray.png")
        self.eventbox.add(self.icone)

        #self.menu = menu_trayicon(self.player)
        #self.__pos = self.window.get_position()

        if config.get("setting","use_trayicon")=="true" and self.tray!=None:
            self.tray.show_all()

        menu_ui = """
        <ui>
            <popup name="TrayIconMenu">
              <menuitem name="play" action="play"/>
              <menuitem name="pause" action="pause"/>
              <menuitem name="next" action="next"/>
              <menuitem name="previous" action="previous"/>
              <separator/>
              <menuitem name="quit" action="quit"/>
            </popup>
        </ui>
        """
        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play'), self.action_tray)])
        actiongroup.add_actions([('pause', gtk.STOCK_MEDIA_PAUSE, _('_Pause'), None,
                                         _('Pause'), self.action_tray)])
        actiongroup.add_actions([('next', gtk.STOCK_MEDIA_NEXT, _('_Next'), None,
                                         _('Next'), self.action_tray)])
        actiongroup.add_actions([('previous', gtk.STOCK_MEDIA_PREVIOUS, _('_Previous'), None,
                                         _('Previous'),self.action_tray)])
        actiongroup.add_actions([('quit', gtk.STOCK_QUIT, _('_Quit'), None,
                          _('Quit Listen'), self.action_tray)])

        self.uimanager.insert_action_group(actiongroup, 1)
        #self.add_accel_group(accelgroup)
        self.pause = self.uimanager.get_action("/TrayIconMenu/pause")
        self.pause.set_visible(False)
        self.play =  self.uimanager.get_action("/TrayIconMenu/play")
        self.menu = self.uimanager.get_widget("/TrayIconMenu")
        self.menu.connect("selection-done",self.on_selection_done)
        self.show_menu=False
        gtk.quit_add(0,self.cacher)


    def on_delete(self,win,event):
        pass

    def on_mouse_over(self,widget,event=None):
        if config.get("osd","enable")=="true" and self.show_menu == False and self.player.current_song!=None:
            filename = self.player.current_song.get_album_cover(False)
            self.player.osd.show_osd(self.player.current_song)

    def on_mouse_out(self,widget,event=None):
        self.player.osd.hide_osd(None,None)

    def on_scroll_event(self,widget,event):
        self.player.btn_volume.emit('scroll-event', event)

    def on_selection_done(self,widget):
        self.show_menu=False

    def action_tray(self,btn):
        name = btn.get_name()
        if name == "quit":
            self.window.on_quit(None)
        if name == "play":
            self.player.btn_play.clicked()
        if name == "pause":
            self.player.btn_play.clicked()
        if name == "next":
            self.player.btn_next.clicked()
        if name == "previous":
            self.player.btn_previous.clicked()


    def player_action_cb(self,widget,action):
        if action=="pause":
            self.pause.set_visible(False)
            self.play.set_visible(True)
        else:
            self.pause.set_visible(True)
            self.play.set_visible(False)

    def position_menu(self,menu):
        #Grab from deskbar applet
        align_to = self.eventbox
        direction = self.eventbox.get_direction()

        screen = menu.get_screen()
        monitor_num = screen.get_monitor_at_window(align_to.window)
        if monitor_num < 0:
                monitor_num = 0

        monitor = screen.get_monitor_geometry (monitor_num)
        menu.set_monitor (monitor_num)

        tx, ty = align_to.window.get_origin()
        twidth, theight = menu.get_child_requisition()

        tx += align_to.allocation.x
        ty += align_to.allocation.y
        if direction == gtk.TEXT_DIR_RTL:
                tx += align_to.allocation.width - twidth

        if (ty + align_to.allocation.height + theight) <= monitor.y + monitor.height:
                ty += align_to.allocation.height
        elif (ty - theight) >= monitor.y:
                ty -= theight
        elif monitor.y + monitor.height - (ty + align_to.allocation.height) > ty:
                ty += align_to.allocation.height
        else:
                ty -= theight

        if tx < monitor.x:
                x = monitor.x
        elif tx > max(monitor.x, monitor.x + monitor.width - twidth):
                x = max(monitor.x, monitor.x + monitor.width - twidth)
        else:
                x = tx
        y = ty

        return (x, y, False)

    def on_button_press_event(self , widget, event):
        if event.button == 1:
            if self.window.get_property('visible'):
                if self.window.is_active():
                    self.cacher()
                else:
                    self.window.present()
            else:
                self.montrer()
        if event.button == 3:
            self.show_menu=True
            self.player.osd.hide_osd(None,None)
            self.menu.popup(None,None,self.position_menu,event.button,event.time)


    def cacher(self):
        #self.__pos = self.window.get_position()
        event = self.window.window.get_state()
        if event == gtk.gdk.WINDOW_STATE_MAXIMIZED:
            config.set("window","state","maximized")
        else:
            config.set("window","state","normal")
        self.window.hide_all()

    def montrer(self):
        self.window.move(int(config.get("window","x")),int(config.get("window","y")))
        window_state = config.get("window","state")
        if window_state == "maximized" :
            self.window.maximize()
        if window_state == "normal":
            self.window.unmaximize()
        self.window.show_all()

#########
#From quodlibet Copyright 2005 Joe Wreschnig piman[AT]sacredchao[DOT]net
#########
class MultiDragTreeview(gtk.TreeView):
    def __init__(self, *args):
        super(MultiDragTreeview, self).__init__(*args)
        self.connect_object('button-press-event', MultiDragTreeview.__button_press,self)
        self.connect_object('button-release-event', MultiDragTreeview.__button_release,self)
        self.connect_object('drag-begin', MultiDragTreeview.__begin,self)
        self.__pending_event = None

    def __button_press(self, event):
        if event.button == 1: return self.__block_selection(event)
        if event.button == 3:
            x, y = map(int, [event.x, event.y])
            try: path, col, cellx, celly = self.get_path_at_pos(x, y)
            except TypeError: return True
            self.grab_focus()
            selection = self.get_selection()
            if not selection.path_is_selected(path):
                self.set_cursor(path, col, 0)
            #else:
            col.focus_cell(col.get_cell_renderers()[0])
            self.emit('popup-menu')
            return True

    def __block_selection(self, event):
        x, y = map(int, [event.x, event.y])
        try: path, col, cellx, celly = self.get_path_at_pos(x, y)
        except TypeError: return True
        self.grab_focus()
        selection = self.get_selection()
        if ((selection.path_is_selected(path)
            and not (event.state & (gtk.gdk.CONTROL_MASK|gtk.gdk.SHIFT_MASK)))):
            self.__pending_event = [x, y]
            selection.set_select_function(lambda *args: False)
        elif event.type == gtk.gdk.BUTTON_PRESS:
            self.__pending_event = None
            selection.set_select_function(lambda *args: True)

    def __button_release(self, event):
        if self.__pending_event:
            selection = self.get_selection()
            selection.set_select_function(lambda *args: True)
            oldevent = self.__pending_event
            self.__pending_event = None
            if oldevent != [event.x, event.y]: return True
            x, y = map(int, [event.x, event.y])
            try: path, col, cellx, celly = self.get_path_at_pos(x, y)
            except TypeError: return True
            self.set_cursor(path, col, 0)

    def __begin(self, ctx):
        model, paths = self.get_selection().get_selected_rows()
        MAX = 5
        if paths:
            icons = map(self.create_row_drag_icon, paths[:MAX])
            height = (
                sum(map(lambda s: s.get_size()[1], icons))-2*len(icons))+2
            width = max(map(lambda s: s.get_size()[0], icons))
            final = gtk.gdk.Pixmap(icons[0], width, height)
            gc = gtk.gdk.GC(final)
            gc.copy(self.style.fg_gc[gtk.STATE_NORMAL])
            gc.set_colormap(self.window.get_colormap())
            count_y = 1
            for icon in icons:
                w, h = icon.get_size()
                final.draw_drawable(gc, icon, 1, 1, 1, count_y, w-2, h-2)
                count_y += h - 2
            if len(paths) > MAX:
                count_y -= h - 2
                bgc = gtk.gdk.GC(final)
                bgc.copy(self.style.base_gc[gtk.STATE_NORMAL])
                final.draw_rectangle(bgc, True, 1, count_y, w-2, h-2)
                more = _("and %d more...") % (len(paths) - MAX + 1)
                layout = self.create_pango_layout(more)
                attrs = pango.AttrList()
                attrs.insert(pango.AttrStyle(pango.STYLE_ITALIC, 0, len(more)))
                layout.set_attributes(attrs)
                layout.set_width(pango.SCALE * (w - 2))
                lw, lh = layout.get_pixel_size()
                final.draw_layout(gc, (w-lw)//2, count_y + (h-lh)//2, layout)

            final.draw_rectangle(gc, False, 0, 0, width-1, height-1)
            self.drag_source_set_icon(final.get_colormap(), final)
        else:
            gobject.idle_add(ctx.drag_abort, gtk.get_current_event_time())
            self.drag_source_set_icon_stock(gtk.STOCK_MISSING_IMAGE)


class PopupSlider(gtk.EventBox):
    # Based on the Rhythmbox volume control button; thanks to Colin Walters,
    # Richard Hult, Michael Fulbright, Miguel de Icaza, and Federico Mena.

    def __init__(self, child=None, adj=None, req=None):
        gtk.EventBox.__init__(self)
        button = gtk.Button()
        #button = self.player.button.btn_volume

        if child: button.add(child)
        self.add(button)
        button.connect('clicked', self.__clicked)
        self.show_all()

        window = self.__window = gtk.Window(gtk.WINDOW_POPUP)
        self.__adj = adj or self._adj

        frame = gtk.Frame()
        frame.set_border_width(0)
        frame.set_shadow_type(gtk.SHADOW_OUT)

        hscale = self.Scale(self.__adj)
        hscale.set_size_request(*(req or self._req))
        window.connect('button-press-event', self.__button)
        hscale.connect('key-press-event', self.__key)
        hscale.set_draw_value(False)
        hscale.set_update_policy(gtk.UPDATE_CONTINUOUS)
        self.scale = hscale
        window.add(frame)
        frame.add(hscale)
        self.connect('scroll-event', self.__scroll, hscale)
        self.__window.connect('scroll-event', self.__window_scroll)
        self.scale.connect_object('scroll-event', self.emit, 'scroll-event')

    def __window_scroll(self, window, event):
        self.emit('scroll-event', event)

    def _move_to(self, x, y, w, h, ww, wh, pad=3):
        raise NotImplementedError


    def __clicked(self, button):
        if self.__window.get_property('visible'): return
        self.__window.child.show_all()
        req = self.__window.size_request()
        x, y = self.child.window.get_origin()
        w, h = self.child.window.get_size()
        ww, wh = self.__window.child.parent.get_size()
        sx, sy = self._move_to(x, y, w, h, ww, wh, pad=3)
        self.__window.move(sx, sy)
        self.__window.show()
        self.__window.grab_focus()
        self.__window.grab_add()
        pointer = gtk.gdk.pointer_grab(
            self.__window.window, True,
            gtk.gdk.BUTTON_PRESS_MASK |
            gtk.gdk.BUTTON_RELEASE_MASK |
            gtk.gdk.BUTTON_MOTION_MASK |
            gtk.gdk.POINTER_MOTION_MASK |
            gtk.gdk.SCROLL_MASK, None, None, gtk.get_current_event_time())
        keyboard = gtk.gdk.keyboard_grab(
            self.__window.window, True, gtk.get_current_event_time())

        if pointer != gtk.gdk.GRAB_SUCCESS or keyboard != gtk.gdk.GRAB_SUCCESS:
            self.__window.grab_remove()
            self.__window.hide()

            if pointer == gtk.gdk.GRAB_SUCCESS:
                gtk.gdk.pointer_ungrab(gtk.get_current_event_time())
            if keyboard == gtk.gdk.GRAB_SUCCESS:
                gtk.gdk.keyboark_ungrab(gtk.get_current_event_time())

    def __scroll(self, widget, ev, hscale):
        adj = self.__adj
        v = hscale.get_value()
        if ev.direction in self.UP: v += adj.step_increment
        else: v -= adj.step_increment
        v = min(adj.upper, max(adj.lower, v))
        hscale.set_value(v)

    def __button(self, widget, ev):
        self.__popup_hide()

    def __key(self, hscale, ev):
        if ev.string in ["\n", "\r", " ", "\x1b"]: # enter, space, escape
            self.__popup_hide()

    def __popup_hide(self):
        self.__window.grab_remove()
        gtk.gdk.pointer_ungrab(gtk.get_current_event_time())
        gtk.gdk.keyboard_ungrab(gtk.get_current_event_time())
        self.__window.hide()
class PopupVSlider(PopupSlider):
    Scale = gtk.VScale
    _req = (-1, 170)
    _adj = gtk.Adjustment(0, 0, 1, 0.05, 0.1, 0)
    UP = [gtk.gdk.SCROLL_UP, gtk.gdk.SCROLL_LEFT]

    def _move_to(self, x, y, w, h, ww, wh, pad=3):
        return ((x + (w - ww)//2), y + h + pad)

class VolumeSlider(PopupVSlider):
        def __init__(self,gst_player):
            i = gtk.image_new_from_icon_name(
               "stock_volume-max", gtk.ICON_SIZE_LARGE_TOOLBAR)
            PopupVSlider.__init__(self, i)
            self.scale.set_update_policy(gtk.UPDATE_CONTINUOUS)

            self.scale.connect('value-changed', self.__volume_changed,gst_player)
            self.scale.set_inverted(True)
            self.scale.set_range(0,1)
            self.get_value = self.scale.get_value
            self.set_value = self.scale.set_value
            volume = float(config.get("player","volume"))
            self.set_value(volume)
            self.__volume_changed(self.scale,gst_player)
            self.show_all()


        def __volume_changed(self, slider,gst_player):
            val = slider.get_value()
            if val > 0.66 : img = "stock_volume-max"
            elif val > 0.33: img = "stock_volume-med"
            elif val > 0: img = "stock_volume-min"
            else: img = "stock_volume-mute"

            self.child.child.set_from_icon_name(img, gtk.ICON_SIZE_LARGE_TOOLBAR)
            val = (2 ** val) - 1
            config.set("player","volume","%f"%val)
            gst_player.volume = val

