###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###
# Based on quolibet code for read/write metadata
#   (C) Copyright 2004-2005 Joe Wreschnig, Michael Urman
###

import gst
from song import READ_EXTENTIONS,WRITE_EXTENTIONS

def read(song):
    IDS = {
        "title": "title",
        "artist": "artist",
        "album": "album",
        "tracknumber": "tracknr",
        "genre": "genre",
        "date": "date",
    }
    SDI = dict([(v, k) for k, v in IDS.iteritems()])
    f = ogg.vorbis.VorbisFile(song.get_path())

    for key, value in f.comment().as_dict().iteritems():
        if IDS.has_key(key.lower()):
            if value != None:
                song.set_property(IDS[key.lower()],unicode(value[len(value)-1]).encode("utf-8"))

    song.set_property("bitrate",f.bitrate(-1))
    duration = f.time_total(-1)*1000
    duration = "%d"%duration
    try: duration = duration[duration.rindex(".")+1:]
    except : pass
    song.set_property("duration",int(duration))


def write(song):
    IDS = {
        "title": "title",
        "artist": "artist",
        "album": "album",
        "tracknumber": "tracknr",
        'genre':"genre",
        "date": "date"
    }
    SDI = dict([(v, k) for k, v in IDS.iteritems()])
    f = ogg.vorbis.VorbisFile(song.get_path())
    comments = f.comment()
    #comments.clear()
    for key,value in IDS.iteritems():
        value = song.sprint(value)
        del comments[key]
        if value!="":
            comments[key] = value

    comments.write_to(song.get_path())

try: import ogg.vorbis
except ImportError: pass
else:
    try: gst.element_factory_make('vorbisdec')
    except:pass
    else:
        WRITE_EXTENTIONS[".ogg"]= write
        READ_EXTENTIONS[".ogg"]= read

