## $Id: rules.mk,v 1.40 2002/02/10 20:35:34 flacoste Exp $

## Copyright (C) 2000-2001 Stichting LogReport Foundation LogReport@LogReport.org
## 
##     This program is free software; you can redistribute it and/or modify
##     it under the terms of the GNU General Public License as published by
##     the Free Software Foundation; either version 2 of the License, or
##     (at your option) any later version.
## 
##     This program is distributed in the hope that it will be useful,
##     but WITHOUT ANY WARRANTY; without even the implied warranty of
##     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##     GNU General Public License for more details.
## 
##     You should have received a copy of the GNU General Public License
##     along with this program (see COPYING); if not, check with
##     http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
##     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

XML_DCL=$(top_srcdir)/all/lib/xml/xml.dcl

## Old suffix rules are portable between GNU make 
## and non GNU make
SUFFIXES = .pod .1 .pm .3pm .dbx .xml .dia .eps

.pm.3pm:
	$(PERL2MAN_RULE)

.pod.1:
	$(PERL2MAN_RULE)

.dia.eps:
	$(DIA2EPS_RULE)

# This is still an unsettle issue. 
#.dbx.1:
#	$(XML2MAN_RULE)

##
## there are different "solutions" on how to create man files for perl modules,
## containing :: in the filename. 
## take a look at gelfand:/usr/local/src/MailTools/MailTools-1.15/Makefile 's 
## manifypods target.
## or see Message-ID: <14876.5087.303743.313283@lemming.engeast.baynetworks.com>
## on the GNU help-make mailing list.
##
## we can't use $< here to indicate the dependency, since some makes (e.g.
## /usr/ccs/bin/make as shipped with sparc-sun-solaris2.7) don't grok that.
## duh.
##
PERL2MAN_RULE = \
	pod2man --center='$(PACKAGE)' --release='$(VERSION)' $? > $@

# uses the docbook-to-man program. Debian: see docbook-to-man package.
# XML2MAN_RULE = for f in $(docbooks); \
#  do \
#   man="`echo $$f | sed 's/\..*$$//'`.$(section)"; \
#   docbook2manxml $$f | man_xml > $$man; \
#  done

# restored to use docbook2man: don't feel like searching for and installing
# new dcbk tools now.  JvB
XML2MAN_RULE = \
	docbook2man $< > $@

CHECK_XML_RULE = for f in $^; \
 do \
  echo -n Checking $$f...; \
  $(PATHTONSGMLS) -s $(XML_DCL) $(srcdir)/$$f && echo ok; \
 done

XML2HTML_RULE = \
	mysrc=`cd $(srcdir) && pwd`; \
	mytop=`cd $(top_srcdir) && pwd`; \
	outdir=`dirname $@`; \
	src=$$mysrc/`basename $<`; \
	$(mkinstalldirs) $$outdir && \
	cd $$outdir && \
	rm -f * && \
	epss=`for i in $^; do echo $$i; done | grep '\.eps$$'`; \
	for i in $$epss; do \
	    png=`basename $$i .eps`.png; \
	    $(PATHTOEPSFFIT) 0 0 576 576 $$mysrc/$$i > tmp.eps; \
	    $(PATHTOCONVERT) tmp.eps $$png; \
	    rm -f tmp.eps; \
	done; \
	pngs=`for i in $^; do echo $$i; done | grep '\.png$$'`; \
	for i in $$pngs; do cp $$mytop/$$i .; done; \
	sh $$mytop/all/script/lr_xslt -c $$mytop/all/etc/defaults $(PATHTODBKXSLHTML) $$src 'graphic.default.extension="png"'

HTML2TXT_RULE = \
sh $(top_srcdir)/all/script/lr_xslt -c $(top_srcdir)/all/etc/defaults $(PATHTODBKXSLHTMLNOCHUNK) $< > tmp.html && \
$(PATHTOLYNX) -nolist -dump tmp.html > $@ && \
rm tmp.html

## we need to run pdfjadetex three times gets pagenumbers in toc right
XML2PDF_RULE = \
	base=`basename $@ .pdf`; \
	epss=`for i in $^; do echo $$i; done | grep '\.eps$$'`; \
	pdfs=""; \
	for i in $$epss; do \
	    pdf=`basename $$i .eps`.pdf; \
	    $(PATHTOEPSFFIT) 0 0 468 468 $$i > tmp.eps; \
	    $(PATHTOEPSTOPDF) --outfile=$$pdf tmp.eps; \
	    pdfs="$$pdfs $$pdf"; \
	    rm -f tmp.eps; \
	done; \
	$(PATHTOJADE) -t tex -d $(PATHTODBKDSSSLPRINT) $(XML_DCL) $< && \
	$(PATHTOPDFJADETEX) $$base >/dev/null && \
	$(PATHTOPDFJADETEX) $$base >/dev/null && \
	$(PATHTOPDFJADETEX) $$base >/dev/null && \
	rm -f $$base.log $$base.out $$base.aux $$base.tex $$pdfs

REPORTS_INFOS_RULE = \
sh $(top_srcdir)/all/script/lr_xslt -c $(top_srcdir)/all/etc/defaults $(top_srcdir)/all/lib/xml/stylesheet/xsl/convert_reportspec2docbook.xsl $< 'superservice="$(superservice)"' 'spec-files="$^"' "specdir='`pwd`'" > $@

DIA2EPS_RULE = \
	$(PATHTODIA) --nosplash -e $@ $<
