package Lire::WWW::UserAgent::OS;
#
# $Id: OS.pm,v 1.9 2002/01/19 18:20:06 vanbaal Exp $
#
# The data in this module is taken from AWStats. (http://awstats.sf.net/)
# Rewritten by Egon Willighagen for LogReport.org (http://logreport.org/)
#
# Copyright (C) 2000, 2001 Laurent Destailleur <eldy@users.sourceforge.net>
#
#     This file is part of Lire.
#
#     Lire is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program (see COPYING); if not, check with
#     http://www.gnu.org/copyleft/gpl.html or write to the Free Software
#     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
#
use strict;
use vars qw/ $REVISION/;

BEGIN {
    $REVISION  = '$Id: OS.pm,v 1.9 2002/01/19 18:20:06 vanbaal Exp $';
}

# -----------------------------------------------------------------------------
# Database
# -----------------------------------------------------------------------------

my %OSHash = (
# Windows family OS
"winme" => "Windows Me",
"win2000" => "Windows 2000",
"winnt" => "Windows NT",
"win98" => "Windows 98",
"win95" => "Windows 95",
"win16" => "Windows 3.xx",
"wince" => "Windows CE",
# Other famous OS
"beos" => "BeOS",
"mac" => "Mac OS",
"os/2" => "Warp OS/2",
"amigaos" => "AmigaOS",
# Unix like OS
"unix" => "Unknown Unix system",
"linux" => "GNU/Linux",
"aix" => "Aix",
"sunos" => "Sun Solaris",
"irix" => "Irix",
"osf" => "OSF Unix",
"hp-ux" => "HP Unix",
"netbsd" => "NetBSD",
"bsdi" => "BSDi",
"freebsd" => "FreeBSD",
"openbsd" => "OpenBSD",
"gnu/hurd" => "GNU/Hurd",
# Miscellanous OS
"webtv" => "WebTV",
"cp/m" => "CP/M",
"crayos" => "CrayOS",
"riscos" => "Acorn RISC OS",
"openvms" => "OpenVMS"
);

my %OSAliasHash = (
#"windows_me" => "winme",
#"windows_2000" => "win2000",
#"windows_nt_5" => "win2000",
#"windows_nt" => "winnt",
#"windows-nt" => "winnt",
"win32" => "winnt",
#"windows_98" => "win98",
#"windows_95" => "win95",
#"windows_31" => "win16",
#"windows_3.1" => "win16",
"windows;i;16" => "win16",
#"windows_ce" => "wince",
#"mac_ppc" => "macintosh",
#"mac_powerpc" => "macintosh",
#"mac_6800" => "macintosh",
#"mac_68k", "macintosh",
#"macppc" => "macintosh",
#"macweb" => "macintosh"
);

my %CompiledOSHash	= map { $_ => qr/$_/; } keys %OSHash;
my %CompiledOSAliasHash = map { $_ => qr/$_/; } keys %OSAliasHash;

# -----------------------------------------------------------------------------
# Functions
# -----------------------------------------------------------------------------

sub getOS {
    my ($ua) = @_;
    my $rs1;
    my $rs2;

    if ($ua=~/win/im) {
        ($rs1,$rs2) = $ua =~ /(win[a-z]+)[_|-]+([  [0-9a-z] | \d ]+)[_|\s|\W]*/im;
        return ucfirst($rs1).' '.uc($rs2) if defined($rs2);
        # OSAliasHash list ?
        foreach my $key (keys %OSAliasHash) {
            my $re = $CompiledOSAliasHash{$key};
            if ($ua =~ /$re/) {
                return $OSHash{$OSAliasHash{$key}};
            }
        }
    }
    # OSHash list ?
    foreach my $key (keys %OSHash) {
	#my $re = $CompiledOSHash{$key};
	if ($ua =~ /$key/im) {
            return $OSHash{$key};
	}
    }

    return undef;
}

1;

