package Lire::WWW::UserAgent::Language;
#
# $Id: Language.pm,v 1.4 2002/01/19 18:20:06 vanbaal Exp $
#
# Copyright (C) 2001 Stichting Logreport Foundation <logreport@logreport.org>
#
#     This file is part of Lire.
#
#     Lire is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program (see COPYING); if not, check with
#     http://www.gnu.org/copyleft/gpl.html or write to the Free Software
#     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
#
use strict;
use vars qw/ $REVISION/;

BEGIN {
    $REVISION  = '$Id: Language.pm,v 1.4 2002/01/19 18:20:06 vanbaal Exp $';
}

# -----------------------------------------------------------------------------
# Database
# -----------------------------------------------------------------------------

# According to ISO 639

my %LanguageHash = (
"en"	=> "English",
"en-us" => "English (American)",
"en-gb" => "English (British)",
"nl"	=> "Dutch",
"de"	=> "German",
"fr"	=> "French",
"fr-ca" => "French",
"es"	=> "Spanish",
"es-mx"	=> "Spanish",
"es-es"	=> "Spanish",
"ca"	=> "Catalan",
"pt"	=> "Portuguese",
"pt-pt"	=> "Portuguese",
"it"    => "Italian",
"sv"    => "Swedish",
"af"    => "Afrikaans",
"ar"    => "Arabic",
"zh"    => "Chinese",
"da"    => "Danish",
"cs"    => "Czech",
"eo"    => "Esperanto",
"fy"    => "Frisian",
"el"    => "Greek",
"he"    => "Hebrew",
"is"    => "Icelandic",
"ja"    => "Japanese",
"no"    => "Norwegian",
"ru"    => "Russian",
"cy"    => "Welsh",
"pl"    => "Polish",
);

my %CompiledHash = map { $_ => qr/$_\;/; } keys %LanguageHash;

# -----------------------------------------------------------------------------
# Functions
# -----------------------------------------------------------------------------

sub getLanguage {
    my ( $ua ) = @_;

    # OSHash list ?
    foreach my $key (keys %LanguageHash) {
	my $re = $CompiledHash{$key};
        if ($ua =~ /$re/) {
            return $LanguageHash{$key};
        }
    }
    return undef;
}

1;

