package Lire::FilterSpec;

use strict;

use vars qw( $VERSION @ISA );

use Lire::Config;
use Lire::DataTypes qw( :special );
use Lire::XMLSpecContainer;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.6 $' =~ m!Revision: ([.\d]+)!;

    @ISA = qw/Lire::XMLSpecContainer/;
}

########################################################################
#			 Lire::XMLSpecContainer METHODS
########################################################################

sub root_element {
    my ( $self ) = @_;

    return "global-filter-spec";
}

sub file_from_id {
    my ( $self, $super, $id ) = @_;

    return "$Lire::Config::filterdir/$super/$id.xml";
}

sub print_children {
    my ( $self, $fh, $indent ) = @_;

    my $pfx = ' ' x $indent;
    print $fh "$pfx<lire:filter-spec>\n";
    $self->{filter_spec}->print( $fh, $indent + 1);
    print $fh "\n$pfx</lire:filter-spec>\n\n";
}

########################################################################
#			 Lire::GlobalFilterSpec METHODS
########################################################################

sub filter_spec {
    my ( $self, $filter_spec ) = @_;

    if ( @_ == 2 ) {
	croak "filter specification must be of type Lire::FilterExpr"
	  unless UNIVERSAL::isa( $filter_spec, "Lire::FilterExpr" );
	$self->{filter_spec} = $filter_spec;
    }

    $self->{filter_spec};
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::FilterSpec - 

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: FilterSpec.pm,v 1.6 2002/01/16 21:47:16 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
