package tests::DocBookParserTest;

use strict;

use base qw/Lire::Test::TestCase /;

use Lire::DocBookParser;

sub new {
    my $self =  shift->SUPER::new( @_ );

    $self->{'parser'} = new Lire::DocBookParser();
    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub test_parse_para {
    my $self = $_[0];

    my $dbk = "<para>This is multi-line\n\ttest.</para>";
    $self->assert_str_equals( $dbk, $self->{'parser'}->parse( $dbk ) );
}

sub test_parse_variablelist {
    my $self = $_[0];

    my $dbk = <<EOD;
<para>
  <variablelist>
    <title>A title</title>
    <varlistentry>
      <term>A term</term>
      <term><acronym>A.T.E.R.M</acronym></term>
      <listitem>
        <para>A definition.</para>
        <para>With more explanation.</para>
      </listitem>
    </varlistentry>
  </variablelist>
</para>
EOD
    chomp $dbk;
    $self->assert_str_equals( $dbk, $self->{'parser'}->parse( $dbk ) );
}

sub test_parse_warning {
    my $self = $_[0];
    my $dbk = <<EOD;
<para>
  <warning>
    <title>These are the <emphasis>real</emphasis> warnings</title>
    <itemizedlist>
      <listitem><para>First warning.</para></listitem>
      <listitem><para>Second warning.</para></listitem>
    </itemizedlist>
    <para><tip><para>You can ignore the warning.</para></tip></para>
  </warning>
</para>
EOD
    chomp $dbk;
    $self->assert_str_equals( $dbk, $self->{'parser'}->parse( $dbk ) );

}

1;
