package tests::LrMissingCasesTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::SQLExt::LrMissingCases;

sub set_up {
    my $self = shift()->SUPER::set_up();

    $self->{'lr_missing_cases'} = new Lire::SQLExt::LrMissingCases();

    return;
}

sub tear_down {
    my $self = $_[0];

    $self->SUPER::tear_down();

    return;
}

sub test_lr_missing_cases {
    my $self = $_[0];

    my $mc = $self->{'lr_missing_cases'};
    $self->assert_equals( 0, $mc->{'_count'} );

    $mc->step( undef );
    $self->assert_equals( 1, $mc->{'_count'} );
    $mc->step( 'a' );
    $self->assert_equals( 1, $mc->{'_count'} );
    $mc->step( 'a', undef, 'b', 1, undef );
    $self->assert_equals( 2, $mc->{'_count'} );

    $self->assert_equals( 2, $mc->finalize() );
}

1;
