package tests::UIWidgetTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::Config::TypeSpec;
use Lire::Config::Value;

use Curses::UI;

use Lire::UI::Widget;
use Lire::Test::CursesUIDriver;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    $self->set_up_fake_config();

    return;
}

sub set_up_fake_config {
    my $self = $_[0];

    my $spec = new Lire::Config::ConfigSpec( 'name' => 'lire' );
    $spec->add( new Lire::Config::StringSpec( 'name' => 'test',
                                              'section' => 'programs',
                                              'summary' => 'Test Summary',
                                              'description' => '<para>Test Description</para>' ) );
    $spec->add( new Lire::Config::StringSpec( 'name' => 'another_prog',
                                              'section' => 'programs' ) );
    $self->{'spec'} = $spec;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    my $win = $self->{'window'};
    $self->assert_dies( qr/missing 'value' parameter/,
                        sub { my $widget = $win->add( 'test_widget',
                                                    'Lire::UI::Widget' ) } );
    $self->assert_dies( qr/'value' parameter should be a 'Lire::Config::Value' instance, not 'HASH/,
                        sub { my $widget = $win->add( 'test_widget',
                                                      'Lire::UI::Widget',
                                                      'value' => {} ) } );

    $self->assert_dies( qr/no widget type defined for values of type 'Lire::Config::ConfigSpec'/,
                        sub { my $widget = $win->add( 'test_widget',
                                                      'Lire::UI::Widget',
                                                      'Value' => $self->{'spec'}->instance() ) });

    my $widget = $win->add( 'test_widget', 'Lire::UI::Widget',
                            'value' => $self->{'spec'}->get( 'another_prog' )->instance() );
    $self->assert_isa( 'Lire::UI::StringWidget', $widget );

    return;
}

1;
