package tests::UICompoundListWidgetTest;

use strict;

use base qw/ tests::UIListWidgetTest /;

use Lire::UI::CompoundListWidget;
use Lire::UI;
use Lire::Test::Mock;

sub test_new {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'list_widget', 'Lire::UI::ListWidget',
                                         'value' => $self->{'comp_value'} );
    $self->assert_isa( 'Lire::UI::CompoundListWidget', $widget );

    my $buttons = $widget->getobj( 'buttons' );
    $self->assert_isa( 'Curses::UI::Buttonbox', $buttons );
    $self->assert_str_equals( '[Edit]', $buttons->{'-buttons'}[1]{'-label'} );
    $self->assert_isa( 'CODE', $buttons->{'-buttons'}[1]{'-onpress'} );

    my $values_list = $widget->getobj( 'list' );
    $self->assert_num_equals( 2, scalar @{$values_list->{'-values'}} );
    $self->assert_deep_equals( [ 'compvalue1', 'compvalue2' ],
                               [ map { $values_list->{'-labels'}{$_} } @{$values_list->{'-values'}} ] );
}

sub test_new_value {
    my $self = $_[0];

    my $driver = $self->{'driver'};
    my $widget = $self->{'window'}->add( 'list_widget', 'Lire::UI::ListWidget',
                                         'value' => $self->{'comp_value'} );

    my $mock_ui = new Lire::Test::Mock( 'Lire::UI', 'edit_value_dialog' => 0 );
    $widget->root()->userdata( $mock_ui );
    $self->assert_null( $widget->new_value(), 'new_value() != undef' );

    $mock_ui->set_result( 'edit_value_dialog', 1 );
    my $value = $widget->new_value();
    $self->assert_isa( 'Lire::Config::Dictionary', $value );
    $self->assert_str_equals( $widget->{'component'}, $value->spec() );
}

sub test_edit_element {
    my $self = $_[0];

    my $called = 'onvaluechanged not called';
    my $driver = $self->{'driver'};
    my $widget = $self->{'window'}->add( 'list_widget', 'Lire::UI::ListWidget',
                                         'value' => $self->{'comp_value'},
                                         'onvaluechanged' => sub { $called = 'called' } );


    my $values_list = $widget->getobj( 'list' );

    $values_list->{'-selected'} = 1;
    my $or_value = $values_list->{'-values'}[1];

    my $mock_ui = new Lire::Test::Mock( 'Lire::UI', 'edit_value_dialog' => 0 );
    $widget->root()->userdata( $mock_ui );
    $widget->do_routine( 'edit-element' );
    $self->assert_str_equals( $or_value, $values_list->{'-values'}[1] );
    $self->assert_str_equals( 'onvaluechanged not called', $called );

    $mock_ui->set_result( 'edit_value_dialog', 1 );
    $widget->do_routine( 'edit-element' );
    $self->assert_str_not_equals( $or_value, $values_list->{'-values'}[1] );
    $self->assert_str_equals( 'called', $called );
}

1;
