package tests::OutputFormatsExcel95Test;

use strict;

use base qw/Lire::Test::PluginTestCase/;

use Lire::OutputFormats::Excel95;
use Lire::PluginManager;
use Lire::Utils qw/tempdir create_file/;
use File::Basename qw/dirname/;
use File::Path qw/rmtree /;
use Lire::Test::Mock;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'testdir'} = dirname( __FILE__ ) ;
    $self->{'tmpdir'} = tempdir( $self->name() . '_XXXXXX' );
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    Lire::Test::Mock->reset_factories();
    rmtree( $self->{'tmpdir'} );

    return;
}

sub create_plugin {
    return new Lire::OutputFormats::Excel95();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../Lire/OutputFormats/of_excel95_init";
}

sub test_format_report {
    my $self = $_[0];

    $self->test_registration_file();
    Lire::Test::Mock->set_mock_factory( 'Lire::ReportParser::ExcelWriter',
                                        'parsefile' => sub { create_file( shift->{'_output_file'} ) } );
    my $excel95 = Lire::PluginManager->get_plugin( 'output_format', 'excel95');
    my $report = "$self->{'tmpdir'}/report.xls";
    $excel95->format_report( "$self->{'testdir'}/data/test-sqlite.xml",
                             $report );
    my ($writer) = @{Lire::Test::Mock->mock_instances( 'Lire::ReportParser::ExcelWriter' )};
    my ( $pkg, %args ) = @{$writer->get_invocation( 'new' )};
    $self->assert_str_equals( $report, $args{'output_file'} );
    $self->assert_num_equals( 1, $writer->invocation_count( 'parsefile' ) );
}

sub test_mime_report {
   my $self = $_[0];

   $self->test_registration_file();
   Lire::Test::Mock->set_mock_factory( 'Lire::ReportParser::ExcelWriter',
                                       'parsefile' => sub { create_file( shift->{'_output_file'} ) } );
   my $excel95 = Lire::PluginManager->get_plugin( 'output_format', 'excel95' );

   my $entity = $excel95->mime_report( "$self->{'testdir'}/data/test-sqlite.xml" );
   $self->assert_isa( 'MIME::Entity', $entity );
   $self->assert_str_equals( 'application/vnd.ms-excel',
                             $entity->head()->mime_type() );
   $self->assert_str_equals( "base64\n",
                             $entity->head()->get( 'content-transfer-encoding' ) );
}

1;
