package Lire::SQLExt::LrRangegroup;

use strict;

use POSIX qw/floor ceil/;

sub lr_rangegroup {
    my ( $v, $start, $length, $min, $max ) = @_;

    return undef unless defined $v && defined $start && defined $length;

    $v = $min if defined $min && $v < $min;
    $v = $max if defined $max && $v > $max;

    return floor( ($v - $start) / $length ) * $length + $start;
}

sub lr_rangegroup_geo {
    my ( $v, $start, $length, $base, $min, $max ) = @_;

    return undef unless ( defined $v && defined $start 
                          && defined $length && defined $base );

    $v = $min if defined $min && $v < $min;
    $v = $max if defined $max && $v > $max;

    return undef if $v < $start;

    my $range_start = $start;
    while ( $v < $range_start || $v >= ( $range_start + $length ) ) {
        $range_start += $length;
        $length *= $base;
    }

    return $range_start;
}

# keep perl high
1;

=pod

=head1 NAME

Lire::SQLExt::LrRangegroup - FILL ME IN

=head1 SYNOPSIS

  FILL ME IN

=head1 DESCRIPTION

  FILL ME IN

=head1 SEE ALSO

Lire::DlfConverter(3pm)

=head1 VERSION

Id: LrRangegroup.pm,v 1.3 2003/10/14 12:59:55 wsourdeau Exp $

=head1 AUTHOR

  Francis J. Lacoste <flacoste@logreport.org>
  Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2003 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut

