/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* nom           : init.c                                           */
/* contenu       : installation d'allegro                           */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "config.h"
#include "gfxmode.h"
#include "init.h"
#include "joystick.h"
#include "log.h"
#include "startup.h"
#include "ticker.h"
#include "sockgen.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
void display_success (int success)
{
  if (success)
    log_println_str (" - success!");
  else
    log_println_str (" - failed...");  
  log_flush();
  /* delay (100);*/
}

/*------------------------------------------------------------------*/
void display_success_driver (int success, char *driver)
{
  if (success)
    {
      log_print_str(" (driver=\"");
      log_print_str(driver);
      log_println_str ("\") - success!");
    }
  else
    log_println_str (" - failed...");  
  log_flush();
  /* delay (100);*/
}

/*------------------------------------------------------------------*/
int init_all ()
{
  int result=0;
  int config=1,timer=1,keyboard=1,mouse=1,sound=1,joystick=1,network=1;

  set_startup();

  log_init();

  allegro_init ();
#ifdef ALLEGRO_DOS
  set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
#endif
  log_println_str ("Starting Allegro (http://www.talula.demon.co.uk/allegro)");
  log_println();
  log_print_str("Allegro ID : ");
  log_println_str(allegro_id);
  log_println();
 
  log_print_str("Loading config options from \"");
  log_print_str(STARTUP_CFG_PATH);
  log_print_str("\"");
 
  display_success (config=load_config_options());

  log_print_str("Installing timer");

  display_success_driver (timer=!install_timer (),
			  (char *) timer_driver->ascii_name);

  start_ticker();

  log_print_str ("Installing keyboard");
  display_success_driver (keyboard=!install_keyboard (),
			  (char *) keyboard_driver->ascii_name);

  log_print_str ("Installing mouse");
  display_success_driver (mouse=install_mouse () != -1,
			  (char *) mouse_driver->ascii_name);

  if (STARTUP_DIGI_CARD != DIGI_NONE || STARTUP_MIDI_CARD != MIDI_NONE)
    {
      log_print_str ("Installing sound");
      sound=!install_sound(STARTUP_DIGI_CARD,STARTUP_MIDI_CARD,"");
      if (sound) 
	{
	  log_print_str(" (digi=\"");
	  log_print_str((char *) digi_driver->ascii_name);
	  log_print_str("\", midi=\"");
	  log_print_str((char *) midi_driver->ascii_name);
	  log_print_str("\")");
	} 
      display_success(sound);
    }

  if (STARTUP_JOYSTICK_ON)
    {
      log_print_str ("Installing joystick");
      if (STARTUP_JOYSTICK_ON)
	display_success_driver (joystick=!my_initialise_joystick (),
				(char *) joystick_driver->ascii_name);
    }

  log_print_str("Setting up network");
  display_success(network=lw_sock_init());

  set_color_conversion (COLORCONV_TOTAL);
  
  result= timer&&keyboard&&mouse
    &&(sound||!STARTUP_CHECK)
    &&(joystick||!STARTUP_CHECK);

  return (result);
}

/*------------------------------------------------------------------*/
int start_graphic (void)
{
  int retour;

  retour= (!set_resolution (CONFIG_GFX_MENU,0,CONFIG_FULLSCREEN));

  return retour;
}



  
