#ifndef wuftpd_h
#define wuftpd_h
#ifndef MISC_H
    #include <misc.h>
#endif
#ifndef MODULE_H
    #include <module.h>
#endif

#include <modapi_def.h>
#include <modapi.h>
class MODULE_wuftpd: public LINUXCONF_MODULE{
    /*~PROTOBEG~ MODULE_wuftpd */
public:
	MODULE_wuftpd (void);
	int dohtml (const char *);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int execmain (int argc, char *argv[], bool);
	void setmenu (DIALOG&dia, MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
    /*~PROTOEND~ MODULE_wuftpd */
};

#include <misc.h>
#include <fviews.h>
#include <fixperm.h>

class VIRTUAL_FTP: public ARRAY_OBJ{
public:
	SSTRING addr;
	SSTRING root;
	VIEWITEM *root_it;		// Remember where it was found in the config
							// file
	SSTRING banner;
	VIEWITEM *banner_it;
	SSTRING logfile;
	VIEWITEM *logfile_it;

	/*~PROTOBEG~ VIRTUAL_FTP */
public:
	VIRTUAL_FTP (const char *_addr);
	VIRTUAL_FTP (void);
	int createroot (void);
	int edit (void);
	void updateone (const SSTRING&val,
		 const char *keyw,
		 VIEWITEM *&item,
		 VIEWITEMS&items);
	/*~PROTOEND~ VIRTUAL_FTP */
};

class VIRTUAL_FTPS: public ARRAY{
	/*~PROTOBEG~ VIRTUAL_FTPS */
public:
	VIRTUAL_FTPS (void);
	void edit (VIEWITEMS&items);
	VIRTUAL_FTP *getitem (int no)const;
	void update (VIEWITEMS&items);
	/*~PROTOEND~ VIRTUAL_FTPS */
};

class FTP_CTRL{
public:
	char f_compress;
	char f_tar;
	char f_chmod;
	char f_delete;
	char f_overwrite;
	char f_rename;
	char f_log_inbound;
	char f_log_outbound;
	/*~PROTOBEG~ FTP_CTRL */
public:
	FTP_CTRL (void);
	void setall (char val);
	/*~PROTOEND~ FTP_CTRL */
};

class WUFTPD {
	VIEWITEMS access;
	VIEWITEMS users;
	VIEWITEMS groups;
	VIEWITEMS hosts;
	FTP_CTRL guest,rreal,anonymous;
	VIRTUAL_FTPS virtuals;
	/*~PROTOBEG~ WUFTPD */
public:
	WUFTPD (void);
	void add (VIRTUAL_FTP *v);
	void del (VIRTUAL_FTP *v);
	void editaccess (void);
	void editvirtuals (void);
	void listperm (FIXPERM_SPECS&specs);
private:
	void load (SSTRING&val,
		 VIEWITEMS&items,
		 const char *key);
	void load (int &val,
		 int defval,
		 VIEWITEMS&items,
		 const char *key1,
		 const char *key2);
	VIEWITEM *locate_alloc (const char *key1,
		 const char *key2);
public:
	VIRTUAL_FTP *locatevhost (const char *vhost);
private:
	void setflags (const char *yes,
		 const char *members,
		 char &f_guest,
		 char &f_real,
		 char &f_anonymous);
	void settransfers (const char *members,
		 const char *type);
	void store (SSTRING&val,
		 VIEWITEMS&items,
		 const char *key);
	void store (int val,
		 int defval,
		 VIEWITEMS&items,
		 const char *key1,
		 const char *key2);
	void updatectrl (const char *oper,
		 char f_guest,
		 char f_real,
		 char f_anonymous);
	void updatetrans (void);
public:
	void viewlogs (void);
	int write (void);
	/*~PROTOEND~ WUFTPD */
};



class USERACCT_COMNG;
class DICTIONARY;

#include "wuftpd.p"

#endif
