
#include <stdio.h>
#include <string.h>
#include <translat.h>

#include <unistd.h>

#include "mouseconf.h"
#include "mouseconf.m"
#include "mouseconf_vars.h"
#include "mouseconf_tools.h"
#include "devicelist.h"

#ifdef XF86_IS_PRESENT
#include "mouseconf_xf86.h"
#endif

#ifdef KUDZU_IS_PRESENT
#include "mousedetect.h"
#endif

#include "fviews.h"

#define load_this_var(a,b) \
        if((my_returned_string=vitems_mouse.locateval(b, my_buff))){ \
            mouse_prefs.a.setfrom(my_returned_string); \
        }else{ \
            mouse_prefs.a.setfrom(""); \
        }

#define save_this_var(a,b) \
        vitems_mouse.update(b, mouse_prefs.a)

/* identifies the corresponding entry (in mouse.list) for
   saved settings */
DEVICE *finds_the_current_one(DEVICELIST &given_devicelist)
{
    DEVICE *return_this;

    /* try to find by description */
    if(!(return_this=given_devicelist.getitem_by_descr(mouse_prefs.description.get()))){
        /* then try to find by driver name */
        if(!(return_this=given_devicelist.getitem_by_opt("gident", mouse_prefs.mousetype.get()))){

            /* try another way to find this entry */
            /* NOT IMPLEMENTED YET */

        }
    }
    return(return_this);
}

/* same as sleep() but with progress bar */
/* (ok, i know this funtion's label sounds obscene..) */
void sleep_with_progress_bar(const char *given_title, const char *given_text, const char *given_text_2, int given_seconds)
{
    DIALOG dia_detection;
    int    detection_progress=0;
    int    my_nothing=0;

//    dia_detection.setbutinfo(MENU_USR1, "End test", "End test");

    /* opens detection progress window */
    dia_detection.settype(DIATYPE_POPUP);
    dia_detection.newf_gauge(given_text, detection_progress, given_seconds);

//    dia_detection.new_menuitem("", "Ends test");

    dia_detection.show(given_title, given_text_2, help_nil, my_nothing, 0);
    diagui_flush();

    while(detection_progress<given_seconds){
//        printf("my_nothing: [%d]\n", my_nothing);
//        printf("was modif: [%d]\n", dia_detection.was_modified());
        dia_detection.reload();
        /* show() is needed to refresh textmode */
        dia_detection.show(given_title, given_text_2, help_nil, my_nothing, 0);
        /* flush() is needed to refresh GUI mode */
        diagui_flush();
        sleep(1);
        detection_progress++;
    }
}

/* load mouse_prefs with the previously saved values */
void load_mouse_settings(void)
{
    char my_buff[1000];

    /* picks link in /dev/mouse */
    {
        SSTRING tempstr;

        bzero(my_buff, 1000);
        readlink(MOUSELINK_PATH, my_buff, 999);
        if(my_buff[0]!='/'){
            mouse_prefs.mousedevice.setfromf("/dev/%s", my_buff);
        }else{
            mouse_prefs.mousedevice.setfrom(my_buff);
        }
    }

    /* load vars from /etc/sysconfig/mouse */
    {
        const char *my_returned_string;
        VIEWITEMS_PARSER pre_vitems_mouse;
        VIEWITEMS vitems_mouse(pre_vitems_mouse);
        vitems_mouse.read(cf_scmouse); // load file data

        load_this_var(mousetype,"MOUSETYPE");
        if(!(*(mouse_prefs.mousetype.get())))
            mouse_prefs.mousetype.setfrom("none");
        load_this_var(xmousetype,"MOUSETYPE");
        load_this_var(description,"FULLNAME");
        load_this_var(xemu3,"XEMU3");
        if(!strcasecmp(mouse_prefs.xemu3.get(), "yes")){
            mouse_prefs.emulate3but=1;
        }else{
            mouse_prefs.emulate3but=0;
        }
    }

#ifdef XF86_IS_PRESENT
    /* load extra vars from XF86Config
     (the other ones, present in /etc/sysconfig/mouse are ignored) */
    if(mouse_system.XF_exists)
        reads_xf86_config();
#endif

    adjust_vars();
}

/* fills feed_me with matches from given_dir/given_match */
void to_sstrings_matching_files(SSTRINGS &feed_me, const char *given_dir, const char *given_match)
{
    SSTRING prefix_to_add;
    SSTRING my_dir, my_match, middle_part;
    SSTRINGS my_filelist;

    my_dir.setfrom(given_dir);
    my_match.setfrom(given_match);
    middle_part.setfrom("");

    /* this reorganize the match and dir names when the match points to a directory */
    /* warning: this routine is not very smart, does not support more than one
     directory level */
    if(strchr(given_match, '/')){
        char my_buff[1000];
        char *where_the_slash;

        strcpy(my_buff, given_match);
        where_the_slash=strchr(my_buff, '/');
        *where_the_slash=0;
        middle_part.setfrom(my_buff);
        my_dir.appendf("/%s", my_buff);
        my_match.setfrom(where_the_slash+1);
    }

    fill_sstrings_with_filenames(my_dir.get(), my_filelist);
    my_filelist.sort();
    {
        int my_loop=0;
        int my_limit;
        SSTRING fullpath_filename; /* = its_name + prefix /etc */
        SSTRING its_name;

        my_limit=my_filelist.getnb();
        while(my_loop<my_limit){
            its_name.setfrom(my_filelist.getitem(my_loop)->get());
            /* if filename prefix is the same as my_match.. */
            if(!strncmp(its_name.get(), my_match.get(), strlen(my_match.get()))){
                if(*(middle_part.get()))
                    fullpath_filename.setfromf("/dev/%s/%s", middle_part.get(), its_name.get());
                else
                    fullpath_filename.setfromf("/dev/%s", its_name.get());
                feed_me.add(new SSTRING(fullpath_filename.get()));
            }
            my_loop++;
        }
    }
}

/* fills given_fieldlist with matches from given_dir/given_match */
void fill_with_matching_files(FIELD_LIST *given_fieldlist, const char *given_dir, const char *given_match)
{
    int total_items, my_counter=0;
    SSTRINGS dev_list;

    to_sstrings_matching_files(dev_list, given_dir, given_match);
    total_items=dev_list.getnb();
    while(total_items--)
        given_fieldlist->addopt(dev_list.getitem(my_counter++)->get());
}

/* gives a hint for device (used when a new mouse is selected, suggests
   ttyS0 or something like this */
void gives_an_example_device(SSTRING &write_here, const char *given_dir, const char *given_match)
{
    SSTRINGS dev_list;

    to_sstrings_matching_files(dev_list, given_dir, given_match);
    if(dev_list.getnb())
        write_here.setfrom(dev_list.getitem(0)->get());
}

/* returns device for selected mouse, or NULL if user changed his/her mind */
DEVICE *select_new_mouse(DEVICELIST &given_devlist)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    DEVICE      *new_mouse; /* new mouse selected from list */

    /* builds list with mouses */
    my_dialog.newf_head("", MSG_U(F_AVAILTYPES, "Available types"));
    {
        int nb = given_devlist.getnb();
        for (int i = 0; i < nb; i++) {
            DEVICE *dev = given_devlist.getitem(i);
            my_dialog.new_menuitem(dev->descr, "");
        }
    }

    /* opens dialog.. */
    my_selection=0;
    my_button=my_dialog.editmenu(MSG_U(T_SELECTNEWMOUSE, "Select a new mouse"), "", help_nil, my_selection, MENUBUT_QUIT);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return(0);
    default:
        return(given_devlist.getitem(my_selection));
        break;
    }

    return(new_mouse);
}

/* loads data from provided entry to vars (used when selecting a new mouse) */
void load_itemdata_to_vars(DEVICE *which_mouse_entry)
{
    mouse_prefs.description.setfrom(which_mouse_entry->descr);
    mouse_prefs.mousetype.setfrom(which_mouse_entry->get_option("gident"));
    mouse_prefs.xmousetype.setfrom(which_mouse_entry->get_option("xident"));
}

/* transfers the data from a t_mouse_prefs to another */
void copy_mouse_prefs(t_mouse_prefs &dest_mp, t_mouse_prefs &src_mp)
{
    src_mp.mousetype.copy(dest_mp.mousetype);
    src_mp.xmousetype.copy(dest_mp.xmousetype);
    src_mp.description.copy(dest_mp.description);
    src_mp.xemu3.copy(dest_mp.xemu3);
    dest_mp.emulate3but=src_mp.emulate3but;

    src_mp.mousedevice.copy(dest_mp.mousedevice);

    src_mp.samplerate.copy(dest_mp.samplerate);
    src_mp.resolution.copy(dest_mp.resolution);
    src_mp.emulate3timeout.copy(dest_mp.emulate3timeout);
}

/* saves config for X and GPM and restarts mouse for X (not for GPM) */
void saves_configurations_and_restarts_things(void)
{
    /* save vars to /etc/sysconfig/mouse */
    {
        VIEWITEMS_PARSER pre_vitems_mouse;
        VIEWITEMS vitems_mouse(pre_vitems_mouse);
        vitems_mouse.read(cf_scmouse); // load file data

        save_this_var(mousetype,"MOUSETYPE");
        save_this_var(xmousetype,"XMOUSETYPE");
        save_this_var(description,"FULLNAME");
        if(mouse_prefs.emulate3but){
            mouse_prefs.xemu3.setfrom("yes");
        }else{
            mouse_prefs.xemu3.setfrom("no");
        }
        save_this_var(xemu3,"XEMU3");
        vitems_mouse.write(cf_scmouse, NULL); // save data
    }

#ifdef XF86_IS_PRESENT
    /* saves pertinent vars in XF86Config file */
    if(mouse_system.XF_exists)
        writes_xf86_config();
#endif

    /* change soft link in /dev/mouse */
    unlink(MOUSELINK_PATH);
    symlink(mouse_prefs.mousedevice.get(), MOUSELINK_PATH);

#ifdef XF86_IS_PRESENT
    /* reset mouse in X to current settings */
    {
        SSTRING parameter_builder;

        parameter_builder.setfromf("/dev/mouse %s default default default %s default", mouse_prefs.xmousetype.get(), mouse_prefs.emulate3but ? "1" : "0");
        netconf_system_if("XFmousereset", parameter_builder.get());
    }
#endif
}

void main_window(void)
{
    DIALOG      my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    FIELD_LIST *fl_current_port;

#ifndef COMPILE_FOR_BUGGY_XF86_OTF_SETTINGS
    FIELD_COMBO *fc_samplerate;
    FIELD_COMBO *fc_resolution;
#endif

    DEVICE *current_device;
    DEVICELIST devlist("/usr/lib/linuxconf/device_lists/mouse.list","mouse");
//    DEVICELIST devlist("/root/devicelist/mouse.list","mouse");

    /* reads config files and link in /dev/mouse */
    load_mouse_settings();
    copy_mouse_prefs(original_mouse_prefs, mouse_prefs);

    /* finds the device for current_device */
    current_device=finds_the_current_one(devlist);

    while(1){
        /* builds gui */
        my_dialog.remove_all();

        my_dialog.newf_info(MSG_U(F_CURRENTMOUSE, "Current mouse:"), mouse_prefs.description.get());
        if(current_device){
            if(strcasecmp(current_device->get_option("device"), "none")){

/*
#ifndef COMPILE_FOR_BUGGY_XF86_OTF_SETTINGS
                if(mouse_system.XF_exists)
                    my_dialog.newf_title("Basic settings", 1, "", "Basic settings");
#endif
*/
                fl_current_port=my_dialog.newf_list(MSG_U(F_DEVICE, "Device:"), mouse_prefs.mousedevice);
                fill_with_matching_files(fl_current_port, "/dev", current_device->get_option("device"));
                my_dialog.newf_chk("", mouse_prefs.emulate3but, MSG_U(F_EMULATE3BUTTONS, "emulate 3 buttons"));

/*
#ifndef COMPILE_FOR_BUGGY_XF86_OTF_SETTINGS
                if(mouse_system.XF_exists){
                    my_dialog.newf_title("XFree86 advanced", 1, "", "XFree86 advanced");
                    fc_samplerate=my_dialog.newf_combo("Sample rate (Hz):", mouse_prefs.samplerate);
                    fc_samplerate->addopt("20");
                    fc_samplerate->addopt("30");
                    fc_samplerate->addopt("60");
                    fc_resolution=my_dialog.newf_combo("Resolution (DPI):", mouse_prefs.resolution);
                    fc_resolution->addopt("200");
                    fc_resolution->addopt("300");
                    fc_resolution->addopt("600");
                    my_dialog.newf_str("Mid button emul. timeout (1/100s):", mouse_prefs.emulate3timeout);
                }
#endif
*/
            }
        }else{
            my_dialog.newf_info(MSG_U(T_MOUSENOTFOUNDLST, "Warning:"), MSG_U(I_MOUSENOTFOUNDLST, "Not found in mouse list"));
        }
        my_dialog.setbutinfo(MENU_USR1, MSG_U(X_SELECTMOUSE, "Select mouse..."), MSG_R(X_SELECTMOUSE));
#ifdef KUDZU_IS_PRESENT
        my_dialog.setbutinfo(MENU_USR2, MSG_U(X_DETECTMOUSE, "Detect mouse"), MSG_R(X_DETECTMOUSE));
#endif
        my_dialog.setbutinfo(MENU_USR3, MSG_U(X_TESTNOW, "Test now"), MSG_R(X_TESTNOW));

        /* opens dialog.. */
        my_selection=0;
        {
            int show_these_buttons=MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_USR1|MENUBUT_USR3;
#ifdef KUDZU_IS_PRESENT
            show_these_buttons|=MENUBUT_USR2;
#endif
            my_button=my_dialog.editmenu(MSG_U(T_MOUSESETTINGS, "Mouse settings"), "", help_nil, my_selection, show_these_buttons);
        }

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_USR1:
            {
                DEVICE *new_mouse;

                if((new_mouse=select_new_mouse(devlist))){
                    SSTRING device_hint;

                    current_device=new_mouse;
                    load_itemdata_to_vars(current_device);

                    /* suggests an device (such as ttyS0) according the mouse type */
                    gives_an_example_device(device_hint, "/dev", current_device->get_option("device"));
                    if(*(device_hint.get()))
                        mouse_prefs.mousedevice.setfrom(device_hint.get());

                    /* disable middle button emulation if mouse has 3>= ones */
                    if(atoi(current_device->get_option("buttons"))<3){
                        mouse_prefs.emulate3but=1;
                    }else{
                        mouse_prefs.emulate3but=0;
                    }
                }
            }
            break;
#ifdef KUDZU_IS_PRESENT
        case MENU_USR2:
            if(confirm_yesno_window(MSG_U(T_MOUSEDETECTION, "Mouse detection"), MSG_U(I_MOUSEDETECTION, "The configurator will try to find out\nwhich mouse is attached to this computer.\n\nWARNING: There's the possibility this procedure\nwill put the mouse in an unusable state or\neven lock the computer completely.\n\nDo you want to proceed?\n\n"))){
                char maus_dev[1000];
                char maus_drv[1000];
                DEVICE *new_mouse;
                SSTRING my_title;

                int  gpm_is_running;
                int  mouse_detection_level; // 0=none, 1=compat. found, 2=exact found

                DIALOG dia_detection;
                int    detection_progress=0;
                int    my_nothing=0;
                SSTRING detecting_mouse;

                detecting_mouse.setfrom(MSG_U(X_DETECTINGMOUSE, "Detecting mouse..."));

                /* opens detection progress window */
                dia_detection.settype(DIATYPE_POPUP);
                dia_detection.newf_gauge(MSG_U(F_PROGRESSBAR, "Progress:"), detection_progress, 100);
                dia_detection.show(detecting_mouse.get(), "", help_nil, my_nothing, 0);
                diagui_flush();

                /* shut down GPM if running */
                if((gpm_is_running=cf_gpmpid.exist())){
                    VIEWITEMS_PARSER pre_vitems_gpmpid;
                    VIEWITEMS vitems_gpmpid(pre_vitems_gpmpid);
                    vitems_gpmpid.read(cf_gpmpid); // load file data
                    const char *which_pid_to_kill;

                    which_pid_to_kill=vitems_gpmpid.getitem(0)->line.get();

                    netconf_system_if("gpm", "stop");
                }

                /* 20% ... */
                detection_progress=20;
                dia_detection.reload();
                dia_detection.show(detecting_mouse.get(), "", help_nil, my_nothing, 0);
                diagui_flush();

                mouse_detection_level=return_attached_mouse(maus_drv, maus_dev);

                /* 80% ... */
                detection_progress=80;
                dia_detection.reload();
                dia_detection.show(detecting_mouse.get(), "", help_nil, my_nothing, 0);
                diagui_flush();

                /* - restart GPM (if it was running before)
                   - restart X mouse (if X is active) */
                if(gpm_is_running)
                    netconf_system_if("gpm", "start");
#ifdef XF86_IS_PRESENT
                netconf_system_if("XFmousereset", "default default default default default default default");
#endif
                /* 100% */

                /* close progress window */
                dia_detection.hide();

                switch(mouse_detection_level){
                case 1: // something close was detected
                case 2: // the specific mouse model was detected
                    if((new_mouse=devlist.getitem_by_name(maus_drv))){
                        current_device=new_mouse;

                        load_itemdata_to_vars(new_mouse);
                        mouse_prefs.mousedevice.setfromf("/dev/%s", maus_dev);
                        my_title.setfromf(MSG_U(X_THISONE2BEUSED, "The following driver will be used:\n%s\n\nAnd the mouse was found attached to:\n/dev/%s\n"), mouse_prefs.description.get(), maus_dev);
                        informational_window(MSG_U(X_MOUSEFOUND, "Mouse found"), my_title.get());

                        /* disable middle button emulation if mouse has 3>= ones */
                        if(atoi(current_device->get_option("buttons"))<3){
                            mouse_prefs.emulate3but=1;
                        }else{
                            mouse_prefs.emulate3but=0;
                        }
                    }else{
                        informational_window(MSG_U(T_MOUSEDRVNOTFOUND, "Mouse driver not found"), MSG_U(I_MOUSEDRVNOTFOUND, "A mouse was detected, but the configurator\ncouldn't find the proper driver in mouse driver list.\n"));
                    }
                    break;
                default: // nothing was detected
                    informational_window(MSG_U(T_MOUSENOTDETECTED, "Mouse not detected"), MSG_U(I_MOUSENOTDETECTED, "The configurator didn't find any mouse attached.\nYou may want to try to manually configure\nthe mouse settings.\n"));
                    break;
                }

            }
            break;
#endif
        case MENU_USR3:
            {
                t_mouse_prefs newer_mouse_prefs;
                int           gpm_is_running;

                gpm_is_running=cf_gpmpid.exist();
                copy_mouse_prefs(newer_mouse_prefs, mouse_prefs);

                /* tries setting the mouse to new settings */
                saves_configurations_and_restarts_things();
                netconf_system_if("gpm", "restart");
#ifdef XF86_IS_PRESENT
                netconf_system_if("XFmousereset", "default default default default default default default");
#endif
                sleep_with_progress_bar(MSG_U(T_MOUSETEST, "Mouse test"), "", MSG_U(I_MOUSETEST, "Try moving the mouse around to check.\n\nThe previously-saved settings will be restored\nafter test time is over."), 10);

                // MSG_U(X_STOPTEST, "Stop test")

                /* restores original state */
                copy_mouse_prefs(mouse_prefs, original_mouse_prefs);
                saves_configurations_and_restarts_things();
                netconf_system_if("gpm", "restart");
                if(!gpm_is_running)
                    netconf_system_if("gpm", "stop");
#ifdef XF86_IS_PRESENT
                netconf_system_if("XFmousereset", "default default default default default default default");
#endif
                /* restores modified data to the variables */
                copy_mouse_prefs(mouse_prefs, newer_mouse_prefs);
            }
            break;
        case MENU_ACCEPT:
            saves_configurations_and_restarts_things();

            return;
        default:
            break;
        }
    }



}

void start_things(void)
{
    /* init vars according the system */
    /* checks if there's X installed (XFmousereset will run or not) */
    {
        char my_outp[512];

        my_outp[0]=0;

        mouse_system.XF_exists=0;
#ifdef XF86_IS_PRESENT
        /* verifies if XF86 is present on system */
        execute_proggy_and_get_stdout("XFmousereset default default default default default default default", my_outp, 511);
        if(strstr(my_outp, "XF ST LINK OK"))
            mouse_system.XF_exists=1;

        /* verifies if XF86 is v4 */
        if(mouse_system.XF_exists){
            execute_proggy_and_get_stdout("XFmousereset which_xf86_version", my_outp, 511);
            if(strstr(my_outp, "release: ")){
                if(!strstr(my_outp, "release: 4")){
                    informational_window(MSG_U(T_XF86NOTV4, "XFree86 is not v4!"),
                    MSG_U(I_XF86NOTV4, "The mouse configurator can't configure settings for XFree86 because\nanother version than v4 is installed."));
                    mouse_system.XF_exists=0;
                }
            }else{
                informational_window(MSG_U(T_UNKNOWNXF86VERSION, "Unknown XFree86 version"),
                                     MSG_U(I_UNKNOWNXF86VERSION, "Unable to determine the XFree86 version.\n\nKeep in mind that the mouse configurator needs XFree86 v4,\notherwise the XFree86 configurations may be garbled\n(and this would be very bad).\n\nNote: the mouse configurator can only determine\nthe XFree86 version if ran under XFree86 itself.\n"));
            }
        }
#endif
    }
    /* assumes GPM always present
     (currently it's not very useful to keep that disabled since this
     module's config is based on /etc/sysconfig/mouse) */
    mouse_system.GPM_exists=1;

    main_window();

}



/* adoro pudchiiin.. */

