/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "modemconf.h"
#include "modemconf.m"

MODULE_DEFINE_VERSION(modemconf);

PUBLIC MODULE_modemconf::MODULE_modemconf()
	: LINUXCONF_MODULE("modemconf")
{
	linuxconf_loadmsg ("modemconf",PACKAGE_REV);
	module_register_api ("devconf",1,modem_devconf_api_get
		,modem_devconf_api_release);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_modemconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_HARDWARE){
		keymenu = MSG_U(M_modemconf,"Modem");
		dia.new_menuitem ("modemconf","",keymenu);
	}
}

PUBLIC int MODULE_modemconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_HARDWARE){
		if (key == keymenu){
			modemconf_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_modemconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"modemconf")==0){
		modemconf_edit();
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module modemconf\n"
		 "linuxconf --modulemain modemconf [ specific options ]\n"
		 "\n"
		 "    without argument start the interactive mode\n"
		 "\n")
		);
}

PUBLIC void MODULE_modemconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_modemconf::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"modemconf")==0){
		ret = -1;
		if (argc == 1){
			modemconf_edit();
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_modemconf modemconf;

