
/* disklist management */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "amandaconf.h"
#include "amandaconf.m"

#include "am_tools.h"
#include "lame_parser.h"

void edit_specified_disk(t_parser_control *parser_control, const char *host_name, VIEWITEMS &dsklst_vi, int which_disk, CONFIG_FILE &dsklst_cf)
{
    struct {
        SSTRING hostname,
            diskdevice,
            dumptype,
            spindle,
            interface;
    } my_intvars;

    SSTRING     dialog_title;
    DIALOG      my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    const char  *current_dsklst_line;
    SSTRING     *current_sstring_line;
    int         enter_the_loop=1;

    current_sstring_line=&(dsklst_vi.getitem(which_disk)->line);
    current_dsklst_line=current_sstring_line->get();

    /* loads vars.. */
    bload_dsklst(hostname,0);
    bload_dsklst(diskdevice,1);
    bload_dsklst(dumptype,2);
    bload_dsklst(spindle,3);
    bload_dsklst(interface,4);

    /* builds gui.. */
    bgui_str(hostname,MSG_U(F_HOSTNAME,"Hostname:"));
    bgui_str(diskdevice,MSG_U(F_DISKDEVICE,"Disk device:"));
    bgui_fl_groupitems(dumptype,"define dumptype ",MSG_U(F_DUMPTYPE,"Dump type:"),sdumptype);
    bgui_str(spindle,MSG_U(F_SPINDLE,"Spindle (opt.):"));
    bgui_fl_groupitems(interface,"define interface ",MSG_U(F_INTERFACE,"Interface (opt.):"),sinterface);

    while(enter_the_loop){
        enter_the_loop=0; // by default, do not repeat this
        /* opens dialog.. */
        dialog_title.setfromf(MSG_U(T_ENTRYFORHOST,"Entry for host %s"), host_name);
        my_selection=0;
        my_button=my_dialog.editmenu(dialog_title.get(), MSG_U(I_ENTRYFORHOST,"These are the disks which will be\nbacked up by Amanda."), disklist_prop_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ACCEPT:
            {
                SSTRING temp_buff;

                /* save vars if requested so.. */
                temp_buff.setfrom("");
                bsave_dsklst(hostname);
                bsave_dsklst(diskdevice);
                bsave_dsklst(dumptype);
                bsave_dsklst(spindle);
                if(*my_intvars.spindle.get())
                    bsave_dsklst(interface);

                /* ok, no invalid input provided */
                if(!enter_the_loop){
                    current_sstring_line->setfrom(temp_buff.get());
                    dsklst_vi.write(dsklst_cf, 0);
                }else{
                    informational_window(MSG_U(T_INVALIDDATAPROVIDED,"Invalid data provided"), MSG_U(I_INVALIDDATAPROVIDED,"None of these fields can have spaces characters.\n"));
                }
            }
            break;
        case MENU_DEL:
            dsklst_vi.remove_del(which_disk);
            dsklst_vi.write(dsklst_cf, 0);
            break;
        default:
            break;
        }
    }
}

void select_disks_window(const char *given_groupname, CONFIG_FILE &cf_amandaconf, t_parser_control *parser_control)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    SSTRING disklist_fullpath;
    SSTRING disklist_filename;
    VIEWITEMS_PARSER my_vitems_parser;
    VIEWITEMS my_vitems(my_vitems_parser);

    /* gets diskfile filename and assign a CONFIG_FILE to it */
    load_vardata_into(parser_control, NULL, "diskfile", disklist_filename);
    if(!*(disklist_filename.get())) // if undefined assume the default name
        disklist_filename.setfrom(DEFAULT_DISKLIST_FILENAME);
    disklist_fullpath.setfromf("%s/%s/%s", AMANDA_CONFIG_DIRECTORY, given_groupname, disklist_filename.get());
    CONFIG_FILE cf_disklist(disklist_fullpath.get(), disklist_helpfile, CONFIGF_MANAGED);

    my_vitems.read(cf_disklist);

    my_dialog.newf_head("", MSG_U(X_DSKLISTHEADER,"hostname\tdisk device\tdump type\tspindle\tinterface"));

    while(1){
//        MENU_STATUS my_button=(MENU_STATUS)0;
//        int         my_selection=0;
        int         total_lines, progressive_counter=0;
        SSTRING     line_to_insert;

//        my_dialog.remove_all(); // cleans window
//        my_dialog.newf_head("", MSG_U(X_DSKLISTHEADER,"hostname\tdisk device\tdump type\tspindle\tinterface"));

        /* fills list.. */
        total_lines=my_vitems.getnb();
        while(total_lines--){
            columnize_words_string(my_vitems.getitem(progressive_counter)->line.get(), line_to_insert);
//            my_dialog.new_menuitem(line_to_insert.get(), "");
            my_dialog.set_menuitem(progressive_counter, line_to_insert.get(), "");
            progressive_counter++;
        }

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(progressive_counter+1);

        my_button=my_dialog.editmenu(MSG_U(T_DSKLISTENTRIES,"Disk list entries"), "", help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            my_vitems.add(new VIEWITEM(MSG_U(X_DSKENTRYSAMPLE,"some_hostname /dev/disk_device a_dumptype")));
            my_vitems.write(cf_disklist, 0);
            break;
        default:
            {
                SSTRING hostname_of_selected_line;

                return_which_word(my_vitems.getitem(my_selection)->line.get(), 0, hostname_of_selected_line);
                edit_specified_disk(parser_control, hostname_of_selected_line.get(), my_vitems, my_selection, cf_disklist);

                break;
            }
        }
    }
}


