/*
	This file contain stubs for liblinuxconf.
	It is needed because there are various calls here an there
	in the library which are very important for Linuxconf (admin tool
	with privilege concept, many UI, etc...), but not important
	nor useful for ordinary programs using the library.

	At some point, we will probably rework the library and also
	use weak symbols. For now, this is not useful, because linuxconf
	is linked statically with the library. This file is only added
	to the liblinuxconf library.
*/
#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <fixperm.h>

int revision;

void html_access_log(int, const char *){}
int html_access_check(int){return 0;}
void perm_setaccess (const char *, const char *){}
int fixperm_readperm(
	char const *,
	class PERMINFO &pinfo,
	char const *user,
	char const *group,
	int perm,
	bool)
{
	pinfo.perm = perm;
	uid_t uid = getuid();
	if (uid == 0){
		struct passwd *p = getpwnam (user);
		if (p != NULL){
			pinfo.uid = p->pw_uid;
		}else{
			pinfo.uid = uid;
		}
		struct group *g = getgrnam (user);
		if (g != NULL){
			pinfo.gid = g->gr_gid;
		}else{
			pinfo.gid = getgid();
		}
	}else{
		pinfo.uid = uid;
		pinfo.gid = getgid();
	}
	return 0;
}

int perm_rootaccess(char const *,...)
{
	return 1;
}

int perm_access(class PRIVILEGE *, char const *,...)
{
	return 1;
}

int process_findchild(int){ return -1; }

void boot_showlog(
	class CONFIG_FILE &,
	char const **,
	char const *,
	char const *,
	class HELP_FILE &)
{
}

void net_prtlog(int, char const *,...){}

void net_introlog(int){}

const char *daemon_findpath(char const *command)
{
	return command;
}

void button_text2png (const char *, FILE *)
{
}

#if 0
enum MENU_CONTEXT{
	MENU_STUB
};
#endif

void module_setmenu (class DIALOG &, MENU_CONTEXT){}

int module_sendmessage (
	const char *msg,
	int argc,
	const char *argv[])
{
	return 0;
}

