#pragma interface
#ifndef CMDSOCK_H
#define CMDSOCK_H

//const int MAX_CLIENT=100;

class CMDSOCK{
protected:
	int listen_handle;
	class SOCK_INFO *inf;
	int maxcli;		// Maximum number of entry in inf[]
	int nbcli;		// How many active connexion in
					// inf[]
	int active;		// Current index in tbactif[],
					// see readnext().
	/*~PROTOBEG~ CMDSOCK */
public:
	CMDSOCK (const char *portname, int reuseaddr);
	CMDSOCK (int port, int reuseaddr);
protected:
	CMDSOCK (void);
public:
	void addcli (int fd);
	void addcli (int fd, int timeout);
protected:
	void baseinit (void);
public:
	void closecli (int fd);
	void forgetcli (int fd);
	int getnbcli (void);
private:
	void init (int port, int reuseadr);
public:
	int is_ok (void);
	int listen (long timeout);
	int listen (long timeout, int &newclient);
	int process_select (int sel,
		 fd_set&set,
		 int &newclient,
		 long timeout);
	int readnext (void *buf, int size, int &cli);
	void set_timeout (int fd, int timeout);
	int setup_select (fd_set&set, int max_handle);
	~CMDSOCK (void);
	/*~PROTOEND~ CMDSOCK */
};

class CMDSOCK_UNIX: public CMDSOCK{
	/*~PROTOBEG~ CMDSOCK_UNIX */
public:
	CMDSOCK_UNIX (const char *sockpath);
private:
	void initunix (const char *sockn);
public:
	/*~PROTOEND~ CMDSOCK_UNIX */
};


#endif

