#include <stdlib.h>
#include <string.h>
#include "dialog.h"
#include "../diajava/proto.h"

class FIELD_CHECK_MULTI_VAL_STR: public FIELD_CHECK_MULTI{
	int &numvar;
	int backup;
	char cvar;
	const int *vals;
	struct {
		int input;	// Current position in window */
		int scroll;	// Amount of horizontal scrolling so far */
	}x;
	SSTRING &bufstr;
	SSTRING buf;
	int optlen;
	/*~PROTOBEG~ FIELD_CHECK_MULTI_VAL_STR */
public:
	FIELD_CHECK_MULTI_VAL_STR (const char *
		_prompt,
		 int &_var,
		 SSTRING&_bufstr,
		 const int _vals[],
		 const char *_options[]);
	MENU_STATUS dokey (WINDOW *dialog,
		 int key,
		 FIELD_MSG&,
		 bool&);
	void drawtxt (WINDOW *dialog,
		 int offset);
	void gui_draw (int nof, SSTRINGS&);
	MENU_STATUS gui_get (int nof,
		 const char *,
		 const char *);
	void html_draw (int nof);
	int html_validate (int nof);
	void reload (const char *dianame,
		 int nof);
	void restore (void);
	void save (void);
	void setcursor (WINDOW *dialog,
		 int offset);
	/*~PROTOEND~ FIELD_CHECK_MULTI_VAL_STR */
};

PUBLIC FIELD_CHECK_MULTI_VAL_STR::FIELD_CHECK_MULTI_VAL_STR(
	const char *_prompt,
	int &_var,
	SSTRING &_bufstr,
	const int _vals[],			// Value corresponding to the titles
	const char *_options[])
	: FIELD_CHECK_MULTI (_prompt,cvar,_options), numvar(_var)
          ,bufstr(_bufstr)
{
	backup = numvar;
	vals = _vals;
	reload(NULL,0);
	box.width += 20;
	x.input = x.scroll = 0;
	buf.setfrom(bufstr.get(),511);
		
	optlen = 0;
	for (int i=0; _options[i] != NULL; i++){
		optlen += strlen(_options[i])+4+1;
	}
}

PUBLIC void FIELD_CHECK_MULTI_VAL_STR::save( )
{
	if (val == options.getnb()){
		bufstr.setfrom(buf);
	}
	numvar = vals[val];
}
PUBLIC void FIELD_CHECK_MULTI_VAL_STR::restore( )
{
	numvar = backup;
	FIELD_CHECK_MULTI::restore();
}
PUBLIC void FIELD_CHECK_MULTI_VAL_STR::reload(const char *dianame, int nof)
{
	int nbopt = options.getnb();
	for (int i=0; i<nbopt; i++){
		if (vals[i] == numvar){
			cvar = (char)i;
			break;
		}
		cvar = (char)(i+1);
	}
	FIELD_CHECK_MULTI::reload(dianame,nof);
	if (val == options.getnb()){
		buf.setfrom(bufstr);
	}
	sendval (dianame,nof,'S',buf.get());
}

PUBLIC void FIELD_CHECK_MULTI_VAL_STR::drawtxt (
	WINDOW *dialog,
	int offset)
{
	FIELD_CHECK_MULTI::drawtxt(dialog,offset);
	wmove(dialog, box.y,box.x+optlen);
	if (val < options.getnb()){
		for (int i=0; optlen+i < box.width; i++){
			waddch (dialog,'_');
		}
	}else{
		const char *str = buf.get();
		for (int i=0; optlen+i < box.width && str[i+x.scroll] != 0; i++){
			waddch (dialog,str[i+x.scroll]);
		}
	}
}

PUBLIC void FIELD_CHECK_MULTI_VAL_STR::setcursor (WINDOW *dialog, int offset)
{
	if (val == options.getnb()){
		wmove (dialog,box.y,box.x+optlen+x.input-x.scroll);
	}else{
		FIELD_CHECK_MULTI::setcursor(dialog,offset);
	}
}


PUBLIC MENU_STATUS FIELD_CHECK_MULTI_VAL_STR::dokey (
	WINDOW *dialog,
	int key,
	FIELD_MSG &,
	bool &)
{
	int nbopt = options.getnb();
	if (val == nbopt){
		// Now we are editing the text field
		int newval = -1;
		switch (key){
		case KEY_HOME:
			newval = 0;
			break;
		case KEY_LEFT:
			if (x.input == 0 && x.scroll == 0){
				newval = nbopt-1;
			}
			break;
		}
		if (newval != -1){
			val = newval;
			drawtxt (dialog,0);
		}else{
			char editbuf[512];
			strcpy(editbuf,buf.get());;
			if (field_editline (dialog,false,FIELDEDIT_ANY,key,box.width-optlen,box.y,box.x+optlen,511,x.input,x.scroll,editbuf)){
			  buf.setfrom(editbuf);
			  drawtxt (dialog,0);
			}else{
			  buf.setfrom(editbuf);
			}
		}
	}else{
		char lastopt = (char)(nbopt-1);
		char newval = val;
		switch (key){
		case ' ':
		case KEY_RIGHT:
			newval = val + 1;
			break;
		case KEY_HOME:
			newval = 0;
			break;
		case 5:		/* ^E like Emacs */
		case KEY_END:
			newval = lastopt;
			break;
		case KEY_LEFT:
			if (newval == 0){
				newval = lastopt;
			}else{
				newval--;
			}
			break;
		}
		if (newval != val){
			val = newval;
			drawtxt (dialog,0);
		}
	}
	return MENU_NULL;
}

PUBLIC void FIELD_CHECK_MULTI_VAL_STR::html_draw(int nof)
{
	char key[100];
	format_htmlkey (key,nof);
	html_defvarcur(key,vals[val]);
	FIELD_CHECK_MULTI::html_draw (nof);
	// We generate one more radio as compared with FIELD_CHECK_MULTI
	// The supplementary radio enable the text field
	int n = options.getnb();
	html_defvar ("radio",key,n,val == n ? "checked" : "");
	strcat (key,"-s");
	html_defvar ("text",key,buf.get(),"size=30");
}
PUBLIC int FIELD_CHECK_MULTI_VAL_STR::html_validate(int nof)
{
	int ret = -1;
	char key[512];
	format_htmlkey (key,nof);
	int oldval = atoi(html_getoldval(key));
	if (vals[val] == oldval){
		ret = 0;
		val = atoi(html_getval(key));
		strcat (key,"-s");
		buf.setfrom(html_getval(key),511);
	}
	return ret;
}

PUBLIC void FIELD_CHECK_MULTI_VAL_STR::gui_draw(int nof, SSTRINGS &)
{
	guisendprompt();
	int n = options.getnb();
	diagui_sendcmd (P_Form,"F%d $vexpand=0\n",nof);
	for (int i=0; i<n; i++){
		const char *str = options.getitem(i)->get();
		char tmp[1000];
		diagui_sendcmd (P_Radio,"R%d %d %d %s\n",nof,i,i==val
			,diagui_quote(str,tmp));
	}
	diagui_sendcmd (P_Radio,"R%d %d %d %s\n",nof,n,n==val,"");
	char tmp[1000];
	diagui_sendcmd (P_String,"S%d %d %s\n",nof,10,diagui_quote(buf.get(),tmp));
	diagui_sendcmd (P_End,"\n");
}
PUBLIC MENU_STATUS FIELD_CHECK_MULTI_VAL_STR::gui_get(int nof, const char *, const char *)
{
	val = atoi(diagui_getval('R',nof));
	buf.setfrom(diagui_getval('S',nof));
	return MENU_NULL;
}

PUBLIC FIELD_CHECK_MULTI *DIALOG::newf_chkm_str(
	const char *prompt,
	int &var,
	SSTRING &bufstr,
	const int vals[],			// Value corresponding to the options
	const char *options[])
{
	FIELD_CHECK_MULTI *s = new FIELD_CHECK_MULTI_VAL_STR(prompt,var,bufstr,vals,options);
	add (s);
	return s;
}
