#!/bin/sh
# Archive an account in /home/oldaccounts
. /usr/lib/linuxconf/lib/accountcmd.sh

KEY=`date +%Y-%m-%d`-$$
echo Archiving account $USERID in $BASE/oldaccounts/$USERID-$KEY.tar.gz
mkdir -p $BASE/oldaccounts
chown root.root $BASE/oldaccounts
chmod 600 $BASE/oldaccounts
if [ ! -d $HOMEDIR ] ; then
	echo "     " $HOMEDIR is not a directory
	HOMEDIR=
else
	OWNER=`/usr/lib/linuxconf/lib/fileowner $HOMEDIR $DOMAIN`
	if [ "$USERID" != "$OWNER" ] ; then
		echo "     " $HOMEDIR not owned by $USERID. Not deleted/archived
		HOMEDIR=
	else
		echo "     " Archiving home directory $HOMEDIR
	fi
fi

if [ ! -f $INBOX ] ; then
	INBOX=
else
	echo "     " Archiving inbox $INBOX
fi
umask 066
if [ "$INBOX" != "" -o "$HOMEDIR" != "" ] ; then
	if tar zcf $BASE/oldaccounts/$USERID-$KEY.tar.gz $HOMEDIR $INBOX
	then
		rm -f $INBOX
		rm -fr $HOMEDIR
	fi
fi

