
/* application behaviour (appearance, etc) */

#include <stdio.h>
#include <string.h>
#include "wineconf.h"
#include "wineconf.m"
#include <fviews.h>
#include "wineconf_global_defs.h"
#include "wineconf_tools.h"

void manage_application_behaviour(VIEWITEMS &vitems_wineconf, CONFIG_FILE &cf_wineconf)
{
    struct {
        SSTRING winelook;
        SSTRING fntresolution, fntdefault;
        SSTRING clearallselections, persistentselection;

//        char clearallselections, persistentselection;

        SSTRING drivers, xtermprog, initialrows, initialcolumns, terminaltype;

        SSTRING prdefault, prstartup;
    } my_intdir;

    FIELD_COMBO *co_winelook;
    FIELD_COMBO *co_xtermprog;
    FIELD_COMBO *co_terminaltype;
    FIELD_COMBO *co_drivers;
    FIELD_LIST  *fl_clearallselections;
    FIELD_LIST  *fl_persistentselection;

    DIALOG      my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    /* loads local vars with data from file */
    load_var_data("Tweak.Layout", "WineLook", vitems_wineconf, my_intdir.winelook);
    load_var_data("fonts", "Resolution", vitems_wineconf, my_intdir.fntresolution);
    load_var_data("fonts", "Default", vitems_wineconf, my_intdir.fntdefault);
    load_boolean_to_sstring("Clipboard", "ClearAllSelections", vitems_wineconf, my_intdir.clearallselections);
    load_boolean_to_sstring("Clipboard", "PersistentSelection", vitems_wineconf, my_intdir.persistentselection);
    load_var_data("Console", "Drivers", vitems_wineconf, my_intdir.drivers);
    load_var_data("Console", "XtermProg", vitems_wineconf, my_intdir.xtermprog);
    load_var_data("Console", "InitialRows", vitems_wineconf, my_intdir.initialrows);
    load_var_data("Console", "InitialColumns", vitems_wineconf, my_intdir.initialcolumns);
    load_var_data("Console", "TerminalType", vitems_wineconf, my_intdir.terminaltype);
    /* builds window */
    /* appearance */
    my_dialog.newf_title(MSG_U(T_APPEARANCE, "Appearance"), 1, "", MSG_R(T_APPEARANCE));
    co_winelook=my_dialog.newf_combo(MSG_U(F_LOOKAS, "Look as:"), my_intdir.winelook);
    co_winelook->addopt("Win31");
    co_winelook->addopt("Win95");
    co_winelook->addopt("Win98");
    my_dialog.newf_str(MSG_U(F_DEFAULTFONT, "Default font:"), my_intdir.fntdefault);
    my_dialog.newf_str(MSG_U(F_DEFAULTFONTRES, "Default display resolution (dpi):"), my_intdir.fntresolution);
//    my_dialog.newf_str(MSG_U(F_SYSCOLORS2ALLOC, "System colors to allocate:"), my_intdir.allocsystemcolors);
    /* console */
    my_dialog.newf_title(MSG_U(T_CONSOLE, "Console"), 1, "", MSG_R(T_CONSOLE));
    co_drivers=my_dialog.newf_combo(MSG_U(F_DRIVERS, "Drivers:"), my_intdir.drivers);
    co_drivers->addopt("tty");
    co_xtermprog=my_dialog.newf_combo(MSG_U(F_XTERMPROGRAM, "Xterm program:"), my_intdir.xtermprog);
    co_xtermprog->addopt("xterm");
    co_xtermprog->addopt("kvt");
    co_xtermprog->addopt("gnome-terminal");
    co_terminaltype=my_dialog.newf_combo(MSG_U(F_TERMINALTYPE, "Terminal type:"), my_intdir.terminaltype);
    co_terminaltype->addopt("xterm");
    my_dialog.newf_str(MSG_U(F_INITIALCOLUMNS, "Initial columns:"), my_intdir.initialcolumns);
    my_dialog.newf_str(MSG_U(F_INITIALROWS, "Initial rows:"), my_intdir.initialrows);
    /* clipboard */
    my_dialog.newf_title(MSG_U(T_CLIPBOARD, "Clipboard"), 1, "", MSG_R(T_CLIPBOARD));
    create_triple_boolean_gadget(my_dialog, &fl_clearallselections, MSG_U(F_CLEARALLSELECTIONS, "Clear all selections:"), my_intdir.clearallselections);
    create_triple_boolean_gadget(my_dialog, &fl_persistentselection, MSG_U(F_PERSISTENTSELECTION, "Persistent selection::"), my_intdir.persistentselection);
    /* programs */
//    my_dialog.newf_title(MSG_U(T_PROGRAMS, "Programs"), 1, "", MSG_R(T_PROGRAMS));
//    my_dialog.newf_str(MSG_U(F_DEFAULT, "Default:"), my_intdir.prdefault);
//    my_dialog.newf_str(MSG_U(F_STARTUP, "Startup:"), my_intdir.prstartup);

    /* opens window.. */
    my_selection=0;
    my_button=my_dialog.editmenu(MSG_U(T_APPBEHAVIOURUNDERWINE, "Application behavior under Wine"), "", apps_behav_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT);

    /* now user pressed some button, let's have some processing.. */

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ACCEPT:
        {
            /* update file with data from local vars */
            write_var_data("Tweak.Layout", "WineLook", my_intdir.winelook.get(), vitems_wineconf, 1);
            write_var_data("fonts", "Resolution", my_intdir.fntresolution.get(), vitems_wineconf, 1);
            write_var_data("fonts", "Default", my_intdir.fntdefault.get(), vitems_wineconf, 1);
            write_var_data("Clipboard", "ClearAllSelections", my_intdir.clearallselections.get(), vitems_wineconf, 1);
            write_var_data("Clipboard", "PersistentSelection", my_intdir.persistentselection.get(), vitems_wineconf, 1);
            write_var_data("Console", "Drivers", my_intdir.drivers.get(), vitems_wineconf, 1);
            write_var_data("Console", "XtermProg", my_intdir.xtermprog.get(), vitems_wineconf, 1);
            write_var_data("Console", "InitialRows", my_intdir.initialrows.get(), vitems_wineconf, 1);
            write_var_data("Console", "InitialColumns", my_intdir.initialcolumns.get(), vitems_wineconf, 1);
            write_var_data("Console", "TerminalType", my_intdir.terminaltype.get(), vitems_wineconf, 1);
//            write_var_data("programs", "Default", my_intdir.prdefault.get(), vitems_wineconf, 0);
//            write_var_data("programs", "Startup", my_intdir.prstartup.get(), vitems_wineconf, 0);

            vitems_wineconf.write(cf_wineconf, NULL);
        }
    default:
        break;
    }
}

