#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include "syslogconf.h"
#include "syslogconf.m"
#include <proto.h>

extern HELP_FILE help_syslog;
MODULE_DEFINE_VERSION(syslogconf);

PUBLIC MODULE_syslogconf::MODULE_syslogconf()
	: LINUXCONF_MODULE("syslogconf")
{
	linuxconf_loadmsg ("syslogconf",PACKAGE_REV);
}


static const char *keymenu=NULL;
static const char *menuconfig=NULL;

PUBLIC void MODULE_syslogconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_LOGS){
		keymenu = MSG_U(M_syslogview,"System logs");
		dia.new_menuitem ("syslogconf","",keymenu);
	}else if (context == MENU_MISCSERV){
		menuconfig = MSG_U(M_syslogconf,"System logs");
		dia.new_menuitem ("syslogconf","",menuconfig);
	}
}

PUBLIC int MODULE_syslogconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_LOGS){
		if (key == keymenu){
			syslog_menu();
		}
	}else if (context == MENU_MISCSERV){
		if (key == menuconfig){
			SYSLOGCONF conf;
			conf.edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_syslogconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"syslogconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}

PUBLIC int MODULE_syslogconf::message (
	const char *msg,
	int argc,
	const char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(msg,"build-menubar")==0){
		ret = 0;
		SYSLOGCONF conf;
		conf.setmenubar();
	}else if (strcmp(msg,"build-helpmenu")==0){
		diagui_sendcmd (P_Menuentry,"199 \"%s\"\n",MSG_R(M_LOGS));
	}else if (strcmp(msg,"menubar")==0){
		int sel = atoi(argv[0]);
		if (sel == 199){
			diagui_showhelp (help_syslog);
		}else{
			SYSLOGCONF conf;
			conf.execmenu (sel);
		}
	}
	return ret;
}

static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module syslogconf\n"
		 "linuxconf --modulemain syslogconf [ specific options ]\n"
		 "\n"
		 "    --view logfile\n"
		 "\n"
		 "/sbin/viewlog logfile\n"
		 "\n")
		);
}

PUBLIC void MODULE_syslogconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_syslogconf::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"syslogconf")==0){
		ret = -1;
		if (argc == 1){
			syslog_menu();
		}else if (argc == 3 && strcmp(argv[1],"--view")==0){
			syslog_viewone (argv[2],NULL);
		}else{
			::usage();
		}
	}else if (strcmp(pt,"viewlog")==0){
		ret = -1;
		if (argc == 1){
			syslog_menu();
		}else if (argc == 2){
			syslog_viewone (argv[1],NULL);
		}else{
			::usage();
		}
	}
	return ret;
}


static MODULE_syslogconf syslogconf;

