
#include <stdio.h>
#include <string.h>

#include <fviews.h>
#include <dialog.h>

#include "rc_parser.h"
#include "rc_tools.h"

/* removes the surrounding quotes from string */
void cuts_quotes_off(SSTRING &sstring_to_adjust)
{
    SSTRING my_temp;

    if(sstring_to_adjust.getlen()<2)
        return;

    my_temp.setfrom(sstring_to_adjust.get()+1);
    my_temp.truncate(sstring_to_adjust.getlen()-2);

    sstring_to_adjust.setfrom(my_temp.get());
}

/* strcmp non-sensitive to case */
int ci_strcmp(const char *given_string_1, const char *given_string_2)
{
    SSTRING my_shadow_1, my_shadow_2;

    my_shadow_1.setfrom(given_string_1);
    my_shadow_1.to_lower();
    my_shadow_2.setfrom(given_string_2);
    my_shadow_2.to_lower();

    return(strcmp(my_shadow_1.get(), my_shadow_2.get()));
}

/* returns !=0 if the provided string is empty or has spaces/etc (<31 ascii) */
int invalid_entry(const char *given_string)
{
    if(*given_string){
        const char *my_pos;

        my_pos=given_string;
        while(*my_pos){
            if(*my_pos <= ' ')
                return(1);
            my_pos++;
        }
        return(0);
    }
    return(1);
}

int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number)
{
    return(gimme_word_from_string(given_string, write_here, word_number, 0));
}

/* picks a 'word' (string-particle between spaces) from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 if non-empty string returned */
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number, int to_eol)
{
    const char *read_from,
               *copy_from;
    int  my_counter;

    read_from=given_string;

    /* ignores heading spaces */
    while((*read_from)&&(*read_from<=' '))
        read_from++;

    /* finds the beginning of word */
    my_counter=word_number;
    while(my_counter--){
        while((*read_from)&&(*read_from>' '))
            read_from++;
        while((*read_from)&&(*read_from<=' '))
            read_from++;
    }

    /* finds the length of the word and copies string */
    if((copy_from=read_from)){
        my_counter=0;
        if(!to_eol){
            while((*read_from)&&(*read_from>' ')){
                read_from++;
                my_counter++;
            }
        }else{
            while(*read_from++)
                my_counter++;
        }

        write_here.setfrom(copy_from);
        write_here.truncate(my_counter);
    }else{
        write_here.setfrom("");
    }

    if(!*write_here.get()) /* if empty string returned.. */
        return(0);
    return(1);
}

/* gives the 'real' beginning of a given string (skips the heading spaces, tabs, etc) */
const char *skip_spaces(const char *given_string)
{
    const char *real_str_start;

    real_str_start=given_string;
    while((*real_str_start)&&(*real_str_start<33))
        real_str_start++;

    return(real_str_start);
}

/* returns string length except the tailing spaces */
unsigned int strlen_except_useless_tail(const char *given_string)
{
    int my_strlen;

    my_strlen=strlen(given_string);
    while(my_strlen){
        if(*(given_string+(my_strlen-1))!=' ')
            return(my_strlen);
        my_strlen--;
    }
    return(my_strlen);
}

/* cuts the heading and trailing spaces (anything < ' ')
 in the provided string and writes the new string in the provided
 SSTRING */
void cut_surrounding_spaces(const char *adjust_this, SSTRING &write_here)
{
    const char *no_heading_spaces;

    no_heading_spaces=skip_spaces(adjust_this);
    write_here.setfrom(no_heading_spaces, strlen_except_useless_tail(no_heading_spaces));
}

/* returns !=0 if string is empty, or has only spaces */
int is_empty_string(const char *given_string)
{
    SSTRING my_temp;

    cut_surrounding_spaces(given_string, my_temp);
    if(*(my_temp.get()))
        return(0);
    return(1);
}

/* returns !=0 is all strings inside given_sstrings are empty,
   ==0 at least one of these has some data */
int are_all_empty(SSTRINGS &given_sstrings)
{
    int my_loop;
    int all_are_empty=1;

    my_loop=given_sstrings.getnb();
    while(my_loop--){
        if(!is_empty_string(given_sstrings.getitem(my_loop)->get()))
            all_are_empty=0;
    }

    return(all_are_empty);
}

void informative_window(const char *my_title, const char *my_text)
{
    dialog_msgbox (my_title, my_text, "");
}

/* returns 0 to N or -1 (-1 means 'selection cancelled')
 if items' total is N and N is returned means the object is going
 to be the last one. (0 means 'to the first position') */
/* this is used when moving a group from a position to another */
int select_new_position(VIEWITEMS &given_vitems, const char *window_title, const char *table_title, const char *last_position)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    int         progressive_counter=0;
    SSTRING     username_to_insert,
                match_to_insert;

    my_dialog.newf_head("", table_title);

    /* fills list.. */
    while(returns_data_for_list(given_vitems, progressive_counter, match_to_insert, username_to_insert)){
        my_dialog.set_menuitem(progressive_counter, username_to_insert.get(), match_to_insert.get());
        progressive_counter++;
    }
    my_dialog.set_menuitem(progressive_counter, last_position, "");

    my_button=my_dialog.editmenu(window_title, "", help_nil, my_selection, MENUBUT_QUIT);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return(-1);
    default:
        return(my_selection);
    }
}

/* picks a 'word between given_chars' from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 is non-empty string returned */
/* NOTE-- modified version:
 ignores separator between quotes.
 this avoids problems in the following case:
 "blah", "blahblah", "i like candies, blah" */
int gimme_word_from_string_bchar(const char *given_string, SSTRING &write_here, int word_number, const char given_separator)
{
    const char *read_from,
               *copy_from;
    int  my_counter;
    int  how_many_quotes; // how many quotes present on string until that point


    /* finds the beginning of word */
    read_from=given_string;
    my_counter=word_number;
    while(my_counter--){
        how_many_quotes=0;
        while((*read_from)&&((*read_from!=given_separator)||((*read_from==given_separator)&&(how_many_quotes&1)))){
            if(*read_from=='\"')
                how_many_quotes++;
            read_from++;
        }
        if(*read_from)
            read_from++;
    }

    /* finds the length of the word and copies string */
    if((copy_from=read_from)){
        my_counter=0;
        how_many_quotes=0;
        while((*read_from)&&((*read_from!=given_separator)||((*read_from==given_separator)&&(how_many_quotes&1)))){
            if(*read_from=='\"')
                how_many_quotes++;
            read_from++;
            my_counter++;
        }

        write_here.setfrom(copy_from);
        write_here.truncate(my_counter);
    }else{
        write_here.setfrom("");
    }

    if(!*write_here.get()) /* if empty string returned.. */
        return(0);
    return(1);
}


