#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static PyObject *
LCInt_set(LCIntObject *self, PyObject *args)
{
	int i;
	if (!PyArg_ParseTuple(args,"i",&i))
		return NULL;
	*self->i = i;
	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef LCInt_methods[] = {
	{"set", (binaryfunc) LCInt_set, 1},
	{NULL, NULL}
};

static void
LCInt_dealloc(LCIntObject *self)
{
	if (self->owner)
		delete self->i;
	PyMem_DEL(self);
}

static PyObject *
LCInt_getattr(LCIntObject *self, char *name)
{
	return Py_FindMethod(LCInt_methods, (PyObject*) self, name);
}

static PyObject *
LCInt_repr(LCIntObject *self)
{
	char tmp[16];
	sprintf(tmp,"%d",*self->i);
	return PyString_FromString(tmp);
}

static PyNumberMethods LCIntNumberMethods = {
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(ternaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(inquiry) 0,
	(unaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(coercion) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0
};
	
PyTypeObject LCInt_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCInt",
	sizeof(LCIntObject),
	0,
	(destructor) LCInt_dealloc,
	(printfunc) 0,
	(getattrfunc) LCInt_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) LCInt_repr,
	&LCIntNumberMethods,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCInt_New(int i)
{
	LCIntObject *self;
	self = PyObject_NEW(LCIntObject, &LCInt_Type);
	if (self == NULL)
		return NULL;
	self->i = new int(i);
	self->owner = 1;
	return (PyObject*) self;
}

PyObject *
LCInt_FromInt(int *i)
{
	LCIntObject *self;
	self = PyObject_NEW(LCIntObject, &LCInt_Type);
	if (self == NULL)
		return NULL;
	self->i = i;
	self->owner = 0;
	return (PyObject*) self;
}

PyObject *
LCInt_FromIntDealloc(int *i)
{
	LCIntObject *self;
	self = PyObject_NEW(LCIntObject, &LCInt_Type);
	if (self == NULL)
		return NULL;
	self->i = i;
	self->owner = 1;
	return (PyObject*) self;
}

static PyObject *
lcint_LCInt(PyObject *self, PyObject *args)
{
	int i = 0;
	if (!PyArg_ParseTuple(args, "|i", &i))
		return NULL;
	return LCInt_New(i);
}

static struct PyMethodDef lcint_methods[] = {
	{"LCInt", lcint_LCInt, 1},
	{NULL,NULL}
};

extern "C" void
initlcint()
{
	PyObject *m, *d;
	m = Py_InitModule("lcint", lcint_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcint.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcint");
}
