#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>

static const char FIREWALL_CONFIG[] = "/etc/heimdall/firewall.conf";
static const char FIREWALL_SCRIPT[] = "/etc/heimdall/firewall.sh";

static const char K_SCRIPT_FILE[] = "script";

static const char K_FREQUENCY[] = "frequency";
static const char K_FREQUENCY_1 = 0;
static const char K_FREQUENCY_10 = 1;
static const char K_FREQUENCY_100 = 2;

static const char K_DETAILS[] = "details";
static const char K_DETAILS_NONE = 0;
static const char K_DETAILS_NORMAL = 1;
static const char K_DETAILS_MANY = 2;

static const char K_VERBOSE[] = "verbose";
static const char K_DENY_ICMP_ECHO_REQUEST[] = "deny_icmp_echo_request";
static const char K_DENY_ICMP_TIME_EXCEEDED[] = "deny_icmp_time_exceeded";


#define NETDEVICE_LENGTH	30
#define IP_ALFA			16

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _STDINT_H
        // Older glibc lack uint32_t type
        typedef unsigned int    uint32_t;
#endif

typedef struct node_data {
	struct node_data *next;
	char name[NETDEVICE_LENGTH];
	unsigned int ip;
	unsigned int netmask;
	char ip_alfa[IP_ALFA];
	char netmask_alfa[IP_ALFA];
	char deny_icmp_echo_request;	/* 0,1 */
	char deny_icmp_time_exceeded;	/* 0,1 */
	int flags;
	char RFC1918;			/* RFC1918 network ? */
	char status_if;			/* 0, 1, 2 */
	char status_fw;			/* 0, 1, 2 */
} netdevice_node;

#ifdef __cplusplus
}
#endif

#define NETDEVICE	netdevice_node *

#define STATUS_IF_INIT	0
#define STATUS_IF_DOWN	1
#define STATUS_IF_UP	2

#define STATUS_FW_INIT	0
#define STATUS_FW_DO	1
#define STATUS_FW_DONE	2

#ifdef __cplusplus
extern "C"
#endif
NETDEVICE *netdevice_read( );
#ifdef __cplusplus
extern "C"
#endif
void netdevice_clear( NETDEVICE *netdevice );
