#pragma implementation

#include <sys/utsname.h>
#include <stdlib.h>
#include <string.h>
#include <fviews.h>
#include "heartbeatconf.h"
#include "misc.h"
#include "heartbeatconf.m"

bool is_ip(const char *ip)
{
    int nums = 0;
    int points = 0;
    for(unsigned int x=0;x<strlen(ip);x++)
    {
        if(ip[x] >= '0' && ip[x] <= '9')
            nums = points + 1;
        else if (ip[x] == '.')
            points++;
        else
            return(0);
        if (nums < points)
            return(0);
    }
    if(nums == 4 && points == 3)
        return(1);
    return(0);
}

bool verify_ip(const char *ip)
{
    if(is_ip(ip))
        return(1);
    SSTRING msg;
    msg.setfromf(MSG_U(ER_NOTAVALIDIP, "%s is not a valid IP!"), ip);
    xconf_error(msg.get());
    return(0);
}

bool verify_node_ip(const char *node, const char *ip)
{
    VIEWITEMS tb;
    tb.read(file_nodes);
    int tb_size = tb.getnb();
    for(int x=tb_size-1;x>-1;x--)
    {
        SSTRING value2, item2;
        const char *line = str_skip(tb.getitem(x)->line.get());
        value2.copyword(str_skip(item2.copyword(line)));
        value2.strip_end();
        if(item2.cmp(node) != 0 && value2.cmp(ip)==0){
            SSTRING msg;
            msg.setfromf(MSG_U(ER_IPALREADYEXISTS, "The IP %s is in use by other node!"), ip);
            xconf_error(msg.get());
            return(0);
        }
    }
    return(1);
}

bool node_exists(const char *node)
{
    VIEWITEMS tb;
    tb.read(file_haconf);
    int tb_size = tb.getnb();
    for(int x=0;x<tb_size;x++)
    {
        SSTRING value, item;
        const char *line = item.copyword(str_skip(tb.getitem(x)->line.get()));
        value.copyword(str_skip(line));
        if(value.cmp(node) == 0){
            return(1);
        }
    }
    return(0);
}

bool verify_node(const char *node)
{
    if(node_exists(node))
    {
        SSTRING msg;
        msg.setfromf(MSG_U(ER_NODEALREADYEXISTS, "The node %s already exists!"), node);
        xconf_error(msg.get());
        return(1);
    }
    return(0);
}

void edit_nodes()
{
    DIALOG_RECORDS dia;
    dia.newf_head("", MSG_U(H_NODESHEAD, "Node"));
    int opt = -1;
    while(1)
    {
        SSTRING value, item;
        VIEWITEMS tb;
        tb.read(file_haconf);
        int tb_size = tb.getnb();
        int nb_items = 0;
        for(int x=0;x<tb_size;x++)
        {
            const char *line = str_skip(tb.getitem(x)->line.get());
            value.setfrom(str_skip(item.copyword(line)));
            value.strip_end();
            if(item.cmp("node") == 0){
                dia.set_menuitem(nb_items, value.get(), "");
                nb_items++;
            }
        }
        dia.remove_last(nb_items+1);
        MENU_STATUS menu = dia.editmenu(MSG_U(T_NODES, "Nodes"), MSG_U(I_NODES, "Select a node to edit its services") , help_heartbeat, opt, MENUBUT_QUIT|MENUBUT_ADD);
        SSTRING node;
        nb_items = 0;
        for(int x=0;x<tb_size;x++)
        {
            const char *line = str_skip(tb.getitem(x)->line.get());
            node.setfrom(str_skip(item.copyword(line)));
            node.strip_end();
            if(item.cmp("node") == 0){
                if (nb_items == opt)
                    break;
                nb_items++;
            }
        }
        if (menu == MENU_ADD)
            opt = -1;
        if (menu == MENU_ESCAPE || menu == MENU_QUIT)
            break;
        else if(menu == MENU_ADD){
            DIALOG dia_add;
            struct utsname _uname;
            uname(&_uname);
            const char *local_node = strtok(_uname.nodename, ".");
            SSTRING new_node;
            if(!node_exists(local_node))
                new_node.setfrom(local_node);
            dia_add.newf_str(MSG_U(F_NEWNODE, "Name of the new node"), new_node);
            dia_add.last_noempty();
            int nof = 0;
            MENU_STATUS add_menu = dia_add.edit(MSG_U(T_ADDNODE, "Adding a new node"), "", help_heartbeat, nof, MENUBUT_ACCEPT|MENUBUT_CANCEL);
            if(add_menu == MENU_ACCEPT && !verify_node(new_node.get())){
                SSTRING line, line_add;
                line.copyword(str_skip(new_node.get()));
                line_add.setfromf("node %s", line.get());
                tb.add (new VIEWITEM(line_add.get()));
                tb.write(file_haconf, NULL);
            }
        }else if(menu == MENU_OK){
            DIALOG dia_edit;
            SSTRING node_name;
            if(opt != -1){
                nb_items = 0;
                node_name.setfrom(node);
            }
            dia_edit.newf_str(MSG_U(F_NODENAME, "Name of the node"), node_name);
            dia_edit.last_noempty();
            dia_edit.setbutinfo(MENU_USR1, MSG_U(B_IPANDSERVICES, "IPs and Services"), MSG_R(B_IPANDSERVICES));
            int nof = 0;
            while(1){
                MENU_STATUS menu_edit = dia_edit.edit(MSG_U(T_EDITNODE, "Editing node"), "", help_heartbeat, nof, MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL|MENUBUT_USR1);
                if (menu_edit == MENU_QUIT || menu_edit == MENU_ESCAPE || menu_edit == MENU_CANCEL)
                    break;
                else if(menu_edit == MENU_USR1){
                    edit_ips(node.get());
                }else if(menu_edit == MENU_DEL && dialog_yesno(MSG_U(T_DEL, "Removal confirmation"), MSG_U(T_DELNODEDES, "Do you really want to remove the entire node?") , help_nil) == MENU_YES){
                    VIEWITEMS tb_nodes;
                    tb_nodes.read(file_nodes);
                    int tb_nodes_size = tb_nodes.getnb();
                    for(int x=tb_nodes_size-1;x>-1;x--)
                    {
                        SSTRING item_nodes;
                        item_nodes.copyword(str_skip(tb_nodes.getitem(x)->line.get()));
                        if(item_nodes.cmp(node.get()) == 0){
                            tb_nodes.remove_del(x);
                        }
                    }
                    tb_nodes.write(file_nodes,NULL);
                    tb_size = tb.getnb();
                    for(int x=tb_size-1;x>-1;x--)
                    {
                        SSTRING value2, item2;
                        const char *line = str_skip(tb.getitem(x)->line.get());
                        value2.setfrom(str_skip(item2.copyword(line)));
                        value2.strip_end();
                        if(item2.cmp("node") == 0 && value2.cmp(node.get())==0)
                            tb.remove_del(x);
                    }
                    tb.write(file_haconf,NULL);
                    break;
                }else if(menu_edit == MENU_ACCEPT){
                    bool exists = 0;
                    if ( node.cmp(node_name.get()) != 0 )
                        exists = verify_node(node_name.get());
                    if (!exists){
                        VIEWITEMS tb_nodes;
                        tb_nodes.read(file_nodes);
                        int tb_nodes_size = tb_nodes.getnb();
                        for(int x=tb_nodes_size-1;x>-1;x--)
                        {
                            SSTRING value2, item_nodes;
                            const char *line = str_skip(tb_nodes.getitem(x)->line.get());
                            value2.setfrom(str_skip(item_nodes.copyword(line)));
                            value2.strip_end();
                            if(item_nodes.cmp(node.get()) == 0){
                                tb_nodes.getitem(x)->line.setfromf("%s %s", node_name.get(), value2.get());
                            }
                        }
                        tb_nodes.write(file_nodes,NULL);
                        tb_size = tb.getnb();
                        for(int x=tb_size-1;x>-1;x--)
                        {
                            SSTRING value2, item2;
                            const char *line = str_skip(tb.getitem(x)->line.get());
                            value2.setfrom(str_skip(item2.copyword(line)));
                            value2.strip_end();
                            if(item2.cmp("node") == 0 && value2.cmp(node.get())==0)
                                tb.getitem(x)->line.setfromf("node %s", node_name.get());
                        }
                        tb.write(file_haconf,NULL);
                        break;
                    }
                }
            }
        }
    }
}

void edit_ips(const char *node)
{
    DIALOG_RECORDS dia;
    dia.newf_head("", MSG_U(H_IPSHEAD, "\tIP Number\tServices"));
    int opt = -1;
    while(1){
        VIEWITEMS tb;
        tb.read(file_nodes);
        int tb_size = tb.getnb();
        int nb_items = 0;
        for(int x=0;x<tb_size;x++)
        {
            SSTRING item;
            const char *line = str_skip(tb.getitem(x)->line.get());
            SSTRING value;
            line = value.copyword(str_skip(item.copyword(line)));
            if(item.cmp(node) == 0){
                SSTRING index, list_item;
                index.setfromf("%d", nb_items);
                list_item.setfromf("%s\t%s",  value.get(), line);
                dia.set_menuitem(nb_items, index.get(), list_item.get());
                nb_items++;
            }
        }
        dia.remove_last(nb_items+1);
        char title[] = "";
        sprintf(title, MSG_U(T_IPS, "Node IPs and services: %s"), node);
        MENU_STATUS menu = dia.editmenu(title, "", help_heartbeat, opt, MENUBUT_QUIT|MENUBUT_ADD);
        if (menu == MENU_ADD)
            opt = -1;
        if (menu == MENU_ESCAPE || menu == MENU_QUIT)
            break;
        else if (menu == MENU_ADD || menu == MENU_OK){
            DIALOG dia_add;
            SSTRING ip, services;
            VIEWITEM *v_item = NULL;
            if(opt != -1){
                tb_size = tb.getnb();
                nb_items = 0;
                int x;
                for(x=0;x<tb_size;x++)
                {
                    SSTRING item;
                    item.copyword(str_skip(tb.getitem(x)->line.get()));
                    if(item.cmp(node) == 0){
                        if(nb_items == opt)
                            break;
                        nb_items++;
                    }
                }
                v_item = tb.getitem(x);
                const char *ch_line = v_item->line.get();
                ch_line = ip.copyword(str_skip(ch_line));
                ch_line = ip.copyword(str_skip(ch_line));
                services.setfrom(str_skip(ch_line));
            }
            dia_add.newf_str(MSG_U(F_IP, "IP number*"), ip);
            dia_add.last_noempty();
            dia_add.newf_str(MSG_U(F_SERVICES, "Services"), services);
            int nof = 0;
            while(1){
                MENU_STATUS add_menu = dia_add.edit(MSG_U(T_ADDIPSERVICE, "Adding/Editing node IP and services"), "", help_heartbeat, nof, MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL);
                if(add_menu == MENU_ESCAPE || add_menu == MENU_QUIT || add_menu == MENU_CANCEL)
                    break;
                else if(add_menu == MENU_ACCEPT && verify_ip(ip.get()) && verify_node_ip(node, ip.get())){
                    if (opt == -1){
                        v_item = new VIEWITEM("");
                        tb.add(v_item);
                    }
                    v_item->line.setfromf("%s %s %s", node, ip.get(), services.get());
                    tb.write(file_nodes,NULL);
                    break;
                }else if(add_menu == MENU_DEL){
                    if (opt != -1){
                        tb.remove(v_item);
                        tb.write(file_nodes,NULL);
                    }
                    break;
                }
            }
        }
    }
}
