#include "internal.h"

enum VEDIT_TYPE {
	VEDIT_STR, VEDIT_NUM, VEDIT_CHK
};

class VIEWEDIT_FIELD: public ARRAY_OBJ{
	friend VIEWEDIT;
	const char *keyword;
	VIEWITEM *it;
	SSTRING val;
	int num;
	char sel;
	VEDIT_TYPE type;
	int defval;
	/*~PROTOBEG~ VIEWEDIT_FIELD */
public:
	VIEWEDIT_FIELD (const char *_keyword,
		 VIEWITEM *_it,
		 VEDIT_TYPE _type,
		 int _defval);
	void update (const char *prefix,
		 VIEWITEMS_SUB&sub);
	/*~PROTOEND~ VIEWEDIT_FIELD */
};

PUBLIC VIEWEDIT_FIELD::VIEWEDIT_FIELD(
	const char *_keyword,
	VIEWITEM *_it,
	VEDIT_TYPE _type,
	int _defval)
{
	type = _type;
	it = _it;
	defval = _defval;
	num = defval;
	sel = defval;
	keyword = _keyword;
	if (it != NULL){
		val.setfrom (viewsub_getval(it));
		num = val.getval();
		if (type == VEDIT_CHK){
			sel = val.icmp("on")==0;
		}else{
			sel = num != 0 ? 1 : 0;
		}
	}		
}

/*
	Update the configuration file with the value of the field
*/
PUBLIC void VIEWEDIT_FIELD::update (const char *prefix, VIEWITEMS_SUB &sub)
{
	if (type == VEDIT_STR && val.is_empty()){
		if (it != NULL) sub.remove_del (it);
	}else if (it == NULL
		&& ((type == VEDIT_CHK && sel == defval)
			|| (type == VEDIT_NUM && num == defval))){
		// This is the default value, and it was not already part
		// of the config file, no need to save it.
	}else{
		if (it == NULL){
			it = new VIEWITEM("");
			sub.add (it);
		}
		if (type == VEDIT_STR){
			it->line.setfromf("%s%s %s",prefix,keyword,val.get());
		}else if (type == VEDIT_NUM){
			it->line.setfromf("%s%s %d",prefix,keyword,num);
		}else if (type == VEDIT_CHK){
			it->line.setfromf("%s%s %s",prefix,keyword,sel ? "on" : "off");
		}
	}
}
	

class VIEWEDIT_FIELDS: public ARRAY{
	/*~PROTOBEG~ VIEWEDIT_FIELDS */
public:
	VIEWEDIT_FIELD *getitem (int no)const;
	/*~PROTOEND~ VIEWEDIT_FIELDS */
};

PUBLIC VIEWEDIT_FIELD *VIEWEDIT_FIELDS::getitem(int no) const
{
	return (VIEWEDIT_FIELD*)ARRAY::getitem(no);
}

PUBLIC VIEWEDIT::VIEWEDIT (
	VIEWITEMS_SUB &_sub,
	DIALOG &_dia)
	: sub(_sub), dia(_dia)
{
	tbf = new VIEWEDIT_FIELDS;
}

PUBLIC void VIEWEDIT::newf_str (
	const char *title,
	const char *keyword)
{
	VIEWITEM *it = sub.locate (keyword);
	VIEWEDIT_FIELD *field = new VIEWEDIT_FIELD (keyword,it,VEDIT_STR,0);
	tbf->add (field);
	dia.newf_str (title,field->val);
}

PUBLIC FIELD_COMBO *VIEWEDIT::newf_combo (
	const char *title,
	const char *keyword)
{
	VIEWITEM *it = sub.locate (keyword);
	VIEWEDIT_FIELD *field = new VIEWEDIT_FIELD (keyword,it,VEDIT_STR,0);
	tbf->add (field);
	return dia.newf_combo (title,field->val);
}

PUBLIC void VIEWEDIT::newf_num (
	const char *title,
	const char *keyword,
	int defval)
{
	VIEWITEM *it = sub.locate (keyword);
	VIEWEDIT_FIELD *field = new VIEWEDIT_FIELD (keyword,it,VEDIT_NUM,defval);
	tbf->add (field);
	dia.newf_num (title,field->num);
}

PUBLIC void VIEWEDIT::newf_num (
	const char *title,
	const char *keyword)
{
	newf_num (title,keyword,0);
}


PUBLIC void VIEWEDIT::newf_chk (
	const char *title,
	const char *keyword,
	const char *intro,
	int defval)
{
	VIEWITEM *it = sub.locate (keyword);
	VIEWEDIT_FIELD *field = new VIEWEDIT_FIELD (keyword,it,VEDIT_CHK,defval);
	tbf->add (field);
	dia.newf_chk (title,field->sel,intro);
}

PUBLIC void VIEWEDIT::newf_chk (
	const char *title,
	const char *keyword,
	const char *intro)
{
	newf_chk (title,keyword,intro,0);
}


PUBLIC void VIEWEDIT::update (const char *prefix)
{
	for (int i=0; i<tbf->getnb(); i++){
		VIEWEDIT_FIELD *f = tbf->getitem(i);
		f->update (prefix,sub);
	}
}


PUBLIC void VIEWEDIT::newf_title (const char *s1, const char *s2)
{
	dia.newf_title(s1,s2);
}

PUBLIC void VIEWEDIT::newf_title (
	const char *s1,
	int level,
	const char *s2,
	const char *s3)
{
	dia.newf_title(s1,level,s2,s3);
}

