#!/bin/sh
# This script try to stuff linuxconf base configuration out
# of redhat specific configuration files
# On redhat 5.1 and above, no need for that as linuxconf is aware
# of the distribution specific files.

ver=5.1
if [ -f /etc/redhat-release ] ; then
	read a b c d e f </etc/redhat-release
	if [ "$a" = "release" ] ; then
		ver=$b
	elif [ "$b" = "release" ] ; then
		ver=$c
	elif [ "$c" = "release" ] ; then
		ver=$d
	elif [ "$d" = "release" ] ; then
		ver=$e
	fi
fi
case $ver in
	4.*)
		;;
	5.0)
		;;
	*)
		exit 0
		;;
esac
echo Probing RedHat specific information
echo
. /etc/sysconfig/network
if [ "$NETWORKING" = "yes" ] ; then
	echo Networking is enabled
	if [ "$DEVICE" = "" -a -f /etc/sysconfig/network-scripts/ifcfg-eth0 ]
	then
		DEVICE=eth0
	fi
	if [ "$DEVICE" != "" ] ; then
		if [ "$DEVICE" = "" ] ; then
			echo No main network device
			netconf --setdevdef 0 $HOSTNAME 127.0.0.1 "" ""
		else
			echo "Main network device  is" $DEVICE
			. /etc/sysconfig/network-scripts/ifcfg-$DEVICE
			echo "Setting hostname     to" $HOSTNAME
			echo "Setting IP address   to" $IPADDR
			echo "Setting netmask      to" $NETMASK
			netconf --setdevdef 0 $HOSTNAME $IPADDR $NETMASK $DEVICE
			if [ "$GATEWAY" != ""  -a "$GATEWAY" != "localhost" ] ; then
				netconf --setgateway $GATEWAY
				echo "Setting gateway      to" $GATEWAY
			fi
		fi
	else
		echo No main network device
		netconf --setdevdef 0 $HOSTNAME 127.0.0.1 "" ""
	fi
else
	echo Networking disabled
	netconf --setdevdef 0 $HOSTNAME 127.0.0.1 "" ""
fi

# Now linuxconf read these file directly under redhat
# because of the distribution specific module: redhat
#. /etc/sysconfig/clock
#if [ "$UTC" != "" ] ; then
#	if [ "$UTC" = "true" ] ; then
#		echo "CMOS clock mode set  to GMT"
#		netconf --setclockmode GMT
#	else
#		echo "CMOS clock mode set  to" local
#		netconf --setclockmode local
#	fi
#elif [ "$CLOCKMODE" != "" ] ; then
#	echo "CMOS clock mode set  to" $CLOCKMODE
#	netconf --setclockmode $CLOCKMODE
#else
#	echo "CMOS clock mode set  to" local
#	netconf --setclockmode local
#fi

#if [ -f /etc/sysconfig/keyboard ] ; then
#	. /etc/sysconfig/keyboard
#	if [ "$KEYTABLE" = "" ] ; then
#		echo No keytable defined
#	else
#		echo Keyboard mapping set to $KEYTABLE
#		linuxconf --setkeymap $KEYTABLE
#	fi
#fi

