/* #Specification: USERACCT_COMNG / principles
	The class USERACCT_COMNG (User Account Co-manager) allows any
	components or module to
	to enhance another dialog. The dialog has to be USERACCT_COMNG
	aware, but this represents minor work. So far, this has been
	applied to the user account dialog (thus the name of the class).
	The component may define new
	fields (generally in a new section) and proper functions are called
	to do the various validations.

	An object of the class REGISTER_USERACCT_COMNG must be defined
	with a pointer to a function creating a USERACCT_COMNG or not.
	If a component do not want to participate in the management
	of a specific dialog or user type, the function return NULL.

	Normally the fonction return an instance of a class derived
	from USERACCT_COMNG.
*/
#pragma implementation
#include "usercomng.h"
#include "userconf.h"
#include <modapi.h>

PUBLIC USERACCT_COMNG::USERACCT_COMNG (DICTIONARY &_dict)
	:dict (_dict)
{
}

/*
	Define new field in the dialog
*/
PUBLIC VIRTUAL void USERACCT_COMNG::setupdia (
	DIALOG &dia)
{
	M_DIALOG m_dia (&dia);
	setupdia (m_dia);
}
/*
	Define new field in the dialog
*/
PUBLIC VIRTUAL void USERACCT_COMNG::setupdia (
	M_DIALOG &)		// dia
{
}
/*
	Validate the various fields.
	Return -1 if any error.
*/
PUBLIC VIRTUAL int USERACCT_COMNG::validate (
	DIALOG &dia,
	int &nof)			// Will point to the line with the error
{
	M_DIALOG m_dia (&dia);
	return validate (m_dia,nof);
}
/*
	Validate the various fields.
	Return -1 if any error.
*/
PUBLIC VIRTUAL int USERACCT_COMNG::validate (
	M_DIALOG &,		// dia
	int &)			// nof: Will point to the line with the error
{
	return 0;
}
/*
	Save the content of the dialog since the user has commited the changes.
*/
PUBLIC VIRTUAL int USERACCT_COMNG::save (
	PRIVILEGE *)
{
	return 0;
}

/*
	The user account has been deleted, so we may want to do some
	cleanup in out own structures.

	Return -1 if this account can't be deleted
*/
PUBLIC VIRTUAL int USERACCT_COMNG::deluser (
	PRIVILEGE *)
{
	return 0;
}

PUBLIC USERACCT_COMNG *USERACCT_COMNGS::getitem (int no) const
{
	return (USERACCT_COMNG*)ARRAY::getitem(no);
}

PUBLIC int USERACCT_COMNGS::validate (
	DIALOG &dia,
	int &nof)
{
	int ret = 0;
	int n=getnb();
	for (int i=0; i<n && ret != -1; i++){
		ret = getitem(i)->validate (dia,nof);
	}
	return ret;
}
PUBLIC int USERACCT_COMNGS::validate (
	M_DIALOG &dia,
	int &nof)
{
	int ret = 0;
	int n=getnb();
	for (int i=0; i<n && ret != -1; i++){
		ret = getitem(i)->validate (dia,nof);
	}
	return ret;
}
PUBLIC void USERACCT_COMNGS::setupdia (
	DIALOG &dia)
{
	for (int i=0; i<getnb(); i++){
		getitem(i)->setupdia (dia);
	}
}
PUBLIC void USERACCT_COMNGS::setupdia (
	M_DIALOG &dia)
{
	setupdia (*(dia.real));
}

PUBLIC void USERACCT_COMNGS::save (
	PRIVILEGE *priv)
{
	for (int i=0; i<getnb(); i++){
		getitem(i)->save (priv);
	}
}

PUBLIC void USERACCT_COMNGS::deluser (
	PRIVILEGE *priv)
{
	for (int i=0; i<getnb(); i++){
		getitem(i)->deluser (priv);
	}
}



static REGISTER_USERACCT_COMNG *first;

PUBLIC REGISTER_USERACCT_COMNG::REGISTER_USERACCT_COMNG(
	USERACCT_COMNG *(fct)(const char *key, DICTIONARY &))
{
	next = first;
	first = this;
	this->fct = fct;
}

/*
	Get all the USER account co-manager from the modules.
	They are placed in the table cos
*/
PUBLIC void USERACCT_COMNGS::getall (
	const char *key)
{
	REGISTER_USERACCT_COMNG *pt = first;
	while (pt != NULL){
		USERACCT_COMNG *co = pt->fct(key,dict);
		if (co != NULL) add (co);
		pt = pt->next;
	}
}

/*
	Add/redefine a string value in the dictionary
	get_str() must be used to retrieve it.
*/
PUBLIC void USERACCT_COMNGS::set_str (const char *var, const char *val)
{
	dict.set_str (var,val);
}

PUBLIC const char *USERACCT_COMNGS::get_str (const char *var) const
{
	return dict.get_str (var);
}

/*
	Add/redefine a numerical value in the dictionary
	get_int() must be used to retrieve it.
*/
PUBLIC void USERACCT_COMNGS::set_int (const char *var, int val)
{
	dict.set_int (var,val);
}


PUBLIC int USERACCT_COMNGS::get_int (const char *var) const
{
	return get_int (var);
}

/*
	Add/redefine a pointer to an object
	get_obj() must be used to retrieve it.
*/
PUBLIC void USERACCT_COMNGS::set_obj (const char *var, void *obj)
{
	dict.set_obj (var,obj);
}


PUBLIC void *USERACCT_COMNGS::get_obj (const char *var) const
{
	return dict.get_obj (var);
}

/*
	Add/redefine a boolean value in the dictionary
	get_bool() must be used to retrieve it.
*/
PUBLIC void USERACCT_COMNGS::set_bool (const char *var, bool val)
{
	dict.set_bool (var,val);
}


PUBLIC bool USERACCT_COMNGS::get_bool (const char *var) const
{
	return dict.get_bool (var);
}

