#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <errno.h>
#include <sys/stat.h>
#include <pwd.h>

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc != 3){
		fprintf (stderr,"fileowner file domain\nPrint the owner of a file\n");
	}else{
		struct stat st;
		if (stat (argv[1],&st)!=-1){
			const char *domain = argv[2];
			if (strcmp(domain,"/")==0){
				struct passwd *p = getpwuid (st.st_uid);
				if (p != NULL){
					printf ("%s\n",p->pw_name);
					ret = 0;
				}
			}else{
				char path[PATH_MAX];
				snprintf (path,sizeof(path)-1,"/etc/vmail/passwd.%s",domain);
				FILE *fin = fopen (path,"r");
				if (fin == NULL){
					fprintf (stderr,"Can't open password file %s\n",path);
				}else{
					struct passwd *p;
					while ((p=fgetpwent(fin))!=NULL){
						if (p->pw_uid == st.st_uid){
							printf ("%s\n",p->pw_name);
							ret = 0;
							break;
						}
					}
					fclose (fin);
				}
			}
			if (ret != 0){
				fprintf (stderr
					,"No corresponding user name for user id %d in domain %s\n"
					,st.st_uid,domain);
			}
		}else{
			fprintf (stderr,"Can't stat file %s (%s)\n",argv[1]
				,strerror(errno));
		}
	}
	return ret;
}

