#pragma interface
#ifndef TLMPNET_H
#define TLMPNET_H

#include <stdio.h>
#include <sys/types.h>

class HANDLE_SELECTS{
public:
	virtual void process_select (int select_ret,
		 fd_set&set,
		 long timeout) = 0;
	virtual int setup_select (fd_set&set, int max_handle)=0;

};


struct TCPCONNECT_INFO{
	const char *host;
	const char *port;
	int handle;				// socket handle
};

#define _TLMP_TCPCONNECT

struct _F_TCPCONNECT{
	class TCPCONNECT_PRIVATE *priv;
	void settcpnodelay(bool on);
	int send (const char *s);
	int send (const void *b, int len);
	int sendf (const char *ctl, ...);
	#define _F_TCPCONNECT_init(x) void x init(bool &end, TCPCONNECT_INFO &info)
	virtual _F_TCPCONNECT_init( );
	#define _F_TCPCONNECT_fail(x) void x fail(TCPCONNECT_INFO &info)
	virtual _F_TCPCONNECT_fail( );
	#define _F_TCPCONNECT_oneline(x) void x oneline(const char *line, bool &end, TCPCONNECT_INFO &info)
	virtual _F_TCPCONNECT_oneline( )=0;
	#define _F_TCPCONNECT_time_out(x) void x time_out(bool &end, TCPCONNECT_INFO &info)
	virtual _F_TCPCONNECT_time_out( );
	#define _F_TCPCONNECT_end(x) void x end(TCPCONNECT_INFO &info)
	virtual _F_TCPCONNECT_end( );
};

class TCPCONNECT: public HANDLE_SELECTS{
	class TCPCONNECT_PRIVATE *priv;
	/*~PROTOBEG~ TCPCONNECT */
public:
	TCPCONNECT (_F_TCPCONNECT&c,
		 const char *host,
		 const char *port);
	bool is_ok (void);
	int loop (int time_out);
	int poll (void);
private:
	void process_lines (void);
public:
	void process_select (int select_ret,
		 fd_set&set,
		 long timeout);
	int reconnect (const char *newhost,
		 const char *newport);
	int reconnect (void);
	int send (const char *line);
	int send (const void *buf, int len);
	int sendf (const char *ctl, ...);
	void settcpnodelay (bool on);
	int setup_select (fd_set&set, int max_handle);
	virtual ~TCPCONNECT (void);
	/*~PROTOEND~ TCPCONNECT */
};


#define _TLMP_tcpconnect

struct _F_tcpconnect{
	class tcpconnect_private *priv;
	void settcpnodelay(bool on);
	int send (const char *s);
	int send (const void *b, int len);
	int sendf (const char *ctl, ...);
	#define _F_tcpconnect_init(x) void x init(bool &end, TCPCONNECT_INFO &info)
	virtual _F_tcpconnect_init( );
	#define _F_tcpconnect_fail(x) void x fail(TCPCONNECT_INFO &info)
	virtual _F_tcpconnect_fail( );
	#define _F_tcpconnect_oneline(x) void x oneline(const char *line, bool &end, TCPCONNECT_INFO &info)
	virtual _F_tcpconnect_oneline( )=0;
	#define _F_tcpconnect_time_out(x) void x time_out(bool &end, TCPCONNECT_INFO &info)
	virtual _F_tcpconnect_time_out( );
	#define _F_tcpconnect_end(x) void x end(TCPCONNECT_INFO &info)
	virtual _F_tcpconnect_end( );
};

#define _TLMP_TCPSERVER

struct TCPSERVER_INFO{
	const char *port;
};

struct _F_TCPSERVER{
	class TCPSERVER_PRIVATE *priv;
	void settcpnodelay(bool on);
	int send (const char *s);
	int send (const void *b, int len);
	int sendf (const char *ctl, ...);
	void set_timeout (int nbseconds);
	void forgetclient();
	int getnbclients();
	#define _F_TCPSERVER_newclient(x) void x newclient(int no, unsigned long from, bool &endclient, bool &endserver, TCPSERVER_INFO &info)
	virtual _F_TCPSERVER_newclient( )=0;
	#define _F_TCPSERVER_endclient(x) void x endclient(int no, bool &endserver, TCPSERVER_INFO &info)
	virtual _F_TCPSERVER_endclient( );
	#define _F_TCPSERVER_receive(x) void x receive(int no, const char *line, bool &endclient, bool &endserver, int &state, TCPSERVER_INFO &info)
	virtual _F_TCPSERVER_receive( )=0;
	#define _F_TCPSERVER_idle(x) void x idle(int since, bool &endserver, TCPSERVER_INFO &info)
	virtual _F_TCPSERVER_idle( );
	#define _F_TCPSERVER_time_out(x) void x time_out(int no, bool &endserver, TCPSERVER_INFO &info)
	virtual _F_TCPSERVER_time_out( );
};

class TCPSERVER: public HANDLE_SELECTS{
	class TCPSERVER_PRIVATE *priv;
	/*~PROTOBEG~ TCPSERVER */
public:
	TCPSERVER (_F_TCPSERVER&c,
		 const char *port,
		 int time_out);
	TCPSERVER (_F_TCPSERVER&c, int port, int time_out);
private:
	bool dispatch (int ok, int newclient);
	void endsession (int cli);
public:
	int getnbclients (void)const;
	void loop (void);
	void process_select (int select_ret,
		 fd_set&set,
		 long timeout);
	int setup_select (fd_set&set, int max_handle);
	virtual ~TCPSERVER (void);
	/*~PROTOEND~ TCPSERVER */
};

class POPENFD;
#define _TLMP_POPENHANDLER

struct _F_POPENHANDLER{
	class POPENHANDLER_PRIVATE *priv;
	#define _F_POPENHANDLER_oneline(x) void x oneline (POPENFD *pop, const char *line, int noline)
	virtual _F_POPENHANDLER_oneline( )=0;
	#define _F_POPENHANDLER_oneerr(x) void x oneerr (POPENFD *pop, const char *line)
	virtual _F_POPENHANDLER_oneerr( );
	#define _F_POPENHANDLER_end(x) void x end (POPENFD *pop)
	virtual _F_POPENHANDLER_end( );
};

class POPENHANDLER: public HANDLE_SELECTS{
	class POPENHANDLER_PRIVATE *priv;
	/*~PROTOBEG~ POPENHANDLER */
public:
	POPENHANDLER (_F_POPENHANDLER&c);
	void add (POPENFD *pop);
	int getrunning (void);
	void process_select (int select_ret,
		 fd_set&set,
		 long timeout);
	int setup_select (fd_set&set, int max_handle);
	virtual ~POPENHANDLER (void);
	/*~PROTOEND~ POPENHANDLER */
};

#define _TLMP_NETEVENT_MANAGER

struct _F_NETEVENT_MANAGER{
	class NETEVENT_MANAGER_PRIVATE *priv;
	#define _F_NETEVENT_MANAGER_idle(x) void x idle(int since, bool &end, bool nojob)
	virtual _F_NETEVENT_MANAGER_idle( );
};

class NETEVENT_MANAGER{
	class NETEVENT_MANAGER_PRIVATE *priv;
	/*~PROTOBEG~ NETEVENT_MANAGER */
public:
	NETEVENT_MANAGER (_F_NETEVENT_MANAGER&c);
	void add (HANDLE_SELECTS&sels);
	void loop (int timeout);
	~NETEVENT_MANAGER (void);
	/*~PROTOEND~ NETEVENT_MANAGER */
};


#include "tlmpnet.p"

#endif



