#include <sys/types.h>
#include <dirent.h>
#include <popen.h>
#include "tlmplib.h"
#include "tlmplib.m"
#include <string.h>

struct _F_walkfs_private{
	bool mustend;
	_F_walkfs_private(){
		mustend = false;
	}
};

bool _F_walkfs::recurse(const char *, const char *, const char *, int)
{
	return true;
}

void _F_walkfs::end()
{
	priv->mustend = true;
}


static int walkfs_priv (_F_walkfs &c, int baselen, const char *dirpath, int depth)
{
	int ret = -1;
	DIR *dir = opendir (dirpath);
	if (dir != NULL){
		ret = 0;
		struct dirent *ent;
		int next_depth = depth+1;
		while (!c.priv->mustend && (ent = readdir (dir)) != NULL){
			if (strcmp(ent->d_name,".")!=0
				&& strcmp(ent->d_name,"..")!=0){
				char path[PATH_MAX],basename[PATH_MAX];
				// We grab a copy so sub-function may use readdir as well			
				strcpy (basename,ent->d_name);
				snprintf (path,sizeof(path)-1,"%s/%s",dirpath,basename);
				const char *relpath = path + baselen;
				c.onefile (path,basename,relpath,depth);
				if (file_type(path)==1
					&& c.recurse(path,basename,relpath,depth)){
					// This is a directory and we are allowed to recurse
					ret += walkfs_priv (c,baselen,path,next_depth);
				}
				ret ++;
			}
		}
		closedir (dir);
	}
	return ret;
}

int walkfs (_F_walkfs &c, const char *dirpath)
{
	_F_walkfs_private priv;
	c.priv = &priv;
	return walkfs_priv (c,strlen(dirpath)+1,dirpath,0);
}


class _F_walkpopen_private {
public:
	POPEN *pop;
	FILE *fout;
};

int _F_walkpopen::oneerr(const char *, const char *, FILE *)
{
	return 0;
}
void _F_walkpopen::start(FILE *, bool &)
{
}
void _F_walkpopen::end()
{
}
void _F_walkpopen::empty(const char *)
{
}
void _F_walkpopen::fail(const char *cmd)
{
	tlmp_error (MSG_U(E_CANTEXEC,"Can't execute command %s\n"),cmd);
}

void _F_walkpopen::close_input()
{
	priv->pop->close();
	priv->fout = NULL;
}

void _F_walkpopen::init(FILE *, bool &)
{
}

static int walkpopen_common (
	_F_walkpopen &c,
	POPEN &pop,
	int timeout,
	const char *command)
{
	_F_walkpopen_private priv;
	priv.pop = &pop;
	c.priv = &priv;
	int ret = -1;
	if (pop.isok()){
		ret = 0;
		bool end = false;
		priv.fout = pop.getfout();
		c.init (priv.fout,end);
		bool start_called = false;
		while (!end){
			char buf[PATH_MAX];
			while (pop.readout(buf,sizeof(buf))!=-1){
				int last = strlen(buf) - 1;
				if (last >= 0 && buf[last] == '\n') buf[last] = '\0';
				if (ret == 0){
					c.start(priv.fout,end);
					start_called = true;
				}
				if (c.oneline (buf,ret,priv.fout)==-1){
					ret = -1;
					break;
				}
				ret ++;
			}
			while (pop.readerr(buf,sizeof(buf))!=-1){
				int last = strlen(buf) - 1;
				if (last >= 0 && buf[last] == '\n') buf[last] = '\0';
				if (c.oneerr (buf,command,priv.fout)==-1){
					ret = -1;
					break;
				}
			}
			if (pop.wait(timeout)< 0) break;
		}
		if (ret == 0){
			c.empty(command);
		}else if (start_called){
			c.end();
		}
	}else{
		c.fail(command);
	}
	return ret;

}

int walkpopen (
	_F_walkpopen &c,
	const char *command,
	int timeout)
{
	POPEN pop (command);
	return walkpopen_common (c,pop,timeout,command);
}
int walkpopen (
	_F_walkpopen &c,
	const char *command,
	const char *arg,
	int timeout)
{
	POPEN pop (command,arg);
	SSTRING full;
	full.setfromf ("%s %s",command,arg);
	return walkpopen_common (c,pop,timeout,full.get());
}

int walkpopen (
	_F_walkpopen &c,
	const char *command,
	int timeout,
	bool user)
{
	if (user){
		POPENUSER pop (command);
		return walkpopen_common (c,pop,timeout,command);
	}else{
		POPEN pop (command);
		return walkpopen_common (c,pop,timeout,command);
	}
}

