#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <limits.h>
#include <misc.h>
#include <dialog.h>
#include <translat.h>
#include "tlmplib.h"
#include "tlmplib.m"

void _F_tlmpprogram::showerror(const char *msg)
{
	fprintf (stderr,"%s",msg);
}

/*
	No argument by default
*/
int _F_tlmpprogram::onearg(const char *, const char *)
{
	return -1;
}

/*
	Main called when there is no argument.
	the default call the usage function
	If a program may be called with and without argument, its main_noarg
	function just have to call main(0,NULL);
*/
int _F_tlmpprogram::main_noarg()
{
	usage();
	return -1;
}
/*
	Main called when there is 1 or more arguments.
	the default call the usage function
*/
int _F_tlmpprogram::main(int, char *[])
{
	usage();
	return -1;
}

static _F_tlmpprogram *ctx;
static void tlmpprogram_error (const char *msg)
{
	ctx->showerror (msg);
}

static int tlmpprogram_loadif (
	const char *path,
	const char *lang,
	SSTRINGS &dir,
	const char *pkg)
{
	int ret = -1;
	int nb = dir.getnb();
	int len = strlen(pkg);
	for (int i=0; i<nb; i++){
		const char *f = dir.getitem(i)->get();
		if (strncmp(pkg,f,len)==0
			&& (f[len] == '\0' || f[len] == '-')){
			translat_load (path,"LINUXCONF_DICT",f,"LINUXCONF_LANG",lang);
			ret = 0;
			break;
		}
	}
	return ret;
}

int tlmpprogram (
	_F_tlmpprogram &c,
	const char *progname,
	int argc,
	char *argv[],
	const char *packages[])
{
	ctx = &c;
	diagui_seticonpath ("/usr/lib/tlmp/images");
	diagui_seticonpath ("/usr/share/icons");
	diagui_seticonpath ("/usr/share/icons/mini");
	diagui_seticonpath ("/usr/lib/linuxconf/images");
	tlmp_seterrorfct (tlmpprogram_error);
	{
		// Set the default configuration file for this program
		const char *home = getenv ("HOME");
		if (home != NULL){
			SSTRING path;
			path.setfromf("%s/.tlmp",home);
			mkdir (path.get(),0700);	// Make sure the sub-dir is created
			path.setfromf("%s/.tlmp/%s.conf",home,progname);
			linuxconf_setdbpath (path.get());
		}
	}
	const char *lang = linuxconf_getlang();
	linuxconf_loadlibmsg ("/usr/lib/linuxconf-lib");
	// translat_load ("/usr/lib/tlmp/help","tlmp", lang);

	// Load the various dictionary files
	// Assumes all dictionnary are located in /usr/lib/tlmp/help.lang
	// or in the linuxconf project
	SSTRINGS tbtlmp,tblinuxconf;
	dir_getlist ("/usr/lib/tlmp/help.eng",".eng",tbtlmp);
	dir_getlist ("/usr/lib/linuxconf/help.eng",".eng",tblinuxconf);
	for (int i=0; packages[i] != NULL; i++){
		const char *pkg = packages[i];
		if (tlmpprogram_loadif ("/usr/lib/tlmp/help",lang,tbtlmp,pkg)==-1){
			tlmpprogram_loadif ("/usr/lib/linuxconf/help",lang,tblinuxconf,pkg);
		}
	}
	translat_checkmissing();
	int i;
	int errarg = 0;
	argc = dialog_parseuioptions(argc,argv);
	bool help_requested = false;
	for (i=1; i<argc; i++){
		const char *arg = argv[i];
		if (strcmp(arg,"--help")==0){
			c.usage();
			help_requested = true;
		}else if (arg[0] == '-' && arg[1] == '-'){
			if (arg[2] == '\0'){
				// This acts as a marker to end argument parsing
				i++;
				break;
			}else{
				const char *val = "";
				int ok = 0;
				if (i < argc-1){
					val = argv[i+1];
					if (val[0] == '-' && val[1] == '-'){
						ok = c.onearg (arg,"");
					}else{
						ok = c.onearg (arg,val);
						if (ok == 1){
							i++;
						}
					}
				}else{
					ok = c.onearg (arg,"");
				}
				if (ok == -1){
					fprintf (stderr,MSG_U(E_IVLDARG,"Invalid argument: %s\n"),arg);
					errarg++;
				}
			}
		}else{
			break;
		}
	}
	int ret = -1;
	if (help_requested){
		ret = 0;
	}else{
		if (errarg > 0){
			c.usage();
		}else if (argc == i){
			ret = c.main_noarg();
		}else{
			ret = c.main (argc-i,argv+i);
		}
	}
	tlmp_seterrorfct (NULL);
	return ret;
}

int tlmpprogram (
	_F_tlmpprogram &c,
	const char *progname,
	int argc,
	char *argv[],
	const char *package)
{
	const char *packages[]={package,NULL};
	return tlmpprogram (c,progname,argc,argv,packages);
}

static const char *tlmpprogram_getprog(char *argv[])
{
	const char *progname = strrchr(argv[0],'/');
	if (progname == NULL){
		progname = argv[0];
	}else{
		progname++;
	}
	return progname;
}


int tlmpprogram (
	_F_tlmpprogram &c,
	int argc,
	char *argv[],
	const char *package)
{
	const char *progname = tlmpprogram_getprog(argv);
	return tlmpprogram (c,progname,argc,argv,package);
}

int tlmpprogram (
	_F_tlmpprogram &c,
	int argc,
	char *argv[],
	const char *packages[])
{
	const char *progname = tlmpprogram_getprog(argv);
	return tlmpprogram (c,progname,argc,argv,packages);
}

int tlmpprogram (
	_F_tlmpprogram &c,
	int argc,
	char *argv[])
{
	const char *progname = tlmpprogram_getprog(argv);
	static const char *packages[]={NULL};
	return tlmpprogram (c,progname,argc,argv,packages);
}
