#pragma implementation
#include <stdarg.h>
#include <stdio.h>
#include "tlmplib.h"

static void (*errfct)(const char *)=NULL;

void tlmp_seterrorfct (void (*fct)(const char *errmsg))
{
	errfct = fct;
}


void tlmp_error (const char *msg, ...)
{
	va_list list;
	va_start (list,msg);
	if (errfct != NULL){
		char tmp[2000];
		vsnprintf (tmp,sizeof(tmp)-1,msg,list);
		(*errfct)(tmp);
	}else{
		vfprintf (stderr,msg,list);
	}
	va_end (list);
}

