#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <misc.h>
#include <sstream.h>
#include "tlmplib.h"
#include "tlmplib.m"

void _F_loadfile::empty()
{
}
void _F_loadfile::start()
{
}
void _F_loadfile::end(off_t)
{
}
void _F_loadfile::missing(const char *fname)
{
	tlmp_error (MSG_U(E_CANTOPEN,"Can't open file %s (%s)\n")
		,fname,strerror(errno));
}

int loadfile (_F_loadfile &c, SSTREAM &ss, bool strip)
{
	c.priv = NULL;
	int ret = 0;
	char buf[1000];
	off_t lastpos = ss.getoffset();
	while (ss.gets(buf,sizeof(buf)-1)!=NULL){
		if (ret == 0) c.start();
		if (strip) strip_end (buf);
		if (c.oneline (buf,lastpos,ret)==-1){
			break;
		}
		lastpos = ss.getoffset();
		ret++;
	}
	if (ret == 0){
		c.empty();
	}else{
		c.end (ss.getoffset());
	}
	return ret;
}

int loadfile (_F_loadfile &c, const char *fname, bool strip)
{
	int ret = -1;
	FILE *fin = fopen(fname,"r");
	if (fin == NULL){
		c.missing (fname);
	}else{
		SSTREAM_FILE ss(fin);
		ret = loadfile (c,ss,strip);
		fclose (fin);
	}
	return ret;
}
void _F_savefile::start(FILE *, const char *){}
void _F_savefile::end(FILE *, const char *){}
void _F_savefile::openfail(const char *fname)
{
	tlmp_error (MSG_R(E_CANTOPEN),fname,strerror(errno));
}


int savefile (_F_savefile &c, const char *fname, bool append)
{
	c.priv = NULL;
	int ret = -1;
	FILE *fout = fopen(fname,append ? "a" : "w");
	if (fout == NULL){
		c.openfail (fname);
	}else{
		c.start(fout,fname);
		ret = c.dowrite (fout,fname);
		fflush (fout);
		c.end(fout,fname);
		if (fclose (fout) == -1) ret = -1;
	}
	return ret;
}


