#include <stdlib.h>
#include <ctype.h>
#include "tlmpdia.h"
#include "tlmpdia.m"
#include <proto.h>

class ENTRY;

class ENTRIES: public ARRAY{
	/*~PROTOBEG~ ENTRIES */
public:
	ENTRY *getitem (int no)const;
	/*~PROTOEND~ ENTRIES */
};

PUBLIC ENTRY *ENTRIES::getitem(int no) const
{
	return (ENTRY*)ARRAY::getitem(no);
}

class ENTRY: public ARRAY_OBJ{
public:
	ENTRIES entries;
	SSTRING name;
	/*~PROTOBEG~ ENTRY */
	/*~PROTOEND~ ENTRY */
};

struct EDITTREE_PRIVATE{
	ENTRY top;
	ENTRIES *loading;	// The entries currently beeing loaded
	DIALOG dia;
};


void _F_edittree::new_subdir(const char *name)
{
	priv->dia.gui_passthrough (P_Treesub,"1 \"\" %s",name);
}
void _F_edittree::end_subdir()
{
	priv->dia.gui_end();
}
void _F_edittree::new_file(const char *name)
{
	priv->dia.gui_passthrough (P_Treeelem,"\"\" %s",name);
}

/*
	Parse a path like 1/22/3
*/
static int tree_parse (const char *id, int ipath[], int maxlevel)
{
	int ret = 0;
	while (ret < maxlevel && isdigit(*id)){
		ipath[ret++] = atoi(id);
		id = str_skipdig(id);
		if (*id == '/') id++;
	}
	return ret;
}

void edittree (
	_F_edittree &c,
	const char *title,
	const char *intro,
	HELP_FILE &help)
{
	dialog_clear();		// Make sure the UI toolkit is initialised
	EDITTREE_PRIVATE priv;
	c.priv = &priv;
	priv.dia.gui_passthrough(P_Treemenu,"tree $mode=1");
	priv.loading = &priv.top.entries;
	c.load(0,"",NULL);
	priv.dia.gui_end();
	int nof = 0;
	while (1){
		MENU_STATUS code = priv.dia.edit (title,intro,help,nof);
fprintf (stderr,"code = %d\n",code);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
		}else if (code == MENU_NULL){
			const char *id = diagui_getlast_actionid();
			if (id != NULL){
				fprintf (stderr,"action :%s:\n",id);
				if (id[0] == '+'){
					// We expand a directory
					int ipath[20];
					int level = tree_parse (id+1,ipath,20);
				}else{
					// We want to do something with the selected item
					int ipath[20];
					int level = tree_parse (id,ipath,20);
					SSTRING path;
					ENTRY *ent = &priv.top;
					for (int i=0; i<level; i++){
						int no = ipath[level];
						ENTRY *sub = ent->entries.getitem(no);
						if (sub == NULL){
							break;
						}else{
							if (!path.is_empty()) path.append ("/");
							path.append (sub->name.get());
							ent = sub;
						}
					}
					c.editone (path.get(),ipath,level);
				}
			}
		}
	}
}

