#!/bin/sh
. /usr/lib/linuxconf/install/rpm-identdist.sh

echo "#### /usr/lib/linuxconf/install/rpm-preuninst.sh" >>/tmp/linuxconf-rpmuninstall.log
date >>/tmp/linuxconf-rpmuninstall.log

log(){
	echo $* >>/tmp/linuxconf-rpmuninstall.log
	$*
}

log rm -f $OLDINSTALL
log rm -f $GRABNOTICE

if [ "$1" = 0 ] ; then
# Restore Original /etc/rc.d/rc.sysinit
	if [ ! `grep $PATHRCINIT /usr/lib/linuxconf/uninstall/options` ] ; then
		if [ -f $PATHRCINIT.beforelinuxconf ] ; then
			log rm -f $PATHRCINIT
			log mv $PATHRCINIT.beforelinuxconf $PATHRCINIT
		elif [ -f /usr/lib/linuxconf/uninstall/$RCINIT.beforelinuxconf ] ; then
			log rm -f $PATHRCINIT
			log mv /usr/lib/linuxconf/uninstall/$RCINIT.beforelinuxconf $PATHRCINIT	
		fi
	fi

# Restore Original /etc/rc.d/rc file
	if [ ! `grep $PATHRC /usr/lib/linuxconf/uninstall/options` ] ; then
		if [ -f $PATHRC.beforelinuxconf ] ; then
			log rm -f $PATHRC
			log mv $PATHRC.beforelinuxconf $PATHRC
		elif [ -f /usr/lib/linuxconf/uninstall/rc.beforelinuxconf ] ; then
			log rm -f $PATHRC
			log mv /usr/lib/linuxconf/uninstall/rc.beforelinuxconf $PATHRC
		fi
	fi


# Restore original /usr/bin/passwd
	if [ -f /usr/bin/passwd.beforelinuxconf ] ; then
		log rm -f /usr/bin/passwd
		log mv /usr/bin/passwd.beforelinuxconf /usr/bin/passwd
	elif [ -f /usr/lib/linuxconf/uninstall/passwd.beforelinuxconf ] ; then
		log rm -f /usr/bin/passwd
		log mv /usr/lib/linuxconf/uninstall/passwd.beforelinuxconf /usr/bin/passwd
	fi

# Restore Original /etc/services file
	if [ ! `grep /etc/services /usr/lib/linuxconf/uninstall/options` ] ; then
		if [ -f /etc/services.beforelinuxconf ] ; then
			log rm -f /etc/services
			log mv /etc/services.beforelinuxconf /etc/services
		elif [ -f /usr/lib/linuxconf/uninstall/services.beforelinuxconf ] ; then
			log rm -f /etc/services
			log mv /usr/lib/linuxconf/uninstall/services.beforelinuxconf /etc/services
		fi
	fi

# Restore Original /etc/inetd.conf file
	if [ -f /etc/inetd.conf ] ; then
		if [ ! `grep /etc/inetd.conf /usr/lib/linuxconf/uninstall/options` ] ; then
			if [ -f /etc/inetd.conf.beforelinuxconf ] ; then
				log rm -f /etc/inetd.conf
				log mv /etc/inetd.conf.beforelinuxconf /etc/inetd.conf
			elif [ -f /usr/lib/linuxconf/uninstall/inetd.conf.beforelinuxconf ] ; then
				log rm -f /etc/inetd.conf
				log mv /usr/lib/linuxconf/uninstall/inetd.conf.beforelinuxconf /etc/inetd.conf
			fi
		fi
	fi

# Backup /etc/conf.linuxconf
	if [ -f /etc/conf.linuxconf ] ; then
		log mv /etc/conf.linuxconf /etc/conf.linuxconf-installed
	fi

# Remove /etc/quota.conf
	if [ -f /etc/quota.conf ] ; then
		log rm -f /etc/quota.conf
	fi

# Get Rid Of The Logs... Even rotated ones :-)
	log rm -f /var/log/htmlaccess.log*
	log rm -f /var/log/netconf.log*
	log rm -f /var/log/boot.log*

# Delete files that may still exist - I hate errors!
	log rm -Rf /usr/lib/linuxconf/uninstall/* 

# Delete pseudo-sysv script needed on enhanced distribution
	if [ "$SYSVLINUXCONF" != "" ] ; then
		if [ "$CHKCONFIG" != "" ] ; then
			PSEUDO=linuxconf-setup
			if [ ! -f $PATHINITD/$PSEUDO ] ; then
				PSEUDO=linuxconf
			fi
			log $CHKCONFIG --del $PSEUDO
			log rm -f $PATHINITD/$PSEUDO
		else
			for dir in $RUNLEVELSPATH
			do
				log rm -f $dir/S00linuxconf $dir/S99linuxconf
				log rm -f $dir/S99linuxconf-setup
			done
		fi
	fi


elif [ "$1" = 1 ] ; then

  	# Someday, we will probably need to do something during an upgrade.
  	# I'm pretty sure Jacques has more features than the subnetted
  	# reverse lookup to add :-)
	true
fi


