#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "vregistry.h"
#include "vregistry.m"
#include <modregister.h>

MODULE_DEFINE_VERSION(vregistry);

PUBLIC MODULE_vregistry::MODULE_vregistry()
	: LINUXCONF_MODULE("vregistry")
{
	linuxconf_loadmsg ("vregistry",PACKAGE_REV);
}



PUBLIC int MODULE_vregistry::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"vregistry")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module vregistry\n"
		 "linuxconf --modulemain vregistry [ specific options ]\n"
		 "\n"
		 "    vregistry --get variable variable\n"
		 "    vregistry --getvalue variable variable\n"
		 "    vregistry --list\n"
		 "    vregistry --set variable value [ variable value ...]\n"
		 "    vregistry --server\n"
		 "\n")
		);
}

PUBLIC void MODULE_vregistry::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

static void vregistry_list ()
{
	master_registry.start_session();
	SSTRING_KEYS tb;
	for (int i=0; i<master_registry.getnb(); i++){
		REGISTER_VARIABLES_OBJ *mod = master_registry.getitem(i);
		for (int j=0; j<mod->getnb(); j++){
			REGISTER_VARIABLE *var = mod->getitem(j);
			SSTRING tmp,suffix;
			if (var->is_record()){
				SSTRING listvar;
				if (var->getlistvar(listvar)==-1){
					suffix.setfrom (".*");
				}else{
					suffix.setfromf (".[%s]",listvar.get());
				}
			}
			tmp.setfromf ("%s.%s%s",mod->get_module_id()
				,var->get_varname()
				,suffix.get());
			tb.add (tmp.get(),var->get_prompt());
		}
	}
	tb.sort();
	for (int i=0; i<tb.getnb(); i++){
		SSTRING_KEY *s = tb.getitem(i);
		printf ("%s\t\"%s\"\n",s->get(),s->getobjval());
	}
	master_registry.end_session();
}
	

PUBLIC int MODULE_vregistry::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"vregistry")==0){
		ret = -1;
		if (perm_rootaccess(MSG_U(P_REGISTRY,"to use the virtual registry"))){
			const char *arg = argv[1];
			error_setmode (true);
			if (argc < 2){
				::usage();
			}else if (strcmp(arg,"--list")==0){
				if (argc != 2){
					::usage();
				}else{
					vregistry_list();
					ret = 0;
				}
			}else if (strcmp(arg,"--get")==0 || strcmp(arg,"--getvalue")==0){
				master_registry.start_session();
				for (int i=2; i<argc; i++){
					const char *var = argv[i];
					SSTRINGS tb;
					int nb = master_registry.getlist(var,tb);
					if (nb >= 0){
						tb.sort();
						if (strcmp(arg,"--get")==0){
							printf ("%s=",var);
							for (int i=0; i<nb; i++){
								printf (i==0 ? "%s" : " %s"
									,tb.getitem(i)->get());
							}
							printf ("\n");
						}else{
							for (int i=0; i<nb; i++){
								printf ("%s\n"
									,tb.getitem(i)->get());
							}
						}
					}else{
						const char *val = master_registry.get(var);
						if (val == NULL){
							val = "";
							fprintf (stderr,MSG_U(E_NOVAR
								,"Variable %s does not exist\n"),var);
						}
						if (strcmp(arg,"--get")==0){
							printf ("%s=%s\n",var,val);
						}else{
							printf ("%s\n",val);
						}
					}
				}
				master_registry.end_session();
			}else if (strcmp(arg,"--set")==0){
				if ((argc & 1) != 0){
					fprintf (stderr,MSG_U(E_PAIRSNEEDED
						,"You must supplied variable/values pairs\n"));
				}else{
					master_registry.start_session();
					for (int i=2; i<argc; i+=2){
						const char *var = argv[i];
						const char *val = argv[i+1];
						if (master_registry.set(var,val) == -1){
							fprintf (stderr,MSG_U(E_NOTSET
								,"Variable %s was not set\n"),var);
						}
					}
					master_registry.end_session();
				}
			}else if (strcmp(arg,"--help")==0){
				::usage();
			}
		}
	}
	return ret;
}


static MODULE_vregistry vregistry;

