/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "usermenu.h"
#include "usermenu.m"

MODULE_DEFINE_VERSION(usermenu);

PUBLIC MODULE_usermenu::MODULE_usermenu()
	: LINUXCONF_MODULE ("usermenu")
{
	linuxconf_loadmsg ("usermenu",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_usermenu::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_CTRL_FILE){
		keymenu = MSG_U(M_usermenu,"User defined menu");
		dia.new_menuitem ("usermenu","",keymenu);
	}
}

PUBLIC int MODULE_usermenu::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_CTRL_FILE){
		if (key == keymenu){
			usermenu_edit ();
		}
	}
	return 0;
}


PUBLIC int MODULE_usermenu::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strncmp(key,"usermenu_",9)==0){
		usermenu_show (key+9);
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module usermenu\n"
		 "linuxconf --modulemain usermenu ID_menu [ specific options ]\n"
		 "\n"
		 "    Supply the menu ID to start the user menu\n"
		 "\n")
		);
}

PUBLIC void MODULE_usermenu::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING(MSG_R(T_USAGE)));
}

PUBLIC int MODULE_usermenu::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"usermenu")==0){
		ret = -1;
		if (argc == 1){
			::usage();
		}else if (argc == 2){
			// Present one menu
			usermenu_show (argv[1]);
		}else{
			::usage();
		}
	}
	return ret;
}

PUBLIC int MODULE_usermenu::message (
	const char *msg,	// message
	int,			// argc
	const char *[])		// argv[]
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(msg,"listspc")==0){
		ret = 0;
		SSTRINGS tb;
		int n = menuedit_getlist(tb);
		if (n > 0){
			tb.sort();

			html_printf ("<hr>\n");
			html_printf ("<center><h1>%s</h1></center>\n"
				,MSG_U(T_MENULIST,"List of user defined menus"));
			html_printf ("<hr>\n");

			html_printf ("<center>\n");
			html_printf ("<table border=1>\n");
			html_printf ("<tr><th>%s<th>%s\n"
				,MSG_U(T_MENUID,"Menu ID")
				,MSG_U(T_MENUDESC,"Description"));
			for (int i=0; i<n; i++){
				const char *menu = tb.getitem(i)->get();
				char href[200];
				sprintf (href,"/htmlmod:usermenu_%s:",menu);
				html_printf ("<tr><td><a href=%s>%s</a>"
					"<td><a href=%s>%s</a>\n"
					,href,menu,href,menuedit_gettitle(menu));
			}
			html_printf ("</table>\n");
			html_printf ("</center>\n");
		}
	}
	return ret;
}


static MODULE_usermenu usermenu;

