#include <sys/types.h>
#include <sys/stat.h>
#include "shellmod.h"
#include "shellmod.m"

HELP_FILE help_shellmod ("shellmod","intro");


const char *tbmenu_ctx[]={
	"MENU_UNKNOWN",
	"MENU_NETWORK_CLIENT",
	"MENU_NETWORK_SERVER",
	"MENU_NETWORK_MISC",
	"MENU_NETWORK_BOOT",
	"MENU_MAIN_CONFIG",
	"MENU_MAIN_CONTROL",
	"MENU_CTRL_FILE",
	"MENU_USER_STD",
	"MENU_USER_SPC",
	"MENU_USER_POLICIES",
	"MENU_USER_ALIAS",
	"MENU_CONTROL_PANEL",
	"MENU_LOGS",
	"MENU_NETWORK_FIREWALL",
	"MENU_SYS_STATUS",
	"MENU_MAILCONF",
	"MENU_MISCSERV",
	"MENU_FSCONF",
	"MENU_MAIN_STATUS",
	"MENU_GURUS",
	"MENU_BOOT",
	"MENU_HARDWARE",
	NULL
};

int tbmenu_nbitem=sizeof(tbmenu_ctx)/sizeof(char*)-1;

void shellmod_build()
{
	DIALOG dia;
	SSTRING path;
	SSTRING menuid;
	SSTRING menutitle;
	char comng = 0;
	char lang = 0;
	static const char *tblang[]={"bash","perl",NULL};
	dia.newf_chkm (MSG_U(F_LANG,"Language"),lang,tblang);
	dia.newf_str (MSG_U(F_PATH,"Path of the module"),path);
	FIELD_COMBO *comb = dia.newf_combo (MSG_U(F_MENUID,"Insert in menu"),menuid);
	comb->addopt ("",MSG_U(F_NOTINMENU,"Do not insert in a menu"));
	for (int i=1; tbmenu_ctx[i] != NULL; i++){
		static const char *tbdesc[]={
			NULL,
			MSG_U(F_MN_CLIENT,"Client section of the network menu"),
			MSG_U(F_MN_SERVER,"Server section of the network menu"),
			MSG_U(F_MN_MISC,"Misc section of the network menu"),
			MSG_U(F_MN_BOOT,"Boot services section of the network menu"),
			MSG_U(F_MAIN_CONFIG,"Config section of the main linuxconf menu"),
			MSG_U(F_MAIN_CONTROL,"Control section of the main linuxconf menu"),
			MSG_U(F_CTRL_FILE,"Control files and systems"),
			MSG_U(F_USER_STD,"Standard user account section"),
			MSG_U(F_USER_SPC,"Special user account section"),
			MSG_U(F_USER_POLICIES,"Policies in user account section"),
			MSG_U(F_USER_ALIAS,"Aliases in user account section"),
			MSG_U(F_CONTROL_PANEL,"Control panel"),
			MSG_U(F_LOGS,"Logs"),
			MSG_U(F_MN_FIREWALL,"Firewalling section of the network menu"),
			MSG_U(F_SYS_STATUS,"System status"),
			MSG_U(F_MAILCONF,"Main menu of the mailconf module"),
			MSG_U(F_MISCSERV,"Miscellaneous services"),
			MSG_U(F_FSCONF,"File systems"),
			MSG_U(F_MAINSTATUS,"Status section of the main linuxconf menu"),
			MSG_U(F_GURUS,"Global configurators/Helper"),
			MSG_U(F_BOOT,"Boot mode and configuration"),
			MSG_U(F_HARD,"Hardware/peripherals configuration"),
		};
		comb->addopt (tbmenu_ctx[i],tbdesc[i]);
	}
	comb->addopt ("dnsconf",MSG_U(F_MENU_DNSCONF,"Main menu of the dnsconf module"));
	dia.newf_str (MSG_U(F_MENUTITLE,"Menu title"),menutitle);
	dia.newf_chk ("",comng,MSG_U(F_COMNG,"This is a user account co-manager"));
	dia.newf_title ("-",MSG_U(T_ENTRIES,"Main menu entries"));
	const int NB_MENU = 10;
	SSTRING tb[NB_MENU];
	for (int i=0; i<NB_MENU; i++){
		dia.newf_str ("",tb[i]);
	}
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_BUILDER,"Module builder")
			,MSG_U(I_BUILDER
				,"You can create a new Linuxconf shell module.\n"
				 "By filling this screen, you will create the basic\n"
				 "framework of the module. Just edit the script\n"
				 "and add functionalities")
			,help_shellmod
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (perm_rootaccess(MSG_U(P_REPLACEFILES,"Replace files"))){
			if (file_exist (path.get())){
				char buf[1000];
				snprintf (buf,sizeof(buf)-1
					,MSG_U(I_REPLACE,"The file %s already exist\n"
						"Do you want to overwrite it ?\n"
						"(the original will be renamed to\n"
						" %s.bak)")
					,path.get(),path.get());

				if (dialog_yesno (MSG_U(Q_REPLACE,"Replace existing file")
					,buf,help_nil)
					!= MENU_YES) continue;
				SSTRING old;
				old.setfrom (path);
				old.append (".bak");
				rename (path.get(),old.get());
			}
			CONFIG_FILE fconf (path.get(),help_nil,CONFIGF_NONE);
			FILE_CFG *fout = fconf.fopen ("w");
			if (fout != NULL){
				if (lang == 0){
					// Bash
					fprintf (fout,"#!/usr/bin/shellmod\n");
					fprintf (fout,"# %s\n",MSG_U(I_SOURCESUP,"Source support function"));
					fprintf (fout,". /usr/lib/linuxconf/lib/shellmod-lib.sh\n");
					fprintf (fout,"\n");
					fprintf (fout,"register(){\n");
					if (!comng && menutitle.is_empty()){
						fprintf (fout,"\t# %s\n"
							,MSG_U(E_NOTAMODULE,"This module can't be"
								" used inside linuxconf"));
						fprintf (fout,"\tqecho retcode -1\n");
						fprintf (fout,"\tqecho error \"%s\"\n",MSG_R(E_NOTAMODULE));
					}else{
						if (comng){
							fprintf (fout,"\tqecho comanager ufct user\n");
						}
						if (!menutitle.is_empty() && !menuid.is_empty()){
							fprintf (fout,"\tqecho regmenu main %s \"%s\"\n"
								,menuid.get(),menutitle.get());
						}
					}
					fprintf (fout,"}\n");
					fprintf (fout,"\n");
					if (comng){
						fprintf (fout,"# %s\n",MSG_U(I_COFCTS,"The various comanager functions"));
						fprintf (fout,"ufct_setupdia(){\n");
						fprintf (fout,"}\n");
						fprintf (fout,"ufct_validate(){\n");
						fprintf (fout,"\t# %s\n",MSG_U(I_ALLISOK,"Tell Linuxconf that all is ok"));
						fprintf (fout,"\t#echo retcode -1\n");
						fprintf (fout,"\techo retcode 0\n");
						fprintf (fout,"}\n");
						fprintf (fout,"# %s\n",MSG_U(I_SAVE,"The user commited the changes, do something"));
						fprintf (fout,"ufct_save(){\n");
						fprintf (fout,"\techo retcode 0\n");
						fprintf (fout,"}\n");
						fprintf (fout,"# %s\n",MSG_U(I_DELUSER,"The account was deleted, do something"));
						fprintf (fout,"ufct_deluser(){\n");
						fprintf (fout,"\techo retcode 0\n");
						fprintf (fout,"}\n");
					}
					bool onemenu = false;
					for (int i=0; i<10; i++){
						if (!tb[i].is_empty()){
							onemenu = true;
							fprintf (fout,"\n");
							fprintf (fout,"# ");
							fprintf (fout,MSG_U(I_MENUFUNC,"Function for menu entry %d"),i+1);
							fprintf (fout,"\n");
							fprintf (fout,"menufunc%d(){\n",i+1);
							fprintf (fout,"}\n");
						}
					}
					fprintf (fout,"\n");
					fprintf (fout,"# %s\n",MSG_U(I_MODULEMAIN,"Module entry point"));
					fprintf (fout,"main(){\n");
					if (onemenu){
						// Create a menu
						fprintf (fout,"\tqecho DIALOG_MENU\n");
						for (int i=0; i<NB_MENU; i++){
							if (!tb[i].is_empty()){
								fprintf (fout,"\tqecho new_menuitem menufunc%d \"%s\"\n"
									,i+1,tb[i].get());
							}
						}
						fprintf (fout,"\tqecho editmenu \"Main menu\"\n");
						fprintf (fout,"\tdispatch\n");
						fprintf (fout,"\techo end\n");
					}
					fprintf (fout,"}\n");
					fprintf (fout,"\n");
					fprintf (fout,"dispatch\n");				
				}else if (lang == 1){
					// Perl
					fprintf (fout,"#!/usr/bin/shellmod --perl\n");
					fprintf (fout,"# %s\n",MSG_R(I_SOURCESUP));
					fprintf (fout,"require \"/usr/lib/linuxconf/lib/shellmod-lib.pl\";\n");
					fprintf (fout,"\n");
					fprintf (fout,"sub register\n{\n");
					if (!comng && menutitle.is_empty()){
						fprintf (fout,"\t# %s\n",MSG_R(E_NOTAMODULE));
						fprintf (fout,"\terror(\"%s\");\n",MSG_R(E_NOTAMODULE));
						fputs ("\tretcode(-1);\n",fout);
					}else{
						if (comng){
							fprintf (fout,"\tcomanager(\"ufct\",\"user\");\n");
						}
						if (!menutitle.is_empty() && !menuid.is_empty()){
							fprintf (fout,"\tregmenu(\"main\",\"%s\",\"%s\");\n"
								,menuid.get(),menutitle.get());
						}
					}
					fprintf (fout,"}\n");
					fprintf (fout,"\n");
					if (comng){
						fprintf (fout,"# %s\n",MSG_R(I_COFCTS));
						fprintf (fout,"sub ufct_setupdia\n{\n");
						fprintf (fout,"}\n");
						fprintf (fout,"sub ufct_validate\n{\n");
						fprintf (fout,"\t# %s\n",MSG_R(I_ALLISOK));
						fprintf (fout,"\t#retcode(-1);\n");
						fprintf (fout,"\tretcode(0);\n");
						fprintf (fout,"}\n");
						fprintf (fout,"# %s\n",MSG_R(I_SAVE));
						fprintf (fout,"sub ufct_save\n{\n");
						fprintf (fout,"\tretcode(0);\n");
						fprintf (fout,"}\n");
						fprintf (fout,"# %s\n",MSG_R(I_DELUSER));
						fprintf (fout,"sub ufct_deluser\n{\n");
						fprintf (fout,"\tretcode(0);\n");
						fprintf (fout,"}\n");
					}
					bool onemenu = false;
					for (int i=0; i<10; i++){
						if (!tb[i].is_empty()){
							onemenu = true;
							fprintf (fout,"\n");
							fprintf (fout,"# ");
							fprintf (fout,MSG_R(I_MENUFUNC),i+1);
							fprintf (fout,"\n");
							fprintf (fout,"sub menufunc%d\n{\n",i+1);
							fprintf (fout,"}\n");
						}
					}
					fprintf (fout,"\n");
					fprintf (fout,"# %s\n",MSG_R(I_MODULEMAIN));
					fprintf (fout,"sub main\n{\n");
					if (onemenu){
						// Create a menu
						fprintf (fout,"\tdialog_menu();\n");
						for (int i=0; i<NB_MENU; i++){
							if (!tb[i].is_empty()){
								fprintf (fout,"\tnew_menuitem(\"menufunc%d\",\"%s\");\n"
									,i+1,tb[i].get());
							}
						}
						fprintf (fout,"\teditmenu(\"Main menu\",\"\");\n");
						fprintf (fout,"\tdispatch();\n");
						fprintf (fout,"\tend();\n");
					}
					fprintf (fout,"}\n");
					fprintf (fout,"\n");
					fprintf (fout,"dispatch();\n");				
				}
				fclose (fout);
			}
			chmod (path.get(),0755);
			break;
		}
	}
}

