#include "redhatppp.h"
#include "redhatppp.m"
#include "../../paths.h"
#include <confdb.h>
#include <string.h>

extern HELP_FILE help_ptp;


static CONFIG_FILE f_wvdial (ETC_WVDIAL_CONF
	,help_ptp
	,CONFIGF_MANAGED|CONFIGF_OPTIONAL
	,"root","root",0600,subsys_dialout);

/*
	Return true if /etc/wvdial.conf exists
*/
bool wvdial_is_installed()
{
	return f_wvdial.exist();
}

static const char STUPIDMODE[]="Stupid Mode";

/*
	Delete config from /etc/wvdial.conf
*/
void wvdial_delete (const char *config)
{
	/* #Specification: /etc/wvdial.conf / conditionnal updates
		The redhatppp module only update the /etc/wvdial.conf if it
		exist.
	*/
	if (f_wvdial.exist()){
		CONFDB conf (f_wvdial,true,';');
		SSTRING subsys;
		subsys.setfromf("Dialer %s",config);
		conf.delsys (subsys.get());
		conf.save();
	}
}

/*
	Update /etc/wvdial.conf
*/
void wvdial_update (
	const char *config,
	const char *login,
	const char *passwd,
	const char *init,
	const char *phone,
	const char *modemport,
	const char *linespeed,
        const char *modemdial,
        bool stupidmode)
{
	/* #Specification: /etc/wvdial.conf / conditionnal updates
		The redhatppp module only update the /etc/wvdial.conf if it
		exist.
	*/
	if (f_wvdial.exist()){
		CONFDB conf (f_wvdial,true,';');
		SSTRING subsys;
		subsys.setfromf("Dialer %s",config);
		conf.setcursys (subsys.get(),true);
		conf.replacek ("Modem",modemport);
		conf.replacek ("Baud",linespeed);
		conf.replacek ("Init1",init);
		conf.replacek ("Phone",phone);
		conf.replacek ("Username",login);
		conf.replacek ("Password",passwd);
		conf.replacek ("Dial Command",modemdial);
                conf.replacek (STUPIDMODE,stupidmode ? "yes" : "no");
		conf.save();
	}
}

/*
	Return the stupidmode setting as stored in wvdial.conf
*/
bool wvdial_getstupidmode(const char *config)
{
	bool ret = false;
	if (f_wvdial.exist()){
		CONFDB conf (f_wvdial,true,';');
		SSTRING subsys;
		subsys.setfromf("Dialer %s",config);
		conf.setcursys (subsys.get(),true);
		const char *val = conf.getvalk (STUPIDMODE,"no");
		if (strcmp(val,"yes")==0
			|| strcmp(val,"1")==0
			|| strcmp(val,"true")==0) ret = true;
	}
	return ret;
}

