
/* this configuration deals with the 'huntgroups' file */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "radiusconf.h"
#include "radiusconf.m"

#include "rc_parser.h"
#include "rc_tools.h"


void edit_huntgroup_properties(int which_group, VIEWITEMS &given_vitems)
{
    DIALOG      my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    SSTRING     dialog_title;
    SSTRINGS    level_one_vars; // all level-1 vars indexed here
                                  // (used to check if all are empty -- it would be unacceptable)

    level_one_vars.neverdelete();
    my_dialog.setbutinfo(MENU_USR1, MSG_R(B_MOVE), NULL);

    /* loads vars.. */
    /* builds gui.. */
    EASY_TITLE(MSG_U(F_HUNTGROUPNAME,"Hunt group:"));
    /* level 0 */
    my_dialog.newf_title(MSG_U(X_MATCHHG,"Match"), 1, "", MSG_R(X_MATCHHG));
    EASY_STR(s0_nasipaddress,"NAS-IP-Address",0,MSG_U(F_NASIPADDRESSHG1,"NAS IP address:"));
    EASY_STR(s0_nasportid,"NAS-Port-Id",0,MSG_U(F_NASPORTIDHG1,"NAS port id:"));
    /* level 1 */
    my_dialog.newf_title(MSG_U(X_CHANGESHG,"Affects"), 1, "", MSG_R(X_CHANGESHG));
    EASY_TEXT("User-Name",1,s1_username,MSG_U(F_USERNAMEHG,"User name:"));
    EASY_TEXT("Group",1,s1_groupname,MSG_U(F_GROUPNAMEHG,"Group:"));

    while(1){
        /* opens dialog.. */
        dialog_title.setfromf(MSG_U(T_HUNTGROUPENTRYN,"Huntgroup entry %d"), which_group+1);
        my_selection=0;
        my_button=my_dialog.editmenu(dialog_title.get(), "", hf_huntgroups, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL|MENUBUT_USR1);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ACCEPT:
            {
                if(invalid_entry(my_group_title.get())){
                    informative_window(MSG_U(T_INVALIDNAMEPROVIDED,"Invalid name provided"), MSG_U(E_INVALIDNAMEPROVIDED,"The name can't be empty\nneither have spaces within."));
                }else{
                    /* save vars.. */
                    EASY_TITLE_WRITE;
                    /* level 0 */
                    EASY_SSTRING_WRITE(s0_nasipaddress,"NAS-IP-Address",0);
                    EASY_SSTRING_WRITE(s0_nasportid,"NAS-Port-Id",0);
                    /* level 1 */
                    EASY_TEXT_WRITE(s1_username,"User-Name",1);
                    EASY_TEXT_WRITE(s1_groupname,"Group",1);

                    given_vitems.write(cf_huntgroups, 0);
                    return;
                }
            }
            break;
        case MENU_DEL:
            /* remove this entry */
            delete_whole_group(given_vitems, which_group);
            given_vitems.write(cf_huntgroups, 0);
            return;
            break;
        case MENU_USR1:
            /* move group */
            {
                int my_temp;

                my_temp=select_new_position(given_vitems, MSG_U(T_SELECTNEWPOSHG,"Select new position"), MSG_U(X_SELECTNEWPOSHG,"user name\tmatch"), MSG_R(X_LASTPOSITION));
                if(my_temp!=-1){
                    move_group(given_vitems, which_group, my_temp);
                    given_vitems.write(cf_huntgroups, 0);
                    return;
                }
            }
            break;
        default:
            break;
        }
    }




}


void show_huntgroups_list(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    VIEWITEMS_PARSER my_vitems_parser;
    VIEWITEMS my_vitems(my_vitems_parser);

    my_vitems.read(cf_huntgroups);

    my_dialog.newf_head("", MSG_U(X_HUNTGROUPMATCH,"huntgroup\tmatch"));

    while(1){
        int         progressive_counter=0;
        SSTRING     username_to_insert,
                    match_to_insert;

        /* fills list.. */
        while(returns_data_for_list(my_vitems, progressive_counter, match_to_insert, username_to_insert)){
            my_dialog.set_menuitem(progressive_counter, username_to_insert.get(), match_to_insert.get());
            progressive_counter++;
        }

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(progressive_counter+1);

        my_button=my_dialog.editmenu(MSG_U(T_HUNTGROUPSENTRIES,"Huntgroups entries"), MSG_R(I_SENSITIVE2POSITIONS), hf_general_list2, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                int how_many;

                how_many=how_many_groups_are(my_vitems);
                create_new_group(my_vitems, MSG_U(X_SAMPLEHUNTGROUPS,"this_is_my_group_name\tNAS-IP-Address = 1.2.3.4"));
                edit_user_properties(how_many, my_vitems);
                my_vitems.write(cf_huntgroups, 0);
            }
            break;
        default:
            {
                edit_huntgroup_properties(my_selection, my_vitems);

                break;
            }
        }
    }





}

