#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static PyObject *
lcutil_xconf_notice(PyObject *self, PyObject *args)
{
	char *s;
	if (!PyArg_ParseTuple(args,"s",&s))
		return NULL;
	xconf_notice("%s",s);
	signal(SIGCHLD, SIG_DFL);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
lcutil_xconf_error(PyObject *self, PyObject *args)
{
	char *s;
	if (!PyArg_ParseTuple(args,"s",&s))
		return NULL;
	xconf_error("%s",s);
	signal(SIGCHLD, SIG_DFL);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
lcutil_xconf_yesno(PyObject *self, PyObject *args)
{
	char *t,*p;
	MENU_STATUS s;
	PyObject *pret;
	const char *ret;
	if (!PyArg_ParseTuple(args,"ss",&t,&p))
		return NULL;
	s = xconf_yesno(t,p,help_nil);
	signal(SIGCHLD, SIG_DFL);
	switch (s) {
		case MENU_YES: ret = "yes"; break;
		case MENU_NO: ret = "no"; break;
		case MENU_ESCAPE: ret = "escape"; break;
		default: ret = "default";
	}
	pret = PyString_FromString(ret);
	return pret;
}

static PyObject *
lcutil_xconf_quitwosave(PyObject *self, PyObject *args)
{
	int ret = xconf_quitwosave();
	signal(SIGCHLD, SIG_DFL);
	return PyInt_FromLong(ret);
}

static PyObject *
lcutil_xconf_areyousure(PyObject *self, PyObject *args)
{
	char *s;
	if (!PyArg_ParseTuple(args,"s",&s))
		return NULL;
	int ret = xconf_areyousure(s);
	signal(SIGCHLD, SIG_DFL);
	return PyInt_FromLong(ret);
}

static PyObject *
lcutil_xconf_delok(PyObject *self, PyObject *args)
{
	int ret = xconf_delok();
	signal(SIGCHLD, SIG_DFL);
	return PyInt_FromLong(ret);
}

static PyObject *
lcutil_net_prtlog(PyObject *self, PyObject *args)
{
	int level;
	char *str;
	if (!PyArg_ParseTuple(args,"is",&level,&str))
		return NULL;
	net_prtlog(level,"%s\n",str);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
lcutil_dialog_mode(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return PyInt_FromLong(dialog_mode);
}


static struct PyMethodDef lcutil_methods[] = {
	{"xconf_notice", lcutil_xconf_notice, 1},
	{"xconf_error", lcutil_xconf_error, 1},
	{"xconf_yesno", lcutil_xconf_yesno, 1},
	{"xconf_quitwosave", lcutil_xconf_quitwosave, 1},
	{"xconf_areyousure", lcutil_xconf_areyousure, 1},
	{"xconf_delok", lcutil_xconf_delok, 1},
	{"net_prtlog", lcutil_net_prtlog, 1},
	{"dialog_mode", lcutil_dialog_mode, 1},
	{NULL, NULL}
};

extern "C" void
initlcutil()
{
	PyObject *m, *d;
	m = Py_InitModule("lcutil", lcutil_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcutil.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcutil");
}
