#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static PyObject *
LCChar_set(LCCharObject *self, PyObject *args)
{
	int i;
	if (!PyArg_ParseTuple(args,"i",&i))
		return NULL;
	*self->c = i;
	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef LCChar_methods[] = {
	{"set", (binaryfunc) LCChar_set, 1},
	{NULL, NULL}
};

static void
LCChar_dealloc(LCCharObject *self)
{
	if (self->owner)
		delete self->c;
	PyMem_DEL(self);
}

static PyObject *
LCChar_getattr(LCCharObject *self, char *name)
{
	return Py_FindMethod(LCChar_methods, (PyObject*) self, name);
}

static PyObject *
LCChar_repr(LCCharObject *self)
{
	char tmp[4];
	sprintf(tmp,"%d",*self->c);
	return PyString_FromString(tmp);
}

static PyNumberMethods LCCharNumberMethods = {
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(ternaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(inquiry) 0,
	(unaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(binaryfunc) 0,
	(coercion) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0,
	(unaryfunc) 0
};
	
PyTypeObject LCChar_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCChar",
	sizeof(LCCharObject),
	0,
	(destructor) LCChar_dealloc,
	(printfunc) 0,
	(getattrfunc) LCChar_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) LCChar_repr,
	&LCCharNumberMethods,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCChar_New(int i)
{
	LCCharObject *self;
	self = PyObject_NEW(LCCharObject, &LCChar_Type);
	if (self == NULL)
		return NULL;
	self->c = new char(i);
	self->owner = 1;
	return (PyObject*) self;
}

PyObject *
LCChar_FromChar(char *c)
{
	LCCharObject *self;
	self = PyObject_NEW(LCCharObject, &LCChar_Type);
	if (self == NULL)
		return NULL;
	self->c = c;
	self->owner = 0;
	return (PyObject*) self;
}

PyObject *
LCChar_FromCharDealloc(char *c)
{
	LCCharObject *self;
	self = PyObject_NEW(LCCharObject, &LCChar_Type);
	if (self == NULL)
		return NULL;
	self->c = c;
	self->owner = 1;
	return (PyObject*) self;
}

static PyObject *
lcchar_LCChar(PyObject *self, PyObject *args)
{
	int i = 0;
	if (!PyArg_ParseTuple(args, "|i", &i))
		return NULL;
	return LCChar_New(i);
}

static struct PyMethodDef lcchar_methods[] = {
	{"LCChar", lcchar_LCChar, 1},
	{NULL,NULL}
};

extern "C" void
initlcchar()
{
	PyObject *m, *d;
	m = Py_InitModule("lcchar", lcchar_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcchar.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcchar");
}
