/* manages the /etc/security/access.conf file */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "pamconf.h"
#include "pamconf.m"
#include "pamconf_tools.h"
#include "fviews.h"

#define append_selector(a,b,c) a=my_dialog.newf_list(b, c);\
    a->addopt("", str_onlylist, "");\
    a->addopt("ALL", str_all, "")
#define append_selector2(a,b,c) a=my_dialog.newf_list(b, c);\
    a->addopt("none", str_none, "");\
    a->addopt("", str_onlylist, "")
#define append_selector3(a,b,c) a=my_dialog.newf_list(b, c);\
    a->addopt("", str_onlylist, "");\
    a->addopt("LOCAL", str_local, "");\
    a->addopt("ALL", str_all, "")
#define append_selector4(a,b,c) a=my_dialog.newf_list(b, c);\
    a->addopt("none", str_none, "");\
    a->addopt("", str_onlylist, "");\
    a->addopt("LOCAL", str_local, "")

/* adds space if previous character is not ':' */
void smart_append(SSTRING &given_string, SSTRING &append_to)
{
    if(given_string.getlen()){
        if(append_to.getlen()){
            if(*(append_to.get()+append_to.getlen()-1)!=':')
                append_to.append(" ");
        }
        append_to.append(given_string.get());
    }
}

/* fills with proper data, if there's 'ALL' or 'LOCAL' or none in string
 it also removes the 'ALL' and 'LOCAL' from string, if found
 -- case insensitive */
void fill_with_proper_extra(SSTRING &given_string, SSTRING &dump_here)
{
    SSTRING trashcan;

    dump_here.setfrom("");
    if(detect_and_erase(given_string, "LOCAL"))
        dump_here.setfrom("LOCAL");
    if(detect_and_erase(given_string, "ALL"))
        dump_here.setfrom("ALL");

    /* if string is completely empty, put 'none' */
    if(!*(dump_here.get())){
        if(!gimme_word_from_string(given_string.get(), trashcan, 0))
            dump_here.setfrom("none");
    }
}

/* break a line in before 'EXCEPT' and after 'EXCEPT' */
void break_in_two(SSTRING &given_string, SSTRING &dump_here1, SSTRING &dump_here2)
{
    char *my_buff;
    char *where_is_except=NULL;
    char *where_is_str2=NULL;
    char except_str[]="EXCEPT\0";

    dump_here1.setfrom("");
    dump_here2.setfrom("");

    if((my_buff=(char *)malloc(strlen(given_string.get())+1))){
        strcpy(my_buff, given_string.get());
        if((where_is_except=ci_strstr(my_buff, except_str))){
            *where_is_except=0;
            where_is_str2=where_is_except+strlen(except_str);
            while((*where_is_str2)&&(*where_is_str2<33))
                where_is_str2++;
            dump_here2.setfrom(where_is_str2);
        }
        dump_here1.setfrom(my_buff);

        free(my_buff);
    }
}

void line_properties(int which_line, VIEWITEMS &given_vitems)
{
    DIALOG my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    FIELD_LIST  *fl_permission;
    FIELD_LIST  *fl_ui, *fl_ue, *fl_oi, *fl_oe;
    SSTRING     *current_line;
    SSTRING     title_text;

    /* vars readen directy from line */
    SSTRING permission, users, origins;
    SSTRING u_include, u_except, o_include, o_except;
    SSTRING ui_append, ue_append, oi_append, oe_append;

    SSTRING sstr_onlylist, sstr_local, sstr_all, sstr_none;
    const char *str_onlylist, *str_local, *str_all, *str_none;

    sstr_onlylist.setfromf(MSG_U(X_THEBELOWONES, "The below ones"));
    sstr_local.setfromf(MSG_U(X_LOCALANDBELOW, "LOCAL ones and the below ones"));
    sstr_all.setfromf(MSG_U(X_ALLONES, "ALL"));
    sstr_none.setfromf(MSG_U(X_NONEATALL, "None"));
    str_onlylist=sstr_onlylist.get();
    str_local=sstr_local.get();
    str_all=sstr_all.get();
    str_none=sstr_none.get();

    title_text.setfromf(MSG_U(T_ENTRYNFORACCDEFS, "Entry #%d for access definitions"), which_line+1);

    current_line=&(given_vitems.getitem(which_line)->line);

    /* load vars */
    gimme_word_from_string_bchar((*current_line).get(), permission, 0, ':');
    gimme_word_from_string_bchar((*current_line).get(), users, 1, ':');
    gimme_word_from_string_bchar((*current_line).get(), origins, 2, ':');
    /* first let's process these strings a bit more.. */
    break_in_two(users, u_include, u_except);
    break_in_two(origins, o_include, o_except);
    fill_with_proper_extra(u_include, ui_append);
    fill_with_proper_extra(u_except, ue_append);
    fill_with_proper_extra(o_include, oi_append);
    fill_with_proper_extra(o_except, oe_append);
    convert_to_textarea(u_include);
    convert_to_textarea(u_except);
    convert_to_textarea(o_include);
    convert_to_textarea(o_except);
    /* 'none' shall *not* appear on these variables.. */
    if(!strcmp("none", ui_append.get()))
        ui_append.setfrom("");
    if(!strcmp("none", oi_append.get()))
        oi_append.setfrom("");

    /* builds gui */
    fl_permission=my_dialog.newf_list(MSG_U(F_ACCPERM, "Permission:"), permission);
    fl_permission->addopt("+", MSG_R(X_ALLOW), "");
    fl_permission->addopt("-", MSG_R(X_DISALLOW), "");
    my_dialog.newf_title(MSG_U(F_ACCUSERSGROUPS, "Users/Groups"), 1, "", MSG_R(F_ACCUSERSGROUPS));
    append_selector(fl_ui,MSG_U(F_ACCINCLUDE, "Include:"),ui_append);
    my_dialog.newf_textarea("", u_include, 30, 4);
    append_selector2(fl_ue,MSG_U(F_ACCEXCEPT, "Except:"),ue_append);
    my_dialog.newf_textarea("", u_except, 30, 4);
    my_dialog.newf_title(MSG_U(F_ACCLOGINSFROM, "Logins from"), 1, "", MSG_R(F_ACCLOGINSFROM));
    append_selector3(fl_oi,MSG_R(F_ACCINCLUDE),oi_append);
    my_dialog.newf_textarea("", o_include, 30, 4);
    append_selector4(fl_oe,MSG_R(F_ACCEXCEPT),oe_append);
    my_dialog.newf_textarea("", o_except, 30, 4);

    while(1){
        /* opens dialog.. */
        my_selection=0;
        my_button=my_dialog.editmenu(title_text.get(), "", hf_pam_access, my_selection, MENUBUT_QUIT|MENUBUT_DEL|MENUBUT_ACCEPT);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_DEL:
            if(confirm_yesno_window(MSG_U(T_ACCENTRYREMOVAL, "Entry removal"), MSG_U(I_ACCENTRYREMOVAL, "Do you really want\nto remove this definition?"))){
                given_vitems.remove_del(which_line);
                given_vitems.write(cf_access, NULL);
                return;
            }
            break;
        case MENU_ACCEPT:
            {
                SSTRING aux_string;

                convert_from_textarea(u_include);
                convert_from_textarea(u_except);
                convert_from_textarea(o_include);
                convert_from_textarea(o_except);

                current_line->setfromf("%s:%s", permission.get(), ui_append.get());
                if(text_not_empty(u_include))
                    smart_append(u_include, *current_line);
                if(text_not_empty(u_except)&&strcmp(ue_append.get(), "none")){
                    current_line->append(" EXCEPT");
                    smart_append(ue_append, *current_line);
                    smart_append(u_except, *current_line);
                }
                current_line->append(":");
                smart_append(oi_append, *current_line);
                if(text_not_empty(o_include))
                    smart_append(o_include, *current_line);
                if(text_not_empty(o_except)&&strcmp(oe_append.get(), "none")){
                    current_line->append(" EXCEPT");
                    smart_append(oe_append, *current_line);
                    smart_append(o_except, *current_line);
                }

                /* writes to file */
                given_vitems.write(cf_access, NULL);
            }

            return;
            break;
        default:
            break;
        }
    }
}

void access_window(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    VIEWITEMS_PARSER pre_my_vitems;

    while(1){
        VIEWITEMS my_vitems(pre_my_vitems);
        my_vitems.read(cf_access); // load file data

        my_dialog.remove_all(); // cleans window
        my_dialog.newf_head("", MSG_U(F_ACCPUL, "permissions\tuser\tlogin"));
        dump_viewitems_to_list(my_dialog, my_vitems, 3, ':');

        /* opens dialog.. */
        my_selection=0;
        my_button=my_dialog.editmenu(MSG_U(T_ACCLOGINACCESS, "Login accesses (pam_access.so)"), MSG_U(I_ACCLOGINACCESS, "Here it's possible to define which users\nmay login through which terminals."), hf_list_edit, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            my_vitems.add(new VIEWITEM(MSG_U(X_ACC_SAMPLE, "-:some_username another_username:some_console")));
            line_properties(my_vitems.getnb()-1, my_vitems);
            break;
        default:
            line_properties(my_selection, my_vitems);
            break;
        }
    }
}


